/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.rest.BaseSolrResource;
import org.apache.solr.rest.GETable;
import org.apache.solr.rest.POSTable;
import org.apache.solr.rest.schema.BaseFieldResource;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.SchemaField;
import org.noggit.ObjectBuilder;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldCollectionResource
extends BaseFieldResource
implements GETable,
POSTable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean includeDynamic;

    @Override
    public void doInit() throws ResourceException {
        super.doInit();
        if (this.isExisting()) {
            this.includeDynamic = this.getSolrRequest().getParams().getBool("includeDynamic", false);
        }
    }

    @Override
    public Representation get() {
        try {
            ArrayList<SimpleOrderedMap<Object>> props = new ArrayList<SimpleOrderedMap<Object>>();
            if (null == this.getRequestedFields()) {
                TreeSet<String> fieldNames = new TreeSet<String>(this.getSchema().getFields().keySet());
                for (String fieldName : fieldNames) {
                    props.add(this.getFieldProperties(this.getSchema().getFields().get(fieldName)));
                }
            } else {
                if (0 == this.getRequestedFields().size()) {
                    String message = "Empty fl parameter value";
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
                }
                for (String fieldName : this.getRequestedFields()) {
                    SchemaField field = this.includeDynamic ? this.getSchema().getFieldOrNull(fieldName) : this.getSchema().getFields().get(fieldName);
                    if (null == field) {
                        log.info("Requested field '" + fieldName + "' not found.");
                        continue;
                    }
                    props.add(this.getFieldProperties(field));
                }
            }
            this.getSolrResponse().add("fields", props);
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSolrResource.SolrOutputRepresentation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Representation post(Representation entity) {
        try {
            if (!this.getSchema().isMutable()) {
                String message = "This IndexSchema is not mutable.";
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "This IndexSchema is not mutable.");
            }
            if (null == entity.getMediaType()) {
                entity.setMediaType(MediaType.APPLICATION_JSON);
            }
            if (!entity.getMediaType().equals((Object)MediaType.APPLICATION_JSON, true)) {
                String message = "Only media type " + MediaType.APPLICATION_JSON.toString() + " is accepted." + "  Request has media type " + entity.getMediaType().toString() + ".";
                log.error(message);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
            }
            Object object = ObjectBuilder.fromJSON(entity.getText());
            if (!(object instanceof List)) {
                String message = "Invalid JSON type " + object.getClass().getName() + ", expected List of the form" + " (ignore the backslashes): [{\"name\":\"foo\",\"type\":\"text_general\", ...}, {...}, ...]";
                log.error(message);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
            }
            List list = (List)object;
            ArrayList<SchemaField> newFields = new ArrayList<SchemaField>();
            ArrayList<BaseFieldResource.NewFieldArguments> newFieldArguments = new ArrayList<BaseFieldResource.NewFieldArguments>();
            IndexSchema oldSchema = this.getSchema();
            HashMap<String, Collection<String>> copyFields = new HashMap<String, Collection<String>>();
            for (Map map : list) {
                String fieldName = (String)map.remove("name");
                if (null == fieldName) {
                    String message = "Missing 'name' mapping.";
                    log.error(message);
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
                }
                String fieldType = (String)map.remove("type");
                if (null == fieldType) {
                    String message = "Missing 'type' mapping.";
                    log.error(message);
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
                }
                Object copies = map.get("copyFields");
                List<String> copyTo = null;
                if (copies != null) {
                    if (copies instanceof List) {
                        copyTo = (List<String>)copies;
                    } else if (copies instanceof String) {
                        copyTo = Collections.singletonList(copies.toString());
                    } else {
                        String message = "Invalid 'copyFields' type.";
                        log.error(message);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
                    }
                }
                if (copyTo != null) {
                    map.remove("copyFields");
                    copyFields.put(fieldName, copyTo);
                }
                newFields.add(oldSchema.newField(fieldName, fieldType, map));
                newFieldArguments.add(new BaseFieldResource.NewFieldArguments(fieldName, fieldType, map));
            }
            IndexSchema newSchema = null;
            boolean firstAttempt = true;
            boolean success = false;
            while (!success) {
                try {
                    if (!firstAttempt) {
                        newFields.clear();
                        for (BaseFieldResource.NewFieldArguments args : newFieldArguments) {
                            newFields.add(oldSchema.newField(args.getName(), args.getType(), args.getMap()));
                        }
                    }
                    firstAttempt = false;
                    Object i$ = oldSchema.getSchemaUpdateLock();
                    synchronized (i$) {
                        newSchema = oldSchema.addFields(newFields, copyFields, true);
                        if (null == newSchema) {
                            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to add fields.");
                        }
                        this.getSolrCore().setLatestSchema(newSchema);
                        success = true;
                    }
                }
                catch (ManagedIndexSchema.SchemaChangedInZkException e) {
                    log.debug("Schema changed while processing request, retrying");
                    oldSchema = this.getSolrCore().getLatestSchema();
                }
            }
            this.waitForSchemaUpdateToPropagate(newSchema);
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSolrResource.SolrOutputRepresentation();
    }
}

