/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.loader;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.request.JavaBinUpdateRequestCodec;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.FastInputStream;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.handler.loader.ContentStreamLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;

public class JavabinLoader
extends ContentStreamLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(SolrQueryRequest req, SolrQueryResponse rsp, ContentStream stream, UpdateRequestProcessor processor) throws Exception {
        try (InputStream is = null;){
            is = stream.getStream();
            this.parseAndLoadDocs(req, rsp, is, processor);
        }
    }

    private void parseAndLoadDocs(final SolrQueryRequest req, SolrQueryResponse rsp, InputStream stream, final UpdateRequestProcessor processor) throws IOException {
        UpdateRequest update = null;
        JavaBinUpdateRequestCodec.StreamingUpdateHandler handler = new JavaBinUpdateRequestCodec.StreamingUpdateHandler(){
            private AddUpdateCommand addCmd = null;

            @Override
            public void update(SolrInputDocument document, UpdateRequest updateRequest, Integer commitWithin, Boolean overwrite) {
                if (document == null) {
                    try {
                        RequestHandlerUtils.handleCommit(req, processor, updateRequest.getParams(), false);
                        RequestHandlerUtils.handleRollback(req, processor, updateRequest.getParams(), false);
                    }
                    catch (IOException e) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "ERROR handling commit/rollback");
                    }
                    return;
                }
                if (this.addCmd == null) {
                    this.addCmd = JavabinLoader.this.getAddCommand(req, updateRequest.getParams());
                }
                this.addCmd.solrDoc = document;
                if (commitWithin != null) {
                    this.addCmd.commitWithin = commitWithin;
                }
                if (overwrite != null) {
                    this.addCmd.overwrite = overwrite;
                }
                if (updateRequest.isLastDocInBatch()) {
                    this.addCmd.isLastDocInBatch = true;
                }
                try {
                    processor.processAdd(this.addCmd);
                    this.addCmd.clear();
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "ERROR adding document " + document, (Throwable)e);
                }
            }
        };
        FastInputStream in = FastInputStream.wrap(stream);
        while (true) {
            try {
                update = new JavaBinUpdateRequestCodec().unmarshal(in, handler);
            }
            catch (EOFException e) {
                break;
            }
            if (update.getDeleteByIdMap() == null && update.getDeleteQuery() == null) continue;
            this.delete(req, update, processor);
        }
    }

    private AddUpdateCommand getAddCommand(SolrQueryRequest req, SolrParams params) {
        AddUpdateCommand addCmd = new AddUpdateCommand(req);
        addCmd.pollQueueTime = pollQueueTime;
        addCmd.overwrite = params.getBool("overwrite", true);
        addCmd.commitWithin = params.getInt("commitWithin", -1);
        return addCmd;
    }

    private void delete(SolrQueryRequest req, UpdateRequest update, UpdateRequestProcessor processor) throws IOException {
        ModifiableSolrParams params = update.getParams();
        DeleteUpdateCommand delcmd = new DeleteUpdateCommand(req);
        if (params != null) {
            delcmd.commitWithin = params.getInt("commitWithin", -1);
        }
        if (update.getDeleteByIdMap() != null) {
            Set<Map.Entry<String, Map<String, Object>>> entries = update.getDeleteByIdMap().entrySet();
            for (Map.Entry<String, Map<String, Object>> e : entries) {
                String route;
                Long version;
                delcmd.id = e.getKey();
                Map<String, Object> map = e.getValue();
                if (map != null && (version = (Long)map.get("ver")) != null) {
                    delcmd.setVersion(version);
                }
                if (map != null && (route = (String)map.get("_route_")) != null) {
                    delcmd.setRoute(route);
                }
                processor.processDelete(delcmd);
                delcmd.clear();
            }
        }
        if (update.getDeleteQuery() != null) {
            Iterator<String> i$ = update.getDeleteQuery().iterator();
            while (i$.hasNext()) {
                String s;
                delcmd.query = s = i$.next();
                processor.processDelete(delcmd);
            }
        }
    }
}

