/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.URLUtil;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.handler.component.HttpShardHandler;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.update.UpdateShardHandler;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpShardHandlerFactory
extends ShardHandlerFactory
implements PluginInfoInitialized {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String DEFAULT_SCHEME = "http";
    private ThreadPoolExecutor commExecutor = new ExecutorUtil.MDCAwareThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DefaultSolrThreadFactory("httpShardExecutor"));
    protected PoolingClientConnectionManager clientConnectionManager;
    protected CloseableHttpClient defaultClient;
    private LBHttpSolrClient loadbalancer;
    int soTimeout = 600000;
    int connectionTimeout = 60000;
    int maxConnectionsPerHost = 20;
    int maxConnections = 10000;
    int corePoolSize = 0;
    int maximumPoolSize = Integer.MAX_VALUE;
    int keepAliveTime = 5;
    int queueSize = -1;
    boolean accessPolicy = false;
    boolean useRetries = false;
    int maxConnectionIdleTime = 40000;
    int connectionsEvictorSleepDelay = 5000;
    protected UpdateShardHandler.IdleConnectionsEvictor idleConnectionsEvictor;
    private String scheme = null;
    private final Random r = new Random();
    static final String INIT_URL_SCHEME = "urlScheme";
    static final String INIT_CORE_POOL_SIZE = "corePoolSize";
    static final String INIT_MAX_POOL_SIZE = "maximumPoolSize";
    static final String MAX_THREAD_IDLE_TIME = "maxThreadIdleTime";
    static final String INIT_SIZE_OF_QUEUE = "sizeOfQueue";
    static final String INIT_FAIRNESS_POLICY = "fairnessPolicy";
    static final String USE_RETRIES = "useRetries";
    static final String CONNECTIONS_EVICTOR_SLEEP_DELAY = "connectionsEvictorSleepDelay";
    static final String MAX_CONNECTION_IDLE_TIME = "maxConnectionIdleTime";

    @Override
    public ShardHandler getShardHandler() {
        return this.getShardHandler(this.defaultClient);
    }

    public ShardHandler getShardHandler(HttpClient httpClient) {
        return new HttpShardHandler(this, httpClient);
    }

    @Override
    public void init(PluginInfo info) {
        StringBuilder sb = new StringBuilder();
        NamedList args = info.initArgs;
        this.soTimeout = this.getParameter(args, "socketTimeout", this.soTimeout, sb);
        this.scheme = this.getParameter(args, INIT_URL_SCHEME, null, sb);
        if (StringUtils.endsWith(this.scheme, "://")) {
            this.scheme = StringUtils.removeEnd(this.scheme, "://");
        }
        this.connectionTimeout = this.getParameter(args, "connTimeout", this.connectionTimeout, sb);
        this.maxConnectionsPerHost = this.getParameter(args, "maxConnectionsPerHost", this.maxConnectionsPerHost, sb);
        this.maxConnections = this.getParameter(args, "maxConnections", this.maxConnections, sb);
        this.corePoolSize = this.getParameter(args, INIT_CORE_POOL_SIZE, this.corePoolSize, sb);
        this.maximumPoolSize = this.getParameter(args, INIT_MAX_POOL_SIZE, this.maximumPoolSize, sb);
        this.keepAliveTime = this.getParameter(args, MAX_THREAD_IDLE_TIME, this.keepAliveTime, sb);
        this.queueSize = this.getParameter(args, INIT_SIZE_OF_QUEUE, this.queueSize, sb);
        this.accessPolicy = this.getParameter(args, INIT_FAIRNESS_POLICY, this.accessPolicy, sb);
        this.useRetries = this.getParameter(args, USE_RETRIES, this.useRetries, sb);
        this.connectionsEvictorSleepDelay = this.getParameter(args, CONNECTIONS_EVICTOR_SLEEP_DELAY, this.connectionsEvictorSleepDelay, sb);
        this.maxConnectionIdleTime = this.getParameter(args, MAX_CONNECTION_IDLE_TIME, this.maxConnectionIdleTime, sb);
        log.info("created with {}", (Object)sb);
        String v = System.getProperty("tests.shardhandler.randomSeed");
        if (v != null) {
            this.r.setSeed(Long.parseLong(v));
        }
        BlockingQueue blockingQueue = (BlockingQueue)((Object)(this.queueSize == -1 ? new SynchronousQueue(this.accessPolicy) : new ArrayBlockingQueue(this.queueSize, this.accessPolicy)));
        this.commExecutor = new ExecutorUtil.MDCAwareThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, (long)this.keepAliveTime, TimeUnit.SECONDS, (BlockingQueue<Runnable>)blockingQueue, new DefaultSolrThreadFactory("httpShardExecutor"));
        ModifiableSolrParams clientParams = this.getClientParams();
        this.clientConnectionManager = new PoolingClientConnectionManager(SchemeRegistryFactory.createSystemDefault());
        this.clientConnectionManager.setDefaultMaxPerRoute(this.maxConnectionsPerHost);
        this.clientConnectionManager.setMaxTotal(this.maxConnections);
        this.defaultClient = HttpClientUtil.createClient(clientParams, this.clientConnectionManager);
        this.idleConnectionsEvictor = new UpdateShardHandler.IdleConnectionsEvictor(this.clientConnectionManager, this.connectionsEvictorSleepDelay, TimeUnit.MILLISECONDS, this.maxConnectionIdleTime, TimeUnit.MILLISECONDS);
        this.idleConnectionsEvictor.start();
        if (this.useRetries) {
            ((DefaultHttpClient)this.defaultClient).setHttpRequestRetryHandler(new DefaultHttpRequestRetryHandler());
        }
        this.loadbalancer = this.createLoadbalancer(this.defaultClient);
    }

    protected ModifiableSolrParams getClientParams() {
        ModifiableSolrParams clientParams = new ModifiableSolrParams();
        clientParams.set("socketTimeout", this.soTimeout);
        clientParams.set("connTimeout", this.connectionTimeout);
        if (!this.useRetries) {
            clientParams.set("retry", false);
        }
        return clientParams;
    }

    public void reconfigureHttpClient(HttpClientConfigurer configurer) {
        log.info("Reconfiguring the default client with: " + configurer);
        configurer.configure((DefaultHttpClient)this.defaultClient, this.getClientParams());
    }

    protected ThreadPoolExecutor getThreadPoolExecutor() {
        return this.commExecutor;
    }

    protected LBHttpSolrClient createLoadbalancer(HttpClient httpClient) {
        return new LBHttpSolrClient(httpClient, new String[0]);
    }

    protected <T> T getParameter(NamedList initArgs, String configKey, T defaultValue, StringBuilder sb) {
        T toReturn = defaultValue;
        if (initArgs != null) {
            Object temp = initArgs.get(configKey);
            Object t = toReturn = temp != null ? temp : defaultValue;
        }
        if (sb != null && toReturn != null) {
            sb.append(configKey).append(" : ").append(toReturn).append(",");
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            ExecutorUtil.shutdownAndAwaitTermination(this.commExecutor);
        }
        finally {
            try {
                if (this.idleConnectionsEvictor != null) {
                    this.idleConnectionsEvictor.shutdown();
                }
                IOUtils.closeQuietly(this.defaultClient);
                if (this.clientConnectionManager != null) {
                    this.clientConnectionManager.shutdown();
                }
            }
            finally {
                if (this.loadbalancer != null) {
                    this.loadbalancer.close();
                }
            }
        }
    }

    public LBHttpSolrClient.Rsp makeLoadBalancedRequest(QueryRequest req, List<String> urls) throws SolrServerException, IOException {
        return this.loadbalancer.request(new LBHttpSolrClient.Req(req, urls));
    }

    public List<String> makeURLList(String shard) {
        List<String> urls = StrUtils.splitSmart(shard, "|", true);
        for (int i = 0; i < urls.size(); ++i) {
            urls.set(i, this.buildUrl(urls.get(i)));
        }
        if (urls.size() > 1) {
            Collections.shuffle(urls, this.r);
        }
        return urls;
    }

    public CompletionService newCompletionService() {
        return new ExecutorCompletionService(this.commExecutor);
    }

    private String buildUrl(String url) {
        if (!URLUtil.hasScheme(url)) {
            return StringUtils.defaultIfEmpty(this.scheme, DEFAULT_SCHEME) + "://" + url;
        }
        if (StringUtils.isNotEmpty(this.scheme)) {
            return this.scheme + "://" + URLUtil.removeScheme(url);
        }
        return url;
    }
}

