/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.Date;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.AbstractStatsValues;
import org.apache.solr.handler.component.StatsField;

class DateStatsValues
extends AbstractStatsValues<Date> {
    private long sum = 0L;
    double sumOfSquares = 0.0;
    protected final boolean computeSum;
    protected final boolean computeSumOfSquares;

    public DateStatsValues(StatsField statsField) {
        super(statsField);
        this.computeSum = statsField.calculateStats(StatsField.Stat.sum);
        this.computeSumOfSquares = statsField.calculateStats(StatsField.Stat.sumOfSquares);
    }

    @Override
    public long hash(Date v) {
        return this.hasher.hashLong(v.getTime()).asLong();
    }

    @Override
    public void accumulate(int docID) {
        if (this.values.exists(docID)) {
            this.accumulate((Date)this.values.objectVal(docID), 1);
        } else {
            this.missing();
        }
    }

    @Override
    protected void updateTypeSpecificStats(NamedList stv) {
        if (this.computeSum) {
            this.sum += ((Date)stv.get("sum")).getTime();
        }
        if (this.computeSumOfSquares) {
            this.sumOfSquares += ((Number)stv.get("sumOfSquares")).doubleValue();
        }
    }

    @Override
    public void updateTypeSpecificStats(Date v, int count) {
        long value = v.getTime();
        if (this.computeSumOfSquares) {
            this.sumOfSquares += (double)value * (double)value * (double)count;
        }
        if (this.computeSum) {
            this.sum += value * (long)count;
        }
    }

    @Override
    protected void updateMinMax(Date min, Date max) {
        if (this.computeMin && null != min && (this.min == null || ((Date)this.min).after(min))) {
            this.min = min;
        }
        if (this.computeMax && null != max && (this.max == null || ((Date)this.max).before(max))) {
            this.max = max;
        }
    }

    @Override
    protected void addTypeSpecificStats(NamedList<Object> res) {
        if (this.statsField.includeInResponse(StatsField.Stat.sum)) {
            res.add("sum", new Date(this.sum));
        }
        if (this.statsField.includeInResponse(StatsField.Stat.mean)) {
            res.add("mean", this.count > 0L ? new Date(this.sum / this.count) : null);
        }
        if (this.statsField.includeInResponse(StatsField.Stat.sumOfSquares)) {
            res.add("sumOfSquares", this.sumOfSquares);
        }
        if (this.statsField.includeInResponse(StatsField.Stat.stddev)) {
            res.add("stddev", this.getStandardDeviation());
        }
    }

    private double getStandardDeviation() {
        if (this.count <= 1L) {
            return 0.0;
        }
        return Math.sqrt(((double)this.count * this.sumOfSquares - (double)this.sum * (double)this.sum) / ((double)this.count * ((double)this.count - 1.0)));
    }
}

