/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.net.URLDecoder;
import java.util.Map;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.stream.CloudSolrStream;
import org.apache.solr.client.solrj.io.stream.ExpressibleStream;
import org.apache.solr.client.solrj.io.stream.MergeStream;
import org.apache.solr.client.solrj.io.stream.ParallelStream;
import org.apache.solr.client.solrj.io.stream.RankStream;
import org.apache.solr.client.solrj.io.stream.ReducerStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.UniqueStream;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Base64;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.plugin.SolrCoreAware;

public class StreamHandler
extends RequestHandlerBase
implements SolrCoreAware {
    private SolrClientCache clientCache = new SolrClientCache();
    private StreamFactory streamFactory = new StreamFactory();

    @Override
    public void inform(SolrCore core) {
        String defaultCollection = null;
        String defaultZkhost = null;
        CoreContainer coreContainer = core.getCoreDescriptor().getCoreContainer();
        if (coreContainer.isZooKeeperAware()) {
            defaultCollection = core.getCoreDescriptor().getCollectionName();
            defaultZkhost = core.getCoreDescriptor().getCoreContainer().getZkController().getZkServerAddress();
            this.streamFactory.withCollectionZkHost(defaultCollection, defaultZkhost);
        }
        this.streamFactory.withStreamFunction("search", CloudSolrStream.class).withStreamFunction("merge", MergeStream.class).withStreamFunction("unique", UniqueStream.class).withStreamFunction("top", RankStream.class).withStreamFunction("group", ReducerStream.class).withStreamFunction("parallel", ParallelStream.class);
        Object functionMappingsObj = this.initArgs.get("streamFunctions");
        if (null != functionMappingsObj) {
            NamedList functionMappings = (NamedList)functionMappingsObj;
            for (Map.Entry functionMapping : functionMappings) {
                Class<ExpressibleStream> clazz = core.getResourceLoader().findClass((String)functionMapping.getValue(), ExpressibleStream.class);
                this.streamFactory.withStreamFunction(functionMapping.getKey(), clazz);
            }
        }
        core.addCloseHook(new CloseHook(){

            @Override
            public void preClose(SolrCore core) {
            }

            @Override
            public void postClose(SolrCore core) {
                StreamHandler.this.clientCache.close();
            }
        });
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        boolean objectSerialize = params.getBool("objectSerialize", false);
        TupleStream tupleStream = null;
        if (objectSerialize) {
            String encodedStream = params.get("stream");
            encodedStream = URLDecoder.decode(encodedStream, "UTF-8");
            byte[] bytes = Base64.base64ToByteArray(encodedStream);
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteStream);
            tupleStream = (TupleStream)objectInputStream.readObject();
        } else {
            tupleStream = this.streamFactory.constructStream(params.get("stream"));
        }
        int worker = params.getInt("workerID", 0);
        int numWorkers = params.getInt("numWorkers", 1);
        StreamContext context = new StreamContext();
        context.workerID = worker;
        context.numWorkers = numWorkers;
        context.setSolrClientCache(this.clientCache);
        tupleStream.setStreamContext(context);
        rsp.add("tuples", tupleStream);
    }

    @Override
    public String getDescription() {
        return "StreamHandler";
    }

    @Override
    public String getSource() {
        return null;
    }
}

