/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.IndexFetcher;
import org.apache.solr.handler.OldBackupDirectory;
import org.apache.solr.handler.ReplicationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapShooter {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String snapDir = null;
    private SolrCore solrCore;
    private String snapshotName = null;
    private String directoryName = null;
    private File snapShotDir = null;
    public static final String DATE_FMT = "yyyyMMddHHmmssSSS";

    public SnapShooter(SolrCore core, String location, String snapshotName) {
        this.solrCore = core;
        this.snapDir = location == null ? core.getDataDir() : core.getCoreDescriptor().getInstanceDir().resolve(location).normalize().toString();
        this.snapshotName = snapshotName;
        if (snapshotName != null) {
            this.directoryName = "snapshot." + snapshotName;
        } else {
            SimpleDateFormat fmt = new SimpleDateFormat(DATE_FMT, Locale.ROOT);
            this.directoryName = "snapshot." + fmt.format(new Date());
        }
    }

    void createSnapAsync(final IndexCommit indexCommit, final int numberToKeep, final ReplicationHandler replicationHandler) {
        replicationHandler.core.getDeletionPolicy().saveCommitPoint(indexCommit.getGeneration());
        new Thread(){

            @Override
            public void run() {
                if (SnapShooter.this.snapshotName != null) {
                    SnapShooter.this.createSnapshot(indexCommit, replicationHandler);
                } else {
                    SnapShooter.this.createSnapshot(indexCommit, replicationHandler);
                    SnapShooter.this.deleteOldBackups(numberToKeep);
                }
            }
        }.start();
    }

    public void validateDeleteSnapshot() {
        File[] files;
        boolean dirFound = false;
        for (File f : files = new File(this.snapDir).listFiles()) {
            if (!f.getName().equals("snapshot." + this.snapshotName)) continue;
            dirFound = true;
            break;
        }
        if (!dirFound) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Snapshot cannot be found in directory: " + this.snapDir);
        }
    }

    protected void deleteSnapAsync(final ReplicationHandler replicationHandler) {
        new Thread(){

            @Override
            public void run() {
                SnapShooter.this.deleteNamedSnapshot(replicationHandler);
            }
        }.start();
    }

    void validateCreateSnapshot() throws IOException {
        this.snapShotDir = new File(this.snapDir, this.directoryName);
        if (this.snapShotDir.exists()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Snapshot directory already exists: " + this.snapShotDir.getAbsolutePath());
        }
        if (!this.snapShotDir.mkdirs()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to create snapshot directory: " + this.snapShotDir.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createSnapshot(IndexCommit indexCommit, ReplicationHandler replicationHandler) {
        LOG.info("Creating backup snapshot " + (this.snapshotName == null ? "<not named>" : this.snapshotName) + " at " + this.snapDir);
        NamedList<Object> details = new NamedList<Object>();
        details.add("startTime", new Date().toString());
        try {
            Collection<String> files = indexCommit.getFileNames();
            Directory dir = this.solrCore.getDirectoryFactory().get(this.solrCore.getIndexDir(), DirectoryFactory.DirContext.DEFAULT, this.solrCore.getSolrConfig().indexConfig.lockType);
            try {
                SnapShooter.copyFiles(dir, files, this.snapShotDir);
            }
            finally {
                this.solrCore.getDirectoryFactory().release(dir);
            }
            details.add("fileCount", files.size());
            details.add("status", "success");
            details.add("snapshotCompletedAt", new Date().toString());
            details.add("snapshotName", this.snapshotName);
            LOG.info("Done creating backup snapshot: " + (this.snapshotName == null ? "<not named>" : this.snapshotName) + " at " + this.snapDir);
        }
        catch (Exception e) {
            IndexFetcher.delTree(this.snapShotDir);
            LOG.error("Exception while creating snapshot", (Throwable)e);
            details.add("snapShootException", e.getMessage());
        }
        finally {
            replicationHandler.core.getDeletionPolicy().releaseCommitPoint(indexCommit.getGeneration());
            replicationHandler.snapShootDetails = details;
        }
    }

    private void deleteOldBackups(int numberToKeep) {
        File[] files = new File(this.snapDir).listFiles();
        ArrayList<OldBackupDirectory> dirs = new ArrayList<OldBackupDirectory>();
        for (File f : files) {
            OldBackupDirectory obd = new OldBackupDirectory(f);
            if (obd.dir == null) continue;
            dirs.add(obd);
        }
        if (numberToKeep > dirs.size() - 1) {
            return;
        }
        Collections.sort(dirs);
        int i = 1;
        for (OldBackupDirectory dir : dirs) {
            if (i++ <= numberToKeep) continue;
            IndexFetcher.delTree(dir.dir);
        }
    }

    protected void deleteNamedSnapshot(ReplicationHandler replicationHandler) {
        LOG.info("Deleting snapshot: " + this.snapshotName);
        NamedList<String> details = new NamedList<String>();
        File f = new File(this.snapDir, "snapshot." + this.snapshotName);
        boolean isSuccess = IndexFetcher.delTree(f);
        if (isSuccess) {
            details.add("status", "success");
            details.add("snapshotDeletedAt", new Date().toString());
        } else {
            details.add("status", "Unable to delete snapshot: " + this.snapshotName);
            LOG.warn("Unable to delete snapshot: " + this.snapshotName);
        }
        replicationHandler.snapShootDetails = details;
    }

    private static void copyFiles(Directory sourceDir, Collection<String> files, File destDir) throws IOException {
        try (SimpleFSDirectory dir = new SimpleFSDirectory(destDir.toPath(), NoLockFactory.INSTANCE);){
            for (String indexFile : files) {
                dir.copyFrom(sourceDir, indexFile, indexFile, DirectoryFactory.IOCONTEXT_NO_CACHE);
            }
        }
    }
}

