/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.StandardDirectoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MMapDirectoryFactory
extends StandardDirectoryFactory {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    boolean unmapHack;
    private int maxChunk;

    @Override
    public void init(NamedList args) {
        super.init(args);
        SolrParams params = SolrParams.toSolrParams(args);
        this.maxChunk = params.getInt("maxChunkSize", MMapDirectory.DEFAULT_MAX_CHUNK_SIZE);
        if (this.maxChunk <= 0) {
            throw new IllegalArgumentException("maxChunk must be greater than 0");
        }
        this.unmapHack = params.getBool("unmap", true);
    }

    @Override
    protected Directory create(String path, LockFactory lockFactory, DirectoryFactory.DirContext dirContext) throws IOException {
        MMapDirectory mapDirectory = new MMapDirectory(new File(path).toPath(), lockFactory, this.maxChunk);
        try {
            mapDirectory.setUseUnmap(this.unmapHack);
        }
        catch (IllegalArgumentException e) {
            log.warn("Unmap not supported on this JVM, continuing on without setting unmap", (Throwable)e);
        }
        return mapDirectory;
    }

    @Override
    public boolean isAbsolute(String path) {
        return new File(path).isAbsolute();
    }
}

