/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IndexDeletionPolicyWrapper
extends IndexDeletionPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final IndexDeletionPolicy deletionPolicy;
    private volatile Map<Long, IndexCommit> solrVersionVsCommits = new ConcurrentHashMap<Long, IndexCommit>();
    private final Map<Long, Long> reserves = new ConcurrentHashMap<Long, Long>();
    private volatile IndexCommit latestCommit;
    private final ConcurrentHashMap<Long, AtomicInteger> savedCommits = new ConcurrentHashMap();

    public IndexDeletionPolicyWrapper(IndexDeletionPolicy deletionPolicy) {
        this.deletionPolicy = deletionPolicy;
    }

    public IndexCommit getLatestCommit() {
        return this.latestCommit;
    }

    public IndexDeletionPolicy getWrappedDeletionPolicy() {
        return this.deletionPolicy;
    }

    public void setReserveDuration(Long indexGen, long reserveTime) {
        long timeToSet = System.nanoTime() + TimeUnit.NANOSECONDS.convert(reserveTime, TimeUnit.MILLISECONDS);
        while (true) {
            Long previousTime;
            if ((previousTime = this.reserves.put(indexGen, timeToSet)) == null || previousTime <= timeToSet) break;
            timeToSet = previousTime;
        }
        LOG.debug("Commit point reservation for generation {} set to {} (requested reserve time of {})", new Object[]{indexGen, timeToSet, reserveTime});
    }

    private void cleanReserves() {
        long currentTime = System.nanoTime();
        for (Map.Entry<Long, Long> entry : this.reserves.entrySet()) {
            if (entry.getValue() >= currentTime) continue;
            this.reserves.remove(entry.getKey());
        }
    }

    private List<IndexCommitWrapper> wrap(List<? extends IndexCommit> list) {
        ArrayList<IndexCommitWrapper> result = new ArrayList<IndexCommitWrapper>();
        for (IndexCommit indexCommit : list) {
            result.add(new IndexCommitWrapper(indexCommit));
        }
        return result;
    }

    public synchronized void saveCommitPoint(Long indexCommitGen) {
        AtomicInteger reserveCount = this.savedCommits.get(indexCommitGen);
        if (reserveCount == null) {
            reserveCount = new AtomicInteger();
        }
        reserveCount.incrementAndGet();
        this.savedCommits.put(indexCommitGen, reserveCount);
    }

    public synchronized void releaseCommitPoint(Long indexCommitGen) {
        AtomicInteger reserveCount = this.savedCommits.get(indexCommitGen);
        if (reserveCount == null) {
            return;
        }
        if (reserveCount.decrementAndGet() <= 0) {
            this.savedCommits.remove(indexCommitGen);
        }
    }

    @Override
    public void onInit(List<? extends IndexCommit> list) throws IOException {
        List<IndexCommitWrapper> wrapperList = this.wrap(list);
        this.deletionPolicy.onInit(wrapperList);
        this.updateCommitPoints(wrapperList);
        this.cleanReserves();
    }

    @Override
    public void onCommit(List<? extends IndexCommit> list) throws IOException {
        List<IndexCommitWrapper> wrapperList = this.wrap(list);
        this.deletionPolicy.onCommit(wrapperList);
        this.updateCommitPoints(wrapperList);
        this.cleanReserves();
    }

    public IndexCommit getCommitPoint(Long gen) {
        return this.solrVersionVsCommits.get(gen);
    }

    public Map<Long, IndexCommit> getCommits() {
        return this.solrVersionVsCommits;
    }

    private void updateCommitPoints(List<IndexCommitWrapper> list) {
        ConcurrentHashMap<Long, IndexCommit> map = new ConcurrentHashMap<Long, IndexCommit>();
        for (IndexCommitWrapper wrapper : list) {
            if (wrapper.isDeleted()) continue;
            map.put(wrapper.delegate.getGeneration(), wrapper.delegate);
        }
        this.solrVersionVsCommits = map;
        if (!list.isEmpty()) {
            this.latestCommit = list.get((int)(list.size() - 1)).delegate;
        }
    }

    public static long getCommitTimestamp(IndexCommit commit) throws IOException {
        Map<String, String> commitData = commit.getUserData();
        String commitTime = commitData.get("commitTimeMSec");
        if (commitTime != null) {
            return Long.parseLong(commitTime);
        }
        return 0L;
    }

    public IndexDeletionPolicy clone() {
        return this;
    }

    private class IndexCommitWrapper
    extends IndexCommit {
        IndexCommit delegate;

        IndexCommitWrapper(IndexCommit delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getSegmentsFileName() {
            return this.delegate.getSegmentsFileName();
        }

        public Collection getFileNames() throws IOException {
            return this.delegate.getFileNames();
        }

        @Override
        public Directory getDirectory() {
            return this.delegate.getDirectory();
        }

        @Override
        public void delete() {
            Long gen = this.delegate.getGeneration();
            Long reserve = (Long)IndexDeletionPolicyWrapper.this.reserves.get(gen);
            if (reserve != null && System.nanoTime() < reserve) {
                return;
            }
            if (IndexDeletionPolicyWrapper.this.savedCommits.containsKey(gen)) {
                return;
            }
            this.delegate.delete();
        }

        @Override
        public int getSegmentCount() {
            return this.delegate.getSegmentCount();
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public long getGeneration() {
            return this.delegate.getGeneration();
        }

        @Override
        public boolean isDeleted() {
            return this.delegate.isDeleted();
        }

        public Map getUserData() throws IOException {
            return this.delegate.getUserData();
        }
    }
}

