/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.cloud.BeforeReconnect;
import org.apache.solr.common.cloud.ConnectionManager;
import org.apache.solr.common.cloud.DefaultConnectionStrategy;
import org.apache.solr.common.cloud.DefaultZkACLProvider;
import org.apache.solr.common.cloud.DefaultZkCredentialsProvider;
import org.apache.solr.common.cloud.OnReconnect;
import org.apache.solr.common.cloud.SolrZooKeeper;
import org.apache.solr.common.cloud.ZkACLProvider;
import org.apache.solr.common.cloud.ZkClientConnectionStrategy;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZkCredentialsProvider;
import org.apache.solr.common.cloud.ZkOperation;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrZkClient
implements Closeable {
    static final String NEWL = System.getProperty("line.separator");
    static final int DEFAULT_CLIENT_CONNECT_TIMEOUT = 30000;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ConnectionManager connManager;
    private volatile SolrZooKeeper keeper;
    private ZkCmdExecutor zkCmdExecutor;
    private final ExecutorService zkCallbackExecutor = ExecutorUtil.newMDCAwareCachedThreadPool(new SolrjNamedThreadFactory("zkCallback"));
    private volatile boolean isClosed = false;
    private ZkClientConnectionStrategy zkClientConnectionStrategy;
    private int zkClientTimeout;
    private ZkACLProvider zkACLProvider;
    private String zkServerAddress;
    public static final String ZK_CRED_PROVIDER_CLASS_NAME_VM_PARAM_NAME = "zkCredentialsProvider";
    public static final String ZK_ACL_PROVIDER_CLASS_NAME_VM_PARAM_NAME = "zkACLProvider";

    public int getZkClientTimeout() {
        return this.zkClientTimeout;
    }

    public SolrZkClient() {
    }

    public SolrZkClient(String zkServerAddress, int zkClientTimeout) {
        this(zkServerAddress, zkClientTimeout, new DefaultConnectionStrategy(), null);
    }

    public SolrZkClient(String zkServerAddress, int zkClientTimeout, int zkClientConnectTimeout) {
        this(zkServerAddress, zkClientTimeout, zkClientConnectTimeout, new DefaultConnectionStrategy(), null);
    }

    public SolrZkClient(String zkServerAddress, int zkClientTimeout, int zkClientConnectTimeout, OnReconnect onReonnect) {
        this(zkServerAddress, zkClientTimeout, zkClientConnectTimeout, new DefaultConnectionStrategy(), onReonnect);
    }

    public SolrZkClient(String zkServerAddress, int zkClientTimeout, ZkClientConnectionStrategy strat, OnReconnect onReconnect) {
        this(zkServerAddress, zkClientTimeout, 30000, strat, onReconnect);
    }

    public SolrZkClient(String zkServerAddress, int zkClientTimeout, int clientConnectTimeout, ZkClientConnectionStrategy strat, OnReconnect onReconnect) {
        this(zkServerAddress, zkClientTimeout, clientConnectTimeout, strat, onReconnect, null, null);
    }

    public SolrZkClient(String zkServerAddress, int zkClientTimeout, int clientConnectTimeout, ZkClientConnectionStrategy strat, OnReconnect onReconnect, BeforeReconnect beforeReconnect) {
        this(zkServerAddress, zkClientTimeout, clientConnectTimeout, strat, onReconnect, beforeReconnect, null);
    }

    public SolrZkClient(String zkServerAddress, int zkClientTimeout, int clientConnectTimeout, ZkClientConnectionStrategy strat, OnReconnect onReconnect, BeforeReconnect beforeReconnect, ZkACLProvider zkACLProvider) {
        this.zkClientConnectionStrategy = strat;
        this.zkServerAddress = zkServerAddress;
        if (strat == null) {
            strat = new DefaultConnectionStrategy();
        }
        if (!strat.hasZkCredentialsToAddAutomatically()) {
            ZkCredentialsProvider zkCredentialsToAddAutomatically = this.createZkCredentialsToAddAutomatically();
            strat.setZkCredentialsToAddAutomatically(zkCredentialsToAddAutomatically);
        }
        this.zkClientTimeout = zkClientTimeout;
        this.zkCmdExecutor = new ZkCmdExecutor(zkClientTimeout);
        this.connManager = new ConnectionManager("ZooKeeperConnection Watcher:" + zkServerAddress, this, zkServerAddress, strat, onReconnect, beforeReconnect);
        try {
            strat.connect(zkServerAddress, zkClientTimeout, this.wrapWatcher(this.connManager), new ZkClientConnectionStrategy.ZkUpdate(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void update(SolrZooKeeper zooKeeper) {
                    SolrZooKeeper oldKeeper = SolrZkClient.this.keeper;
                    SolrZkClient.this.keeper = zooKeeper;
                    try {
                        SolrZkClient.this.closeKeeper(oldKeeper);
                    }
                    finally {
                        if (SolrZkClient.this.isClosed) {
                            SolrZkClient.this.closeKeeper(SolrZkClient.this.keeper);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            this.connManager.close();
            if (this.keeper != null) {
                try {
                    this.keeper.close();
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        try {
            this.connManager.waitForConnected(clientConnectTimeout);
        }
        catch (Exception e) {
            this.connManager.close();
            try {
                this.keeper.close();
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        assert (ObjectReleaseTracker.track(this));
        this.zkACLProvider = zkACLProvider == null ? this.createZkACLProvider() : zkACLProvider;
    }

    public ConnectionManager getConnectionManager() {
        return this.connManager;
    }

    public ZkClientConnectionStrategy getZkClientConnectionStrategy() {
        return this.zkClientConnectionStrategy;
    }

    protected ZkCredentialsProvider createZkCredentialsToAddAutomatically() {
        String zkCredentialsProviderClassName = System.getProperty(ZK_CRED_PROVIDER_CLASS_NAME_VM_PARAM_NAME);
        if (!StringUtils.isEmpty(zkCredentialsProviderClassName)) {
            try {
                log.info("Using ZkCredentialsProvider: " + zkCredentialsProviderClassName);
                return (ZkCredentialsProvider)Class.forName(zkCredentialsProviderClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                log.warn("VM param zkCredentialsProvider does not point to a class implementing ZkCredentialsProvider and with a non-arg constructor", t);
            }
        }
        log.info("Using default ZkCredentialsProvider");
        return new DefaultZkCredentialsProvider();
    }

    protected ZkACLProvider createZkACLProvider() {
        String zkACLProviderClassName = System.getProperty(ZK_ACL_PROVIDER_CLASS_NAME_VM_PARAM_NAME);
        if (!StringUtils.isEmpty(zkACLProviderClassName)) {
            try {
                log.info("Using ZkACLProvider: " + zkACLProviderClassName);
                return (ZkACLProvider)Class.forName(zkACLProviderClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                log.warn("VM param zkACLProvider does not point to a class implementing ZkACLProvider and with a non-arg constructor", t);
            }
        }
        log.info("Using default ZkACLProvider");
        return new DefaultZkACLProvider();
    }

    public boolean isConnected() {
        return this.keeper != null && this.keeper.getState() == ZooKeeper.States.CONNECTED;
    }

    public void delete(final String path, final int version, boolean retryOnConnLoss) throws InterruptedException, KeeperException {
        if (retryOnConnLoss) {
            this.zkCmdExecutor.retryOperation(new ZkOperation(){

                @Override
                public Stat execute() throws KeeperException, InterruptedException {
                    SolrZkClient.this.keeper.delete(path, version);
                    return null;
                }
            });
        } else {
            this.keeper.delete(path, version);
        }
    }

    private Watcher wrapWatcher(final Watcher watcher) {
        if (watcher == null) {
            return watcher;
        }
        return new Watcher(){

            @Override
            public void process(final WatchedEvent event) {
                log.debug("Submitting job to respond to event " + event);
                SolrZkClient.this.zkCallbackExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        watcher.process(event);
                    }
                });
            }
        };
    }

    public Stat exists(final String path, final Watcher watcher, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return (Stat)this.zkCmdExecutor.retryOperation(new ZkOperation(){

                @Override
                public Stat execute() throws KeeperException, InterruptedException {
                    return SolrZkClient.this.keeper.exists(path, SolrZkClient.this.wrapWatcher(watcher));
                }
            });
        }
        return this.keeper.exists(path, this.wrapWatcher(watcher));
    }

    public Boolean exists(final String path, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return (Boolean)this.zkCmdExecutor.retryOperation(new ZkOperation(){

                @Override
                public Boolean execute() throws KeeperException, InterruptedException {
                    return SolrZkClient.this.keeper.exists(path, null) != null;
                }
            });
        }
        return this.keeper.exists(path, null) != null;
    }

    public List<String> getChildren(final String path, final Watcher watcher, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return (List)this.zkCmdExecutor.retryOperation(new ZkOperation(){

                @Override
                public List<String> execute() throws KeeperException, InterruptedException {
                    return SolrZkClient.this.keeper.getChildren(path, SolrZkClient.this.wrapWatcher(watcher));
                }
            });
        }
        return this.keeper.getChildren(path, this.wrapWatcher(watcher));
    }

    public byte[] getData(final String path, final Watcher watcher, final Stat stat, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return (byte[])this.zkCmdExecutor.retryOperation(new ZkOperation(){

                public byte[] execute() throws KeeperException, InterruptedException {
                    return SolrZkClient.this.keeper.getData(path, SolrZkClient.this.wrapWatcher(watcher), stat);
                }
            });
        }
        return this.keeper.getData(path, this.wrapWatcher(watcher), stat);
    }

    public Stat setData(final String path, final byte[] data, final int version, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return (Stat)this.zkCmdExecutor.retryOperation(new ZkOperation(){

                @Override
                public Stat execute() throws KeeperException, InterruptedException {
                    return SolrZkClient.this.keeper.setData(path, data, version);
                }
            });
        }
        return this.keeper.setData(path, data, version);
    }

    public String create(final String path, final byte[] data, final CreateMode createMode, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (retryOnConnLoss) {
            return (String)this.zkCmdExecutor.retryOperation(new ZkOperation(){

                @Override
                public String execute() throws KeeperException, InterruptedException {
                    return SolrZkClient.this.keeper.create(path, data, SolrZkClient.this.zkACLProvider.getACLsToAdd(path), createMode);
                }
            });
        }
        List<ACL> acls = this.zkACLProvider.getACLsToAdd(path);
        return this.keeper.create(path, data, acls, createMode);
    }

    public void makePath(String path, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, null, CreateMode.PERSISTENT, retryOnConnLoss);
    }

    public void makePath(String path, boolean failOnExists, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, null, CreateMode.PERSISTENT, null, failOnExists, retryOnConnLoss);
    }

    public void makePath(String path, File file, boolean failOnExists, boolean retryOnConnLoss) throws IOException, KeeperException, InterruptedException {
        this.makePath(path, FileUtils.readFileToByteArray((File)file), CreateMode.PERSISTENT, null, failOnExists, retryOnConnLoss);
    }

    public void makePath(String path, File file, boolean retryOnConnLoss) throws IOException, KeeperException, InterruptedException {
        this.makePath(path, FileUtils.readFileToByteArray((File)file), retryOnConnLoss);
    }

    public void makePath(String path, CreateMode createMode, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, null, createMode, retryOnConnLoss);
    }

    public void makePath(String path, byte[] data, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, data, CreateMode.PERSISTENT, retryOnConnLoss);
    }

    public void makePath(String path, byte[] data, CreateMode createMode, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, data, createMode, null, retryOnConnLoss);
    }

    public void makePath(String path, byte[] data, CreateMode createMode, Watcher watcher, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(path, data, createMode, watcher, true, retryOnConnLoss);
    }

    public void makePath(String path, byte[] data, CreateMode createMode, Watcher watcher, boolean failOnExists, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        if (log.isInfoEnabled()) {
            log.info("makePath: " + path);
        }
        boolean retry = true;
        if (path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        String[] paths = path.split("/");
        StringBuilder sbPath = new StringBuilder();
        for (int i = 0; i < paths.length; ++i) {
            byte[] bytes = null;
            String pathPiece = paths[i];
            sbPath.append("/" + pathPiece);
            final String currentPath = sbPath.toString();
            Stat exists = this.exists(currentPath, watcher, retryOnConnLoss);
            if (exists == null || i == paths.length - 1 && failOnExists) {
                block11: {
                    CreateMode mode = CreateMode.PERSISTENT;
                    if (i == paths.length - 1) {
                        mode = createMode;
                        bytes = data;
                        if (!retryOnConnLoss) {
                            retry = false;
                        }
                    }
                    try {
                        if (retry) {
                            final CreateMode finalMode = mode;
                            final byte[] finalBytes = bytes;
                            this.zkCmdExecutor.retryOperation(new ZkOperation(){

                                @Override
                                public Object execute() throws KeeperException, InterruptedException {
                                    SolrZkClient.this.keeper.create(currentPath, finalBytes, SolrZkClient.this.zkACLProvider.getACLsToAdd(currentPath), finalMode);
                                    return null;
                                }
                            });
                        } else {
                            this.keeper.create(currentPath, bytes, this.zkACLProvider.getACLsToAdd(currentPath), mode);
                        }
                    }
                    catch (KeeperException.NodeExistsException e) {
                        if (!failOnExists) {
                            this.setData(currentPath, data, -1, retryOnConnLoss);
                            this.exists(currentPath, watcher, retryOnConnLoss);
                            return;
                        }
                        if (i != paths.length - 1) break block11;
                        throw e;
                    }
                }
                if (i != paths.length - 1) continue;
                this.exists(currentPath, watcher, retryOnConnLoss);
                continue;
            }
            if (i != paths.length - 1) continue;
            this.setData(currentPath, data, -1, retryOnConnLoss);
            this.exists(currentPath, watcher, retryOnConnLoss);
        }
    }

    public void makePath(String zkPath, CreateMode createMode, Watcher watcher, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        this.makePath(zkPath, null, createMode, watcher, retryOnConnLoss);
    }

    public Stat setData(String path, byte[] data, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        return this.setData(path, data, -1, retryOnConnLoss);
    }

    public Stat setData(String path, File file, boolean retryOnConnLoss) throws IOException, KeeperException, InterruptedException {
        if (log.isInfoEnabled()) {
            log.info("Write to ZooKeepeer " + file.getAbsolutePath() + " to " + path);
        }
        byte[] data = FileUtils.readFileToByteArray((File)file);
        return this.setData(path, data, retryOnConnLoss);
    }

    public List<OpResult> multi(final Iterable<Op> ops, boolean retryOnConnLoss) throws InterruptedException, KeeperException {
        if (retryOnConnLoss) {
            return (List)this.zkCmdExecutor.retryOperation(new ZkOperation(){

                @Override
                public List<OpResult> execute() throws KeeperException, InterruptedException {
                    return SolrZkClient.this.keeper.multi(ops);
                }
            });
        }
        return this.keeper.multi(ops);
    }

    public void printLayout(String path, int indent, StringBuilder string) throws KeeperException, InterruptedException {
        byte[] data = this.getData(path, null, null, true);
        List<String> children = this.getChildren(path, null, true);
        StringBuilder dent = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            dent.append(" ");
        }
        string.append(dent + path + " (" + children.size() + ")" + NEWL);
        if (data != null) {
            String dataString = new String(data, StandardCharsets.UTF_8);
            if (!path.endsWith(".txt") && !path.endsWith(".xml") || path.endsWith("/clusterstate.json")) {
                if (path.endsWith(".xml")) {
                    dataString = SolrZkClient.prettyPrint(dataString);
                }
                string.append(dent + "DATA:\n" + dent + "    " + dataString.replaceAll("\n", "\n" + dent + "    ") + NEWL);
            } else {
                string.append(dent + "DATA: ...supressed..." + NEWL);
            }
        }
        for (String child : children) {
            if (child.equals("quota")) continue;
            try {
                this.printLayout(path + (path.equals("/") ? "" : "/") + child, indent + 1, string);
            }
            catch (KeeperException.NoNodeException noNodeException) {}
        }
    }

    public void printLayoutToStdOut() throws KeeperException, InterruptedException {
        StringBuilder sb = new StringBuilder();
        this.printLayout("/", 0, sb);
        System.out.println(sb.toString());
    }

    public static String prettyPrint(String input, int indent) {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Problem pretty printing XML", e);
        }
    }

    private static String prettyPrint(String input) {
        return SolrZkClient.prettyPrint(input, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            this.closeKeeper(this.keeper);
        }
        finally {
            this.connManager.close();
            this.closeCallbackExecutor();
        }
        assert (ObjectReleaseTracker.release(this));
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    void updateKeeper(SolrZooKeeper keeper) throws InterruptedException {
        SolrZooKeeper oldKeeper = this.keeper;
        this.keeper = keeper;
        if (oldKeeper != null) {
            oldKeeper.close();
        }
        if (this.isClosed) {
            this.keeper.close();
        }
    }

    public SolrZooKeeper getSolrZooKeeper() {
        return this.keeper;
    }

    private void closeKeeper(SolrZooKeeper keeper) {
        if (keeper != null) {
            try {
                keeper.close();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
        }
    }

    private void closeCallbackExecutor() {
        try {
            ExecutorUtil.shutdownAndAwaitTermination(this.zkCallbackExecutor);
        }
        catch (Exception e) {
            SolrException.log(log, e);
        }
    }

    public void clean(String path) throws InterruptedException, KeeperException {
        this.traverseZkTree(path, new ZkVisitor(){

            @Override
            public void visit(String znode) throws InterruptedException, KeeperException {
                try {
                    if (!znode.equals("/")) {
                        try {
                            SolrZkClient.this.delete(znode, -1, true);
                        }
                        catch (KeeperException.NotEmptyException e) {
                            SolrZkClient.this.clean(znode);
                        }
                    }
                }
                catch (KeeperException.NoNodeException r) {
                    return;
                }
            }
        });
    }

    public static boolean containsChroot(String zkHost) {
        return zkHost.contains("/");
    }

    public static Throwable checkInterrupted(Throwable e) {
        if (e instanceof InterruptedException) {
            Thread.interrupted();
        }
        return e;
    }

    public String getZkServerAddress() {
        return this.zkServerAddress;
    }

    public ZkACLProvider getZkACLProvider() {
        return this.zkACLProvider;
    }

    public Stat setACL(final String path, final List<ACL> acls, boolean retryOnConnLoss) throws InterruptedException, KeeperException {
        if (retryOnConnLoss) {
            return (Stat)this.zkCmdExecutor.retryOperation(new ZkOperation(){

                @Override
                public Stat execute() throws KeeperException, InterruptedException {
                    return SolrZkClient.this.keeper.setACL(path, acls, -1);
                }
            });
        }
        return this.keeper.setACL(path, acls, -1);
    }

    public void updateACLs(String root) throws KeeperException, InterruptedException {
        this.traverseZkTree(root, new ZkVisitor(){

            @Override
            public void visit(String path) throws InterruptedException, KeeperException {
                try {
                    SolrZkClient.this.setACL(path, SolrZkClient.this.getZkACLProvider().getACLsToAdd(path), true);
                    log.info("Updated ACL on " + path);
                }
                catch (KeeperException.NoNodeException e) {
                    return;
                }
            }
        });
    }

    private void traverseZkTree(String path, ZkVisitor visitor) throws InterruptedException, KeeperException {
        List<String> children;
        try {
            children = this.getChildren(path, null, true);
        }
        catch (KeeperException.NoNodeException r) {
            return;
        }
        for (String string : children) {
            if (path.equals("/") && string.equals("zookeeper")) continue;
            if (path.equals("/")) {
                this.traverseZkTree(path + string, visitor);
                continue;
            }
            this.traverseZkTree(path + "/" + string, visitor);
        }
        visitor.visit(path);
    }

    private static interface ZkVisitor {
        public void visit(String var1) throws InterruptedException, KeeperException;
    }
}

