/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.cloud.Assign;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerMessageHandler;
import org.apache.solr.cloud.OverseerNodePrioritizer;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.OverseerTaskProcessor;
import org.apache.solr.cloud.overseer.ClusterStateMutator;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.cloud.rule.ReplicaAssigner;
import org.apache.solr.cloud.rule.Rule;
import org.apache.solr.common.NonExistentCoreException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CompositeIdRouter;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.PlainIdRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.RoutingRule;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.update.SolrIndexSplitter;
import org.apache.solr.util.RTimer;
import org.apache.solr.util.TimeOut;
import org.apache.solr.util.stats.Snapshot;
import org.apache.solr.util.stats.Timer;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerCollectionMessageHandler
implements OverseerMessageHandler {
    public static final String NUM_SLICES = "numShards";
    static final boolean CREATE_NODE_SET_SHUFFLE_DEFAULT = true;
    public static final String CREATE_NODE_SET_SHUFFLE = "createNodeSet.shuffle";
    public static final String CREATE_NODE_SET_EMPTY = "EMPTY";
    public static final String CREATE_NODE_SET = "createNodeSet";
    public static final String ROUTER = "router";
    public static final String SHARDS_PROP = "shards";
    public static final String REQUESTID = "requestid";
    public static final String COLL_CONF = "collection.configName";
    public static final String COLL_PROP_PREFIX = "property.";
    public static final String ONLY_IF_DOWN = "onlyIfDown";
    public static final String SHARD_UNIQUE = "shardUnique";
    public static final String ONLY_ACTIVE_NODES = "onlyactivenodes";
    private static final String SKIP_CREATE_REPLICA_IN_CLUSTER_STATE = "skipCreateReplicaInClusterState";
    public static final Map<String, Object> COLL_PROPS = Collections.unmodifiableMap(Utils.makeMap("router", "compositeId", "replicationFactor", "1", "maxShardsPerNode", "1", "autoAddReplicas", "false", "rule", null, "snitch", null));
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Overseer overseer;
    private ShardHandlerFactory shardHandlerFactory;
    private String adminPath;
    private ZkStateReader zkStateReader;
    private String myId;
    private Overseer.Stats stats;
    private OverseerNodePrioritizer overseerPrioritizer;
    private final Set collectionWip;
    static final Random RANDOM;

    public OverseerCollectionMessageHandler(ZkStateReader zkStateReader, String myId, ShardHandlerFactory shardHandlerFactory, String adminPath, Overseer.Stats stats, Overseer overseer, OverseerNodePrioritizer overseerPrioritizer) {
        this.zkStateReader = zkStateReader;
        this.shardHandlerFactory = shardHandlerFactory;
        this.adminPath = adminPath;
        this.myId = myId;
        this.stats = stats;
        this.overseer = overseer;
        this.overseerPrioritizer = overseerPrioritizer;
        this.collectionWip = new HashSet();
    }

    @Override
    public SolrResponse processMessage(ZkNodeProps message, String operation) {
        log.info("OverseerCollectionMessageHandler.processMessage : " + operation + " , " + message.toString());
        NamedList<Serializable> results = new NamedList<Serializable>();
        try {
            this.zkStateReader.updateClusterState();
            CollectionParams.CollectionAction action = CollectionParams.CollectionAction.get(operation);
            if (action == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown operation:" + operation);
            }
            switch (action) {
                case CREATE: {
                    this.createCollection(this.zkStateReader.getClusterState(), message, results);
                    break;
                }
                case DELETE: {
                    this.deleteCollection(message, results);
                    break;
                }
                case RELOAD: {
                    this.reloadCollection(message, results);
                    break;
                }
                case CREATEALIAS: {
                    this.createAlias(this.zkStateReader.getAliases(), message);
                    break;
                }
                case DELETEALIAS: {
                    this.deleteAlias(this.zkStateReader.getAliases(), message);
                    break;
                }
                case SPLITSHARD: {
                    this.splitShard(this.zkStateReader.getClusterState(), message, results);
                    break;
                }
                case DELETESHARD: {
                    this.deleteShard(this.zkStateReader.getClusterState(), message, results);
                    break;
                }
                case CREATESHARD: {
                    this.createShard(this.zkStateReader.getClusterState(), message, results);
                    break;
                }
                case DELETEREPLICA: {
                    this.deleteReplica(this.zkStateReader.getClusterState(), message, results);
                    break;
                }
                case MIGRATE: {
                    this.migrate(this.zkStateReader.getClusterState(), message, results);
                    break;
                }
                case ADDROLE: {
                    this.processRoleCommand(message, operation);
                    break;
                }
                case REMOVEROLE: {
                    this.processRoleCommand(message, operation);
                    break;
                }
                case ADDREPLICA: {
                    this.addReplica(this.zkStateReader.getClusterState(), message, results);
                    break;
                }
                case OVERSEERSTATUS: {
                    this.getOverseerStatus(message, results);
                    break;
                }
                case ADDREPLICAPROP: {
                    this.processReplicaAddPropertyCommand(message);
                    break;
                }
                case DELETEREPLICAPROP: {
                    this.processReplicaDeletePropertyCommand(message);
                    break;
                }
                case BALANCESHARDUNIQUE: {
                    this.balanceProperty(message);
                    break;
                }
                case REBALANCELEADERS: {
                    this.processRebalanceLeaders(message);
                    break;
                }
                case MODIFYCOLLECTION: {
                    Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(Utils.toJSON(message));
                    break;
                }
                case MIGRATESTATEFORMAT: {
                    this.migrateStateFormat(message, results);
                    break;
                }
                default: {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown operation:" + operation);
                }
            }
        }
        catch (Exception e) {
            String collName = message.getStr("collection");
            if (collName == null) {
                collName = message.getStr("name");
            }
            if (collName == null) {
                SolrException.log(log, "Operation " + operation + " failed", e);
            } else {
                SolrException.log(log, "Collection: " + collName + " operation: " + operation + " failed", e);
            }
            results.add("Operation " + operation + " caused exception:", e);
            SimpleOrderedMap<Object> nl = new SimpleOrderedMap<Object>();
            nl.add("msg", e.getMessage());
            nl.add("rspCode", e instanceof SolrException ? ((SolrException)e).code() : -1);
            results.add("exception", nl);
        }
        return new OverseerSolrResponse(results);
    }

    private void reloadCollection(ZkNodeProps message, NamedList results) {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", CoreAdminParams.CoreAdminAction.RELOAD.toString());
        String asyncId = message.getStr("async");
        HashMap<String, String> requestMap = null;
        if (asyncId != null) {
            requestMap = new HashMap<String, String>();
        }
        this.collectionCmd(message, params, results, Replica.State.ACTIVE, asyncId, requestMap);
    }

    private void processRebalanceLeaders(ZkNodeProps message) throws KeeperException, InterruptedException {
        this.checkRequired(message, "collection", "shard", "core", "election_node", "core_node_name", "base_url", "rejoinAtHead");
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("collection", message.getStr("collection"));
        params.set("shard", message.getStr("shard"));
        params.set("rejoinAtHead", message.getStr("rejoinAtHead"));
        params.set("action", CoreAdminParams.CoreAdminAction.REJOINLEADERELECTION.toString());
        params.set("core", message.getStr("core"));
        params.set("core_node_name", message.getStr("core_node_name"));
        params.set("election_node", message.getStr("election_node"));
        params.set("base_url", message.getStr("base_url"));
        String baseUrl = message.getStr("base_url");
        ShardRequest sreq = new ShardRequest();
        sreq.nodeName = message.getStr("core");
        params.set("qt", this.adminPath);
        sreq.purpose = 1;
        sreq.shards = new String[]{baseUrl};
        sreq.actualShards = sreq.shards;
        sreq.params = params;
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        shardHandler.submit(sreq, baseUrl, sreq.params);
    }

    private void processReplicaAddPropertyCommand(ZkNodeProps message) throws KeeperException, InterruptedException {
        this.checkRequired(message, "collection", "shard", "replica", "property", "property.value");
        SolrZkClient zkClient = this.zkStateReader.getZkClient();
        DistributedQueue inQueue = Overseer.getInQueue(zkClient);
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        propMap.put("operation", CollectionParams.CollectionAction.ADDREPLICAPROP.toLower());
        propMap.putAll(message.getProperties());
        ZkNodeProps m = new ZkNodeProps(propMap);
        inQueue.offer(Utils.toJSON(m));
    }

    private void processReplicaDeletePropertyCommand(ZkNodeProps message) throws KeeperException, InterruptedException {
        this.checkRequired(message, "collection", "shard", "replica", "property");
        SolrZkClient zkClient = this.zkStateReader.getZkClient();
        DistributedQueue inQueue = Overseer.getInQueue(zkClient);
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        propMap.put("operation", CollectionParams.CollectionAction.DELETEREPLICAPROP.toLower());
        propMap.putAll(message.getProperties());
        ZkNodeProps m = new ZkNodeProps(propMap);
        inQueue.offer(Utils.toJSON(m));
    }

    private void balanceProperty(ZkNodeProps message) throws KeeperException, InterruptedException {
        if (StringUtils.isBlank(message.getStr("collection")) || StringUtils.isBlank(message.getStr("property"))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The 'collection' and 'property' parameters are required for the BALANCESHARDUNIQUE operation, no action taken");
        }
        SolrZkClient zkClient = this.zkStateReader.getZkClient();
        DistributedQueue inQueue = Overseer.getInQueue(zkClient);
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        propMap.put("operation", CollectionParams.CollectionAction.BALANCESHARDUNIQUE.toLower());
        propMap.putAll(message.getProperties());
        inQueue.offer(Utils.toJSON(new ZkNodeProps(propMap)));
    }

    private void getOverseerStatus(ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String leaderNode = OverseerTaskProcessor.getLeaderNode(this.zkStateReader.getZkClient());
        results.add("leader", leaderNode);
        Stat stat = new Stat();
        this.zkStateReader.getZkClient().getData("/overseer/queue", null, stat, true);
        results.add("overseer_queue_size", stat.getNumChildren());
        stat = new Stat();
        this.zkStateReader.getZkClient().getData("/overseer/queue-work", null, stat, true);
        results.add("overseer_work_queue_size", stat.getNumChildren());
        stat = new Stat();
        this.zkStateReader.getZkClient().getData("/overseer/collection-queue-work", null, stat, true);
        results.add("overseer_collection_queue_size", stat.getNumChildren());
        NamedList overseerStats = new NamedList();
        NamedList collectionStats = new NamedList();
        NamedList stateUpdateQueueStats = new NamedList();
        NamedList workQueueStats = new NamedList();
        NamedList collectionQueueStats = new NamedList();
        for (Map.Entry<String, Overseer.Stat> entry : this.stats.getStats().entrySet()) {
            String key = entry.getKey();
            SimpleOrderedMap<Serializable> lst = new SimpleOrderedMap<Serializable>();
            if (key.startsWith("collection_")) {
                collectionStats.add(key.substring(11), lst);
                int successes = this.stats.getSuccessCount(entry.getKey());
                int errors = this.stats.getErrorCount(entry.getKey());
                lst.add("requests", Integer.valueOf(successes));
                lst.add("errors", Integer.valueOf(errors));
                List<Overseer.FailedOp> failureDetails = this.stats.getFailureDetails(key);
                if (failureDetails != null) {
                    ArrayList failures = new ArrayList();
                    for (Overseer.FailedOp failedOp : failureDetails) {
                        SimpleOrderedMap<Object> fail = new SimpleOrderedMap<Object>();
                        fail.add("request", failedOp.req.getProperties());
                        fail.add("response", failedOp.resp.getResponse());
                        failures.add(fail);
                    }
                    lst.add("recent_failures", failures);
                }
            } else if (key.startsWith("/overseer/queue_")) {
                stateUpdateQueueStats.add(key.substring(16), lst);
            } else if (key.startsWith("/overseer/queue-work_")) {
                workQueueStats.add(key.substring(21), lst);
            } else if (key.startsWith("/overseer/collection-queue-work_")) {
                collectionQueueStats.add(key.substring(32), lst);
            } else {
                overseerStats.add(key, lst);
                int successes = this.stats.getSuccessCount(entry.getKey());
                int errors = this.stats.getErrorCount(entry.getKey());
                lst.add("requests", Integer.valueOf(successes));
                lst.add("errors", Integer.valueOf(errors));
            }
            Timer timer = entry.getValue().requestTime;
            Snapshot snapshot = timer.getSnapshot();
            lst.add("totalTime", Double.valueOf(timer.getSum()));
            lst.add("avgRequestsPerMinute", Double.valueOf(timer.getMeanRate()));
            lst.add("5minRateRequestsPerMinute", Double.valueOf(timer.getFiveMinuteRate()));
            lst.add("15minRateRequestsPerMinute", Double.valueOf(timer.getFifteenMinuteRate()));
            lst.add("avgTimePerRequest", Double.valueOf(timer.getMean()));
            lst.add("medianRequestTime", Double.valueOf(snapshot.getMedian()));
            lst.add("75thPctlRequestTime", Double.valueOf(snapshot.get75thPercentile()));
            lst.add("95thPctlRequestTime", Double.valueOf(snapshot.get95thPercentile()));
            lst.add("99thPctlRequestTime", Double.valueOf(snapshot.get99thPercentile()));
            lst.add("999thPctlRequestTime", Double.valueOf(snapshot.get999thPercentile()));
        }
        results.add("overseer_operations", overseerStats);
        results.add("collection_operations", collectionStats);
        results.add("overseer_queue", stateUpdateQueueStats);
        results.add("overseer_internal_queue", workQueueStats);
        results.add("collection_queue", collectionQueueStats);
    }

    private void getClusterStatus(ClusterState clusterState, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String collection = message.getStr("collection");
        Aliases aliases = this.zkStateReader.getAliases();
        HashMap<String, ArrayList<String>> collectionVsAliases = new HashMap<String, ArrayList<String>>();
        Map<String, String> aliasVsCollections = aliases.getCollectionAliasMap();
        if (aliasVsCollections != null) {
            for (Map.Entry<String, String> entry : aliasVsCollections.entrySet()) {
                List<String> colls = StrUtils.splitSmart(entry.getValue(), ',');
                String alias = entry.getKey();
                for (String coll : colls) {
                    if (collection != null && !collection.equals(coll)) continue;
                    ArrayList<String> list = (ArrayList<String>)collectionVsAliases.get(coll);
                    if (list == null) {
                        list = new ArrayList<String>();
                        collectionVsAliases.put(coll, list);
                    }
                    list.add(alias);
                }
            }
        }
        Map roles = null;
        if (this.zkStateReader.getZkClient().exists("/roles.json", true).booleanValue()) {
            roles = (Map)Utils.fromJSON(this.zkStateReader.getZkClient().getData("/roles.json", null, null, true));
        }
        byte[] bytes = Utils.toJSON(clusterState);
        Map stateMap = (Map)Utils.fromJSON(bytes);
        Set<Object> collections = new HashSet();
        String routeKey = message.getStr("_route_");
        String shard = message.getStr("shard");
        collections = collection == null ? new HashSet<String>(clusterState.getCollections()) : Collections.singleton(collection);
        SimpleOrderedMap<Object> collectionProps = new SimpleOrderedMap<Object>();
        for (String string : collections) {
            Map<String, Object> collectionStatus = null;
            DocCollection clusterStateCollection = clusterState.getCollection(string);
            HashSet<String> requestedShards = new HashSet<String>();
            if (routeKey != null) {
                DocRouter router = clusterStateCollection.getRouter();
                Collection<Slice> slices = router.getSearchSlices(routeKey, null, clusterStateCollection);
                for (Slice slice : slices) {
                    requestedShards.add(slice.getName());
                }
            }
            if (shard != null) {
                requestedShards.add(shard);
            }
            if (clusterStateCollection.getStateFormat() > 1) {
                bytes = Utils.toJSON(clusterStateCollection);
                Map docCollection = (Map)Utils.fromJSON(bytes);
                collectionStatus = this.getCollectionStatus(docCollection, string, requestedShards);
            } else {
                collectionStatus = this.getCollectionStatus((Map)stateMap.get(string), string, requestedShards);
            }
            collectionStatus.put("znodeVersion", clusterStateCollection.getZNodeVersion());
            if (collectionVsAliases.containsKey(string) && !((List)collectionVsAliases.get(string)).isEmpty()) {
                collectionStatus.put("aliases", collectionVsAliases.get(string));
            }
            String configName = this.zkStateReader.readConfigName(string);
            collectionStatus.put("configName", configName);
            collectionProps.add(string, collectionStatus);
        }
        List<String> liveNodes = this.zkStateReader.getZkClient().getChildren("/live_nodes", null, true);
        this.crossCheckReplicaStateWithLiveNodes(liveNodes, collectionProps);
        SimpleOrderedMap<Object> simpleOrderedMap = new SimpleOrderedMap<Object>();
        simpleOrderedMap.add("collections", collectionProps);
        Map clusterProps = this.zkStateReader.getClusterProps();
        if (clusterProps != null && !clusterProps.isEmpty()) {
            simpleOrderedMap.add("properties", clusterProps);
        }
        if (aliasVsCollections != null && !aliasVsCollections.isEmpty()) {
            simpleOrderedMap.add("aliases", aliasVsCollections);
        }
        if (roles != null) {
            simpleOrderedMap.add("roles", roles);
        }
        simpleOrderedMap.add("live_nodes", liveNodes);
        results.add("cluster", simpleOrderedMap);
    }

    protected void crossCheckReplicaStateWithLiveNodes(List<String> liveNodes, NamedList<Object> collectionProps) {
        for (Map.Entry<String, Object> entry : collectionProps) {
            Map collMap = (Map)entry.getValue();
            Map shards = (Map)collMap.get(SHARDS_PROP);
            for (Object nextShard : shards.values()) {
                Map shardMap = (Map)nextShard;
                Map replicas = (Map)shardMap.get("replicas");
                for (Object nextReplica : replicas.values()) {
                    String node_name;
                    Map replicaMap = (Map)nextReplica;
                    if (Replica.State.getState((String)replicaMap.get("state")) == Replica.State.DOWN || liveNodes.contains(node_name = (String)replicaMap.get("node_name"))) continue;
                    replicaMap.put("state", Replica.State.DOWN.toString());
                }
            }
        }
    }

    private Map<String, Object> getCollectionStatus(Map<String, Object> collection, String name, Set<String> requestedShards) {
        if (collection == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + name + " not found");
        }
        if (requestedShards == null || requestedShards.isEmpty()) {
            return collection;
        }
        Map shards = (Map)collection.get(SHARDS_PROP);
        HashMap selected = new HashMap();
        for (String selectedShard : requestedShards) {
            if (!shards.containsKey(selectedShard)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + name + " shard: " + selectedShard + " not found");
            }
            selected.put(selectedShard, shards.get(selectedShard));
            collection.put(SHARDS_PROP, selected);
        }
        return collection;
    }

    private void processRoleCommand(ZkNodeProps message, String operation) throws KeeperException, InterruptedException {
        SolrZkClient zkClient = this.zkStateReader.getZkClient();
        Map roles = null;
        String node = message.getStr("node");
        String roleName = message.getStr("role");
        boolean nodeExists = false;
        nodeExists = zkClient.exists("/roles.json", true);
        roles = nodeExists ? (Map)Utils.fromJSON(zkClient.getData("/roles.json", null, new Stat(), true)) : new LinkedHashMap(1);
        ArrayList<String> nodeList = (ArrayList<String>)roles.get(roleName);
        if (nodeList == null) {
            nodeList = new ArrayList<String>();
            roles.put(roleName, nodeList);
        }
        if (CollectionParams.CollectionAction.ADDROLE.toString().toLowerCase(Locale.ROOT).equals(operation)) {
            log.info("Overseer role added to {}", (Object)node);
            if (!nodeList.contains(node)) {
                nodeList.add(node);
            }
        } else if (CollectionParams.CollectionAction.REMOVEROLE.toString().toLowerCase(Locale.ROOT).equals(operation)) {
            log.info("Overseer role removed from {}", (Object)node);
            nodeList.remove(node);
        }
        if (nodeExists) {
            zkClient.setData("/roles.json", Utils.toJSON(roles), true);
        } else {
            zkClient.create("/roles.json", Utils.toJSON(roles), CreateMode.PERSISTENT, true);
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    OverseerCollectionMessageHandler.this.overseerPrioritizer.prioritizeOverseerNodes(OverseerCollectionMessageHandler.this.myId);
                }
                catch (Exception e) {
                    log.error("Error in prioritizing Overseer", (Throwable)e);
                }
            }
        }.start();
    }

    private void deleteReplica(ClusterState clusterState, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        this.checkRequired(message, "collection", "shard", "replica");
        String collectionName = message.getStr("collection");
        String shard = message.getStr("shard");
        String replicaName = message.getStr("replica");
        DocCollection coll = clusterState.getCollection(collectionName);
        Slice slice = coll.getSlice(shard);
        if (slice == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid shard name : " + shard + " in collection : " + collectionName);
        }
        Replica replica = slice.getReplica(replicaName);
        if (replica == null) {
            ArrayList<String> l = new ArrayList<String>();
            for (Replica r : slice.getReplicas()) {
                l.add(r.getName());
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid replica : " + replicaName + " in shard/collection : " + shard + "/" + collectionName + " available replicas are " + StrUtils.join(l, ','));
        }
        if (Boolean.parseBoolean(message.getStr(ONLY_IF_DOWN)) && replica.getState() != Replica.State.DOWN) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Attempted to remove replica : " + collectionName + "/" + shard + "/" + replicaName + " with onlyIfDown='true', but state is '" + replica.getStr("state") + "'");
        }
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        String core = replica.getStr("core");
        String asyncId = message.getStr("async");
        HashMap<String, String> requestMap = null;
        if (asyncId != null) {
            requestMap = new HashMap<String, String>(1, 1.0f);
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("action", CoreAdminParams.CoreAdminAction.UNLOAD.toString());
        params.add("core", core);
        params.add("deleteInstanceDir", "true");
        params.add("deleteDataDir", "true");
        this.sendShardRequest(replica.getNodeName(), params, shardHandler, asyncId, requestMap);
        this.processResponses(results, shardHandler, false, null, asyncId, requestMap);
        if (this.waitForCoreNodeGone(collectionName, shard, replicaName, 5000)) {
            return;
        }
        this.deleteCoreNode(collectionName, replicaName, replica, core);
        if (this.waitForCoreNodeGone(collectionName, shard, replicaName, 30000)) {
            return;
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not  remove replica : " + collectionName + "/" + shard + "/" + replicaName);
    }

    private boolean waitForCoreNodeGone(String collectionName, String shard, String replicaName, int timeoutms) throws InterruptedException {
        TimeOut timeout = new TimeOut(timeoutms, TimeUnit.MILLISECONDS);
        boolean deleted = false;
        while (!timeout.hasTimedOut()) {
            Slice slice;
            Thread.sleep(100L);
            DocCollection docCollection = this.zkStateReader.getClusterState().getCollection(collectionName);
            if (docCollection != null && ((slice = docCollection.getSlice(shard)) == null || slice.getReplica(replicaName) == null)) {
                deleted = true;
            }
            if (docCollection != null && !deleted) continue;
            break;
        }
        return deleted;
    }

    private void deleteCoreNode(String collectionName, String replicaName, Replica replica, String core) throws KeeperException, InterruptedException {
        ZkNodeProps m = new ZkNodeProps("operation", OverseerAction.DELETECORE.toLower(), "core", core, "node_name", replica.getStr("node_name"), "collection", collectionName, "core_node_name", replicaName);
        Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(Utils.toJSON(m));
    }

    private void checkRequired(ZkNodeProps message, String ... props) {
        for (String prop : props) {
            if (message.get(prop) != null) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, StrUtils.join(Arrays.asList(props), ',') + " are required params");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCollection(ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String collection = message.getStr("name");
        try {
            if (this.zkStateReader.getClusterState().getCollectionOrNull(collection) == null && this.zkStateReader.getZkClient().exists("/collections/" + collection, true).booleanValue()) {
                return;
            }
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", CoreAdminParams.CoreAdminAction.UNLOAD.toString());
            params.set("deleteInstanceDir", true);
            params.set("deleteDataDir", true);
            String asyncId = message.getStr("async");
            HashMap<String, String> requestMap = null;
            if (asyncId != null) {
                requestMap = new HashMap<String, String>();
            }
            HashSet<String> okayExceptions = new HashSet<String>(1);
            okayExceptions.add(NonExistentCoreException.class.getName());
            this.collectionCmd(message, params, results, null, asyncId, requestMap, okayExceptions);
            ZkNodeProps m = new ZkNodeProps("operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", collection);
            Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(Utils.toJSON(m));
            TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS);
            boolean removed = false;
            while (!timeout.hasTimedOut()) {
                Thread.sleep(100L);
                removed = !this.zkStateReader.getClusterState().hasCollection(collection);
                if (!removed) continue;
                Thread.sleep(500L);
                break;
            }
            if (!removed) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully remove collection: " + collection);
            }
        }
        finally {
            try {
                if (this.zkStateReader.getZkClient().exists("/collections/" + collection, true).booleanValue()) {
                    this.zkStateReader.getZkClient().clean("/collections/" + collection);
                }
            }
            catch (InterruptedException e) {
                SolrException.log(log, "Cleaning up collection in zk was interrupted:" + collection, e);
                Thread.currentThread().interrupt();
            }
            catch (KeeperException e) {
                SolrException.log(log, "Problem cleaning up collection in zk:" + collection, e);
            }
        }
    }

    private void migrateStateFormat(ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String collectionName = message.getStr("collection");
        boolean firstLoop = true;
        TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS);
        while (!timeout.hasTimedOut()) {
            DocCollection collection = this.zkStateReader.getClusterState().getCollection(collectionName);
            if (collection == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collectionName + " not found");
            }
            if (collection.getStateFormat() == 2) {
                results.add("success", new SimpleOrderedMap());
                return;
            }
            if (firstLoop) {
                firstLoop = false;
                ZkNodeProps m = new ZkNodeProps("operation", CollectionParams.CollectionAction.MIGRATESTATEFORMAT.toLower(), "collection", collectionName);
                Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(Utils.toJSON(m));
            }
            Thread.sleep(100L);
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not migrate state format for collection: " + collectionName);
    }

    private void createAlias(Aliases aliases, ZkNodeProps message) {
        String aliasName = message.getStr("name");
        String collections = message.getStr("collections");
        HashMap<String, Map<String, String>> newAliasesMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> newCollectionAliasesMap = new HashMap<String, String>();
        Map<String, String> prevColAliases = aliases.getCollectionAliasMap();
        if (prevColAliases != null) {
            newCollectionAliasesMap.putAll(prevColAliases);
        }
        newCollectionAliasesMap.put(aliasName, collections);
        newAliasesMap.put("collection", newCollectionAliasesMap);
        Aliases newAliases = new Aliases(newAliasesMap);
        byte[] jsonBytes = null;
        if (newAliases.collectionAliasSize() > 0) {
            jsonBytes = Utils.toJSON(newAliases.getAliasMap());
        }
        try {
            this.zkStateReader.getZkClient().setData("/aliases.json", jsonBytes, true);
            this.checkForAlias(aliasName, collections);
            Thread.sleep(100L);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.warn("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private void checkForAlias(String name, String value) {
        TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS);
        boolean success = false;
        while (!timeout.hasTimedOut()) {
            Aliases aliases = this.zkStateReader.getAliases();
            String collections = aliases.getCollectionAlias(name);
            if (collections == null || !collections.equals(value)) continue;
            success = true;
            break;
        }
        if (!success) {
            log.warn("Timeout waiting to be notified of Alias change...");
        }
    }

    private void checkForAliasAbsence(String name) {
        TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS);
        boolean success = false;
        Aliases aliases = null;
        while (!timeout.hasTimedOut()) {
            aliases = this.zkStateReader.getAliases();
            String collections = aliases.getCollectionAlias(name);
            if (collections != null) continue;
            success = true;
            break;
        }
        if (!success) {
            log.warn("Timeout waiting to be notified of Alias change...");
        }
    }

    private void deleteAlias(Aliases aliases, ZkNodeProps message) {
        String aliasName = message.getStr("name");
        HashMap<String, Map<String, String>> newAliasesMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> newCollectionAliasesMap = new HashMap<String, String>();
        newCollectionAliasesMap.putAll(aliases.getCollectionAliasMap());
        newCollectionAliasesMap.remove(aliasName);
        newAliasesMap.put("collection", newCollectionAliasesMap);
        Aliases newAliases = new Aliases(newAliasesMap);
        byte[] jsonBytes = null;
        if (newAliases.collectionAliasSize() > 0) {
            jsonBytes = Utils.toJSON(newAliases.getAliasMap());
        }
        try {
            this.zkStateReader.getZkClient().setData("/aliases.json", jsonBytes, true);
            this.checkForAliasAbsence(aliasName);
            Thread.sleep(100L);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.warn("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private boolean createShard(ClusterState clusterState, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String collectionName = message.getStr("collection");
        String sliceName = message.getStr("shard");
        log.info("Create shard invoked: {}", (Object)message);
        if (collectionName == null || sliceName == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'collection' and 'shard' are required parameters");
        }
        int numSlices = 1;
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        DocCollection collection = clusterState.getCollection(collectionName);
        int repFactor = message.getInt("replicationFactor", collection.getInt("replicationFactor", 1));
        String createNodeSetStr = message.getStr(CREATE_NODE_SET);
        List<Assign.ReplicaCount> sortedNodeList = Assign.getNodesForNewReplicas(clusterState, collectionName, sliceName, repFactor, createNodeSetStr, this.overseer.getZkController().getCoreContainer());
        Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(Utils.toJSON(message));
        TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS);
        boolean created = false;
        while (!timeout.hasTimedOut()) {
            Thread.sleep(100L);
            created = this.zkStateReader.getClusterState().getCollection(collectionName).getSlice(sliceName) != null;
            if (!created) continue;
        }
        if (!created) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully create shard: " + message.getStr("name"));
        }
        String configName = message.getStr(COLL_CONF);
        String async = message.getStr("async");
        HashMap<String, String> requestMap = null;
        if (async != null) {
            requestMap = new HashMap<String, String>(repFactor, 1.0f);
        }
        for (int j = 1; j <= repFactor; ++j) {
            String nodeName = sortedNodeList.get((int)((j - 1) % sortedNodeList.size())).nodeName;
            String shardName = collectionName + "_" + sliceName + "_replica" + j;
            log.info("Creating shard " + shardName + " as part of slice " + sliceName + " of collection " + collectionName + " on " + nodeName);
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", CoreAdminParams.CoreAdminAction.CREATE.toString());
            params.set("name", shardName);
            params.set(COLL_CONF, configName);
            params.set("collection", collectionName);
            params.set("shard", sliceName);
            params.set(NUM_SLICES, numSlices);
            this.addPropertyParams(message, params);
            this.sendShardRequest(nodeName, params, shardHandler, async, requestMap);
        }
        this.processResponses(results, shardHandler, true, "Failed to create shard", async, requestMap, Collections.emptySet());
        log.info("Finished create command on all shards for collection: " + collectionName);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean splitShard(ClusterState clusterState, ZkNodeProps message, NamedList results) {
        Slice parentSlice;
        DocRouter router;
        String collectionName = message.getStr("collection");
        String slice = message.getStr("shard");
        log.info("Split shard invoked");
        String splitKey = message.getStr("split.key");
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        DocCollection collection = clusterState.getCollection(collectionName);
        DocRouter docRouter = router = collection.getRouter() != null ? collection.getRouter() : DocRouter.DEFAULT;
        if (slice == null) {
            if (!(router instanceof CompositeIdRouter)) throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Split by route key can only be used with CompositeIdRouter or subclass. Found router: " + router.getClass().getName());
            Collection<Slice> searchSlices = router.getSearchSlicesSingle(splitKey, new ModifiableSolrParams(), collection);
            if (searchSlices.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to find an active shard for split.key: " + splitKey);
            }
            if (searchSlices.size() > 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Splitting a split.key: " + splitKey + " which spans multiple shards is not supported");
            }
            parentSlice = searchSlices.iterator().next();
            slice = parentSlice.getName();
            log.info("Split by route.key: {}, parent shard is: {} ", (Object)splitKey, (Object)slice);
        } else {
            parentSlice = clusterState.getSlice(collectionName, slice);
        }
        if (parentSlice == null) {
            if (!clusterState.hasCollection(collectionName)) throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No collection with the specified name exists: " + collectionName);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard with the specified name exists: " + slice);
        }
        Replica parentShardLeader = null;
        try {
            parentShardLeader = this.zkStateReader.getLeaderRetry(collectionName, slice, 10000);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        DocRouter.Range range = parentSlice.getRange();
        if (range == null) {
            range = new PlainIdRouter().fullRange();
        }
        List<DocRouter.Range> subRanges = null;
        String rangesStr = message.getStr("ranges");
        if (rangesStr != null) {
            String[] ranges = rangesStr.split(",");
            if (ranges.length == 0 || ranges.length == 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "There must be at least two ranges specified to split a shard");
            }
            subRanges = new ArrayList<DocRouter.Range>(ranges.length);
            for (int i = 0; i < ranges.length; ++i) {
                String r = ranges[i];
                try {
                    subRanges.add(DocRouter.DEFAULT.fromString(r));
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Exception in parsing hexadecimal hash range: " + r, (Throwable)e);
                }
                if (subRanges.get(i).isSubsetOf(range)) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specified hash range: " + r + " is not a subset of parent shard's range: " + range.toString());
            }
            ArrayList<DocRouter.Range> temp = new ArrayList<DocRouter.Range>(subRanges);
            Collections.sort(temp);
            if (!range.equals(new DocRouter.Range(((DocRouter.Range)temp.get((int)0)).min, ((DocRouter.Range)temp.get((int)(temp.size() - 1))).max))) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specified hash ranges: " + rangesStr + " do not cover the entire range of parent shard: " + range);
            }
            for (int i = 1; i < temp.size(); ++i) {
                if (((DocRouter.Range)temp.get((int)(i - 1))).max + 1 == ((DocRouter.Range)temp.get((int)i)).min) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specified hash ranges: " + rangesStr + " either overlap with each other or " + "do not cover the entire range of parent shard: " + range);
            }
        } else if (splitKey != null) {
            if (router instanceof CompositeIdRouter) {
                CompositeIdRouter compositeIdRouter = (CompositeIdRouter)router;
                subRanges = compositeIdRouter.partitionRangeByKey(splitKey, range);
                if (subRanges.size() == 1) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The split.key: " + splitKey + " has a hash range that is exactly equal to hash range of shard: " + slice);
                }
                for (DocRouter.Range subRange : subRanges) {
                    if (subRange.min != subRange.max) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The split.key: " + splitKey + " must be a compositeId");
                }
                log.info("Partitioning parent shard " + slice + " range: " + parentSlice.getRange() + " yields: " + subRanges);
                rangesStr = "";
                for (int i = 0; i < subRanges.size(); ++i) {
                    DocRouter.Range subRange;
                    subRange = subRanges.get(i);
                    rangesStr = rangesStr + subRange.toString();
                    if (i >= subRanges.size() - 1) continue;
                    rangesStr = rangesStr + ',';
                }
            }
        } else {
            subRanges = router.partitionRange(2, range);
        }
        try {
            ZkNodeProps m;
            DistributedQueue inQueue;
            int i;
            String subShardName;
            ArrayList<String> subSlices = new ArrayList<String>(subRanges.size());
            ArrayList<String> subShardNames = new ArrayList<String>(subRanges.size());
            String nodeName = parentShardLeader.getNodeName();
            for (int i2 = 0; i2 < subRanges.size(); ++i2) {
                String subSlice = slice + "_" + i2;
                subSlices.add(subSlice);
                String subShardName2 = collectionName + "_" + subSlice + "_replica1";
                subShardNames.add(subShardName2);
                Slice oSlice = clusterState.getSlice(collectionName, subSlice);
                if (oSlice == null) continue;
                Slice.State state = oSlice.getState();
                if (state == Slice.State.ACTIVE) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Sub-shard: " + subSlice + " exists in active state. Aborting split shard.");
                }
                if (state != Slice.State.CONSTRUCTION && state != Slice.State.RECOVERY) continue;
                for (String sub : subSlices) {
                    log.info("Sub-shard: {} already exists therefore requesting its deletion", (Object)sub);
                    HashMap<String, Object> propMap = new HashMap<String, Object>();
                    propMap.put("operation", "deleteshard");
                    propMap.put("collection", collectionName);
                    propMap.put("shard", sub);
                    ZkNodeProps m2 = new ZkNodeProps(propMap);
                    try {
                        this.deleteShard(clusterState, m2, new NamedList());
                    }
                    catch (Exception exception) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to delete already existing sub shard: " + sub, (Throwable)exception);
                    }
                }
            }
            String asyncId = message.getStr("async");
            HashMap<String, String> requestMap = new HashMap<String, String>();
            for (int i3 = 0; i3 < subRanges.size(); ++i3) {
                String subSlice = (String)subSlices.get(i3);
                subShardName = (String)subShardNames.get(i3);
                DocRouter.Range subRange = subRanges.get(i3);
                log.info("Creating slice " + subSlice + " of collection " + collectionName + " on " + nodeName);
                HashMap<String, Object> propMap = new HashMap<String, Object>();
                propMap.put("operation", CollectionParams.CollectionAction.CREATESHARD.toLower());
                propMap.put("shard", subSlice);
                propMap.put("collection", collectionName);
                propMap.put("shard_range", subRange.toString());
                propMap.put("shard_state", Slice.State.CONSTRUCTION.toString());
                propMap.put("shard_parent", parentSlice.getName());
                DistributedQueue inQueue2 = Overseer.getInQueue(this.zkStateReader.getZkClient());
                inQueue2.offer(Utils.toJSON(new ZkNodeProps(propMap)));
                this.waitForNewShard(collectionName, subSlice);
                clusterState = this.zkStateReader.getClusterState();
                log.info("Adding replica " + subShardName + " as part of slice " + subSlice + " of collection " + collectionName + " on " + nodeName);
                propMap = new HashMap();
                propMap.put("operation", CollectionParams.CollectionAction.ADDREPLICA.toLower());
                propMap.put("collection", collectionName);
                propMap.put("shard", subSlice);
                propMap.put("node", nodeName);
                propMap.put("name", subShardName);
                for (String string : message.keySet()) {
                    if (!string.startsWith(COLL_PROP_PREFIX)) continue;
                    propMap.put(string, message.getStr(string));
                }
                if (asyncId != null) {
                    propMap.put("async", asyncId);
                }
                this.addReplica(clusterState, new ZkNodeProps(propMap), results);
            }
            this.processResponses(results, shardHandler, true, "SPLITSHARD failed to create subshard leaders", asyncId, requestMap);
            for (String subShardName3 : subShardNames) {
                log.info("Asking parent leader to wait for: " + subShardName3 + " to be alive on: " + nodeName);
                String coreNodeName = this.waitForCoreNodeName(collectionName, nodeName, subShardName3);
                CoreAdminRequest.WaitForState cmd = new CoreAdminRequest.WaitForState();
                cmd.setCoreName(subShardName3);
                cmd.setNodeName(nodeName);
                cmd.setCoreNodeName(coreNodeName);
                cmd.setState(Replica.State.ACTIVE);
                cmd.setCheckLive(true);
                cmd.setOnlyIfLeader(true);
                ModifiableSolrParams p = new ModifiableSolrParams(cmd.getParams());
                this.sendShardRequest(nodeName, p, shardHandler, asyncId, requestMap);
            }
            this.processResponses(results, shardHandler, true, "SPLITSHARD timed out waiting for subshard leaders to come up", asyncId, requestMap);
            log.info("Successfully created all sub-shards for collection " + collectionName + " parent shard: " + slice + " on: " + parentShardLeader);
            log.info("Splitting shard " + parentShardLeader.getName() + " as part of slice " + slice + " of collection " + collectionName + " on " + parentShardLeader);
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", CoreAdminParams.CoreAdminAction.SPLIT.toString());
            params.set("core", parentShardLeader.getStr("core"));
            for (i = 0; i < subShardNames.size(); ++i) {
                subShardName = (String)subShardNames.get(i);
                params.add("targetCore", subShardName);
            }
            params.set("ranges", rangesStr);
            this.sendShardRequest(parentShardLeader.getNodeName(), params, shardHandler, asyncId, requestMap);
            this.processResponses(results, shardHandler, true, "SPLITSHARD failed to invoke SPLIT core admin command", asyncId, requestMap);
            log.info("Index on shard: " + nodeName + " split into two successfully");
            for (i = 0; i < subShardNames.size(); ++i) {
                subShardName = (String)subShardNames.get(i);
                log.info("Applying buffered updates on : " + subShardName);
                params = new ModifiableSolrParams();
                params.set("action", CoreAdminParams.CoreAdminAction.REQUESTAPPLYUPDATES.toString());
                params.set("name", subShardName);
                this.sendShardRequest(nodeName, params, shardHandler, asyncId, requestMap);
            }
            this.processResponses(results, shardHandler, true, "SPLITSHARD failed while asking sub shard leaders to apply buffered updates", asyncId, requestMap);
            log.info("Successfully applied buffered updates on : " + subShardNames);
            int repFactor = clusterState.getSlice(collectionName, slice).getReplicas().size();
            Set<String> nodes = clusterState.getLiveNodes();
            ArrayList<String> nodeList = new ArrayList<String>(nodes.size());
            nodeList.addAll(nodes);
            nodeList.remove(nodeName);
            Map<ReplicaAssigner.Position, String> nodeMap = this.identifyNodes(clusterState, new ArrayList<String>(clusterState.getLiveNodes()), new ZkNodeProps(collection.getProperties()), subSlices, repFactor - 1);
            ArrayList replicas = new ArrayList((repFactor - 1) * 2);
            for (Map.Entry entry : nodeMap.entrySet()) {
                String sliceName = ((ReplicaAssigner.Position)entry.getKey()).shard;
                String subShardNodeName = (String)entry.getValue();
                String shardName = collectionName + "_" + sliceName + "_replica" + ((ReplicaAssigner.Position)entry.getKey()).index;
                log.info("Creating replica shard " + shardName + " as part of slice " + sliceName + " of collection " + collectionName + " on " + subShardNodeName);
                ZkNodeProps props = new ZkNodeProps("operation", CollectionParams.CollectionAction.ADDREPLICA.toLower(), "collection", collectionName, "shard", sliceName, "core", shardName, "state", Replica.State.DOWN.toString(), "base_url", this.zkStateReader.getBaseUrlForNodeName(subShardNodeName), "node_name", subShardNodeName);
                Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(Utils.toJSON(props));
                HashMap<String, String> propMap = new HashMap<String, String>();
                propMap.put("operation", CollectionParams.CollectionAction.ADDREPLICA.toLower());
                propMap.put("collection", collectionName);
                propMap.put("shard", sliceName);
                propMap.put("node", subShardNodeName);
                propMap.put("name", shardName);
                for (String key : message.keySet()) {
                    if (!key.startsWith(COLL_PROP_PREFIX)) continue;
                    propMap.put(key, message.getStr(key));
                }
                if (asyncId != null) {
                    propMap.put("async", asyncId);
                }
                propMap.put(SKIP_CREATE_REPLICA_IN_CLUSTER_STATE, "true");
                replicas.add(propMap);
            }
            if (repFactor == 1) {
                log.info("Replication factor is 1 so switching shard states");
                inQueue = Overseer.getInQueue(this.zkStateReader.getZkClient());
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
                hashMap.put(slice, Slice.State.INACTIVE.toString());
                for (String subSlice : subSlices) {
                    hashMap.put(subSlice, Slice.State.ACTIVE.toString());
                }
                hashMap.put("collection", collectionName);
                m = new ZkNodeProps(hashMap);
                inQueue.offer(Utils.toJSON(m));
            } else {
                log.info("Requesting shard state be set to 'recovery'");
                inQueue = Overseer.getInQueue(this.zkStateReader.getZkClient());
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
                for (String subSlice : subSlices) {
                    hashMap.put(subSlice, Slice.State.RECOVERY.toString());
                }
                hashMap.put("collection", collectionName);
                m = new ZkNodeProps(hashMap);
                inQueue.offer(Utils.toJSON(m));
            }
            for (Map map : replicas) {
                this.addReplica(clusterState, new ZkNodeProps(map), results);
            }
            this.processResponses(results, shardHandler, true, "SPLITSHARD failed to create subshard replicas", asyncId, requestMap);
            log.info("Successfully created all replica shards for all sub-slices " + subSlices);
            this.commit(results, slice, parentShardLeader);
            return true;
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Error executing split operation for collection: " + collectionName + " parent shard: " + slice, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)e);
        }
    }

    private void commit(NamedList results, String slice, Replica parentShardLeader) {
        log.info("Calling soft commit to make sub shard updates visible");
        String coreUrl = new ZkCoreNodeProps(parentShardLeader).getCoreUrl();
        UpdateResponse updateResponse = null;
        try {
            updateResponse = OverseerCollectionMessageHandler.softCommit(coreUrl);
            this.processResponse(results, null, coreUrl, updateResponse, slice, Collections.emptySet());
        }
        catch (Exception e) {
            this.processResponse(results, e, coreUrl, updateResponse, slice, Collections.emptySet());
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to call distrib softCommit on: " + coreUrl, (Throwable)e);
        }
    }

    static UpdateResponse softCommit(String url) throws SolrServerException, IOException {
        try (HttpSolrClient client = new HttpSolrClient(url);){
            client.setConnectionTimeout(30000);
            client.setSoTimeout(120000);
            UpdateRequest ureq = new UpdateRequest();
            ureq.setParams(new ModifiableSolrParams());
            ureq.setAction(AbstractUpdateRequest.ACTION.COMMIT, false, true, true);
            UpdateResponse updateResponse = (UpdateResponse)ureq.process(client);
            return updateResponse;
        }
    }

    private String waitForCoreNodeName(String collectionName, String msgNodeName, String msgCore) {
        int retryCount = 320;
        while (retryCount-- > 0) {
            Map<String, Slice> slicesMap = this.zkStateReader.getClusterState().getSlicesMap(collectionName);
            if (slicesMap != null) {
                for (Slice slice : slicesMap.values()) {
                    for (Replica replica : slice.getReplicas()) {
                        String nodeName = replica.getStr("node_name");
                        String core = replica.getStr("core");
                        if (!nodeName.equals(msgNodeName) || !core.equals(msgCore)) continue;
                        return replica.getName();
                    }
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not find coreNodeName");
    }

    private void waitForNewShard(String collectionName, String sliceName) throws KeeperException, InterruptedException {
        log.info("Waiting for slice {} of collection {} to be available", (Object)sliceName, (Object)collectionName);
        RTimer timer = new RTimer();
        int retryCount = 320;
        while (retryCount-- > 0) {
            DocCollection collection = this.zkStateReader.getClusterState().getCollection(collectionName);
            if (collection == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to find collection: " + collectionName + " in clusterstate");
            }
            Slice slice = collection.getSlice(sliceName);
            if (slice != null) {
                log.info("Waited for {}ms for slice {} of collection {} to be available", new Object[]{timer.getTime(), sliceName, collectionName});
                return;
            }
            Thread.sleep(1000L);
            this.zkStateReader.updateClusterState();
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not find new slice " + sliceName + " in collection " + collectionName + " even after waiting for " + timer.getTime() + "ms");
    }

    private void deleteShard(ClusterState clusterState, ZkNodeProps message, NamedList results) {
        String collection = message.getStr("collection");
        String sliceId = message.getStr("shard");
        log.info("Delete shard invoked");
        Slice slice = clusterState.getSlice(collection, sliceId);
        if (slice == null) {
            if (clusterState.hasCollection(collection)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard with name " + sliceId + " exists for collection " + collection);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No collection with the specified name exists: " + collection);
        }
        Slice.State state = slice.getState();
        if (slice.getRange() != null && state != Slice.State.INACTIVE && state != Slice.State.RECOVERY && state != Slice.State.CONSTRUCTION) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The slice: " + slice.getName() + " is currently " + (Object)((Object)state) + ". Only non-active (or custom-hashed) slices can be deleted.");
        }
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        String asyncId = message.getStr("async");
        HashMap<String, String> requestMap = null;
        if (asyncId != null) {
            requestMap = new HashMap<String, String>(slice.getReplicas().size(), 1.0f);
        }
        try {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", CoreAdminParams.CoreAdminAction.UNLOAD.toString());
            params.set("deleteIndex", "true");
            this.sliceCmd(clusterState, params, null, slice, shardHandler, asyncId, requestMap);
            this.processResponses(results, shardHandler, true, "Failed to delete shard", asyncId, requestMap, Collections.emptySet());
            ZkNodeProps m = new ZkNodeProps("operation", CollectionParams.CollectionAction.DELETESHARD.toLower(), "collection", collection, "shard", sliceId);
            Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(Utils.toJSON(m));
            TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS);
            boolean removed = false;
            while (!timeout.hasTimedOut()) {
                Thread.sleep(100L);
                removed = this.zkStateReader.getClusterState().getSlice(collection, sliceId) == null;
                if (!removed) continue;
                Thread.sleep(100L);
                break;
            }
            if (!removed) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully remove collection: " + collection + " shard: " + sliceId);
            }
            log.info("Successfully deleted collection: " + collection + ", shard: " + sliceId);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error executing delete operation for collection: " + collection + " shard: " + sliceId, (Throwable)e);
        }
    }

    private void migrate(ClusterState clusterState, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String sourceCollectionName = message.getStr("collection");
        String splitKey = message.getStr("split.key");
        String targetCollectionName = message.getStr("target.collection");
        int timeout = message.getInt("forward.timeout", 600) * 1000;
        DocCollection sourceCollection = clusterState.getCollection(sourceCollectionName);
        if (sourceCollection == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown source collection: " + sourceCollectionName);
        }
        DocCollection targetCollection = clusterState.getCollection(targetCollectionName);
        if (targetCollection == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown target collection: " + sourceCollectionName);
        }
        if (!(sourceCollection.getRouter() instanceof CompositeIdRouter)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Source collection must use a compositeId router");
        }
        if (!(targetCollection.getRouter() instanceof CompositeIdRouter)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Target collection must use a compositeId router");
        }
        CompositeIdRouter sourceRouter = (CompositeIdRouter)sourceCollection.getRouter();
        CompositeIdRouter targetRouter = (CompositeIdRouter)targetCollection.getRouter();
        Collection<Slice> sourceSlices = sourceRouter.getSearchSlicesSingle(splitKey, null, sourceCollection);
        if (sourceSlices.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No active slices available in source collection: " + sourceCollection + "for given split.key: " + splitKey);
        }
        Collection<Slice> targetSlices = targetRouter.getSearchSlicesSingle(splitKey, null, targetCollection);
        if (targetSlices.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No active slices available in target collection: " + targetCollection + "for given split.key: " + splitKey);
        }
        String asyncId = null;
        if (message.containsKey("async") && message.get("async") != null) {
            asyncId = message.getStr("async");
        }
        for (Slice sourceSlice : sourceSlices) {
            for (Slice targetSlice : targetSlices) {
                log.info("Migrating source shard: {} to target shard: {} for split.key = " + splitKey, (Object)sourceSlice, (Object)targetSlice);
                this.migrateKey(clusterState, sourceCollection, sourceSlice, targetCollection, targetSlice, splitKey, timeout, results, asyncId, message);
            }
        }
    }

    private void migrateKey(ClusterState clusterState, DocCollection sourceCollection, Slice sourceSlice, DocCollection targetCollection, Slice targetSlice, String splitKey, int timeout, NamedList results, String asyncId, ZkNodeProps message) throws KeeperException, InterruptedException {
        String tempSourceCollectionName = "split_" + sourceSlice.getName() + "_temp_" + targetSlice.getName();
        if (clusterState.hasCollection(tempSourceCollectionName)) {
            log.info("Deleting temporary collection: " + tempSourceCollectionName);
            Map<String, Object> props = Utils.makeMap("operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", tempSourceCollectionName);
            try {
                this.deleteCollection(new ZkNodeProps(props), results);
                clusterState = this.zkStateReader.getClusterState();
            }
            catch (Exception e) {
                log.warn("Unable to clean up existing temporary collection: " + tempSourceCollectionName, (Throwable)e);
            }
        }
        CompositeIdRouter sourceRouter = (CompositeIdRouter)sourceCollection.getRouter();
        DocRouter.Range keyHashRange = sourceRouter.keyHashRange(splitKey);
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        log.info("Hash range for split.key: {} is: {}", (Object)splitKey, (Object)keyHashRange);
        DocRouter.Range splitRange = this.intersect(targetSlice.getRange(), this.intersect(sourceSlice.getRange(), keyHashRange));
        if (splitRange == null) {
            log.info("No common hashes between source shard: {} and target shard: {}", (Object)sourceSlice.getName(), (Object)targetSlice.getName());
            return;
        }
        log.info("Common hash range between source shard: {} and target shard: {} = " + splitRange, (Object)sourceSlice.getName(), (Object)targetSlice.getName());
        Replica targetLeader = this.zkStateReader.getLeaderRetry(targetCollection.getName(), targetSlice.getName(), 10000);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        log.info("Asking target leader node: " + targetLeader.getNodeName() + " core: " + targetLeader.getStr("core") + " to buffer updates");
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", CoreAdminParams.CoreAdminAction.REQUESTBUFFERUPDATES.toString());
        params.set("name", targetLeader.getStr("core"));
        this.sendShardRequest(targetLeader.getNodeName(), params, shardHandler, asyncId, requestMap);
        this.processResponses(results, shardHandler, true, "MIGRATE failed to request node to buffer updates", asyncId, requestMap);
        ZkNodeProps m = new ZkNodeProps("operation", OverseerAction.ADDROUTINGRULE.toLower(), "collection", sourceCollection.getName(), "shard", sourceSlice.getName(), "routeKey", SolrIndexSplitter.getRouteKey(splitKey) + "!", "range", splitRange.toString(), "targetCollection", targetCollection.getName(), "expireAt", RoutingRule.makeExpiryAt(timeout));
        log.info("Adding routing rule: " + m);
        Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(Utils.toJSON(m));
        log.info("Waiting to see routing rule updated in clusterstate");
        TimeOut waitUntil = new TimeOut(60L, TimeUnit.SECONDS);
        boolean added = false;
        while (!waitUntil.hasTimedOut()) {
            RoutingRule rule;
            Thread.sleep(100L);
            Map<String, RoutingRule> rules = this.zkStateReader.getClusterState().getSlice(sourceCollection.getName(), sourceSlice.getName()).getRoutingRules();
            if (rules == null || (rule = rules.get(SolrIndexSplitter.getRouteKey(splitKey) + "!")) == null || !rule.getRouteRanges().contains(splitRange)) continue;
            added = true;
            break;
        }
        if (!added) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not add routing rule: " + m);
        }
        log.info("Routing rule added successfully");
        Replica sourceLeader = this.zkStateReader.getLeaderRetry(sourceCollection.getName(), sourceSlice.getName(), 10000);
        String configName = this.zkStateReader.readConfigName(sourceCollection.getName());
        Map<String, Object> props = Utils.makeMap("operation", CollectionParams.CollectionAction.CREATE.toLower(), "name", tempSourceCollectionName, "replicationFactor", 1, NUM_SLICES, 1, COLL_CONF, configName, CREATE_NODE_SET, sourceLeader.getNodeName());
        if (asyncId != null) {
            String internalAsyncId = asyncId + Math.abs(System.nanoTime());
            props.put("async", internalAsyncId);
        }
        log.info("Creating temporary collection: " + props);
        this.createCollection(clusterState, new ZkNodeProps(props), results);
        clusterState = this.zkStateReader.getClusterState();
        Slice tempSourceSlice = clusterState.getCollection(tempSourceCollectionName).getSlices().iterator().next();
        Replica tempSourceLeader = this.zkStateReader.getLeaderRetry(tempSourceCollectionName, tempSourceSlice.getName(), 120000);
        String tempCollectionReplica1 = tempSourceCollectionName + "_" + tempSourceSlice.getName() + "_replica1";
        String coreNodeName = this.waitForCoreNodeName(tempSourceCollectionName, sourceLeader.getNodeName(), tempCollectionReplica1);
        log.info("Asking source leader to wait for: " + tempCollectionReplica1 + " to be alive on: " + sourceLeader.getNodeName());
        CoreAdminRequest.WaitForState cmd = new CoreAdminRequest.WaitForState();
        cmd.setCoreName(tempCollectionReplica1);
        cmd.setNodeName(sourceLeader.getNodeName());
        cmd.setCoreNodeName(coreNodeName);
        cmd.setState(Replica.State.ACTIVE);
        cmd.setCheckLive(true);
        cmd.setOnlyIfLeader(true);
        this.sendShardRequest(tempSourceLeader.getNodeName(), new ModifiableSolrParams(cmd.getParams()), shardHandler, null, null);
        this.processResponses(results, shardHandler, true, "MIGRATE failed to create temp collection leader or timed out waiting for it to come up", asyncId, requestMap);
        log.info("Asking source leader to split index");
        params = new ModifiableSolrParams();
        params.set("action", CoreAdminParams.CoreAdminAction.SPLIT.toString());
        params.set("core", sourceLeader.getStr("core"));
        params.add("targetCore", tempSourceLeader.getStr("core"));
        params.set("ranges", splitRange.toString());
        params.set("split.key", splitKey);
        String tempNodeName = sourceLeader.getNodeName();
        this.sendShardRequest(tempNodeName, params, shardHandler, asyncId, requestMap);
        this.processResponses(results, shardHandler, true, "MIGRATE failed to invoke SPLIT core admin command", asyncId, requestMap);
        log.info("Creating a replica of temporary collection: {} on the target leader node: {}", (Object)tempSourceCollectionName, (Object)targetLeader.getNodeName());
        String tempCollectionReplica2 = tempSourceCollectionName + "_" + tempSourceSlice.getName() + "_replica2";
        props = new HashMap<String, Object>();
        props.put("operation", CollectionParams.CollectionAction.ADDREPLICA.toLower());
        props.put("collection", tempSourceCollectionName);
        props.put("shard", tempSourceSlice.getName());
        props.put("node", targetLeader.getNodeName());
        props.put("name", tempCollectionReplica2);
        for (String key : message.keySet()) {
            if (!key.startsWith(COLL_PROP_PREFIX)) continue;
            props.put(key, message.getStr(key));
        }
        if (asyncId != null) {
            props.put("async", asyncId);
        }
        this.addReplica(clusterState, new ZkNodeProps(props), results);
        this.processResponses(results, shardHandler, true, "MIGRATE failed to create replica of temporary collection in target leader node.", asyncId, requestMap);
        coreNodeName = this.waitForCoreNodeName(tempSourceCollectionName, targetLeader.getNodeName(), tempCollectionReplica2);
        log.info("Asking temp source leader to wait for: " + tempCollectionReplica2 + " to be alive on: " + targetLeader.getNodeName());
        cmd = new CoreAdminRequest.WaitForState();
        cmd.setCoreName(tempSourceLeader.getStr("core"));
        cmd.setNodeName(targetLeader.getNodeName());
        cmd.setCoreNodeName(coreNodeName);
        cmd.setState(Replica.State.ACTIVE);
        cmd.setCheckLive(true);
        cmd.setOnlyIfLeader(true);
        params = new ModifiableSolrParams(cmd.getParams());
        this.sendShardRequest(tempSourceLeader.getNodeName(), params, shardHandler, asyncId, requestMap);
        this.processResponses(results, shardHandler, true, "MIGRATE failed to create temp collection replica or timed out waiting for them to come up", asyncId, requestMap);
        log.info("Successfully created replica of temp source collection on target leader node");
        log.info("Requesting merge of temp source collection replica to target leader");
        params = new ModifiableSolrParams();
        params.set("action", CoreAdminParams.CoreAdminAction.MERGEINDEXES.toString());
        params.set("core", targetLeader.getStr("core"));
        params.set("srcCore", tempCollectionReplica2);
        this.sendShardRequest(targetLeader.getNodeName(), params, shardHandler, asyncId, requestMap);
        String msg = "MIGRATE failed to merge " + tempCollectionReplica2 + " to " + targetLeader.getStr("core") + " on node: " + targetLeader.getNodeName();
        this.processResponses(results, shardHandler, true, msg, asyncId, requestMap);
        log.info("Asking target leader to apply buffered updates");
        params = new ModifiableSolrParams();
        params.set("action", CoreAdminParams.CoreAdminAction.REQUESTAPPLYUPDATES.toString());
        params.set("name", targetLeader.getStr("core"));
        this.sendShardRequest(targetLeader.getNodeName(), params, shardHandler, asyncId, requestMap);
        this.processResponses(results, shardHandler, true, "MIGRATE failed to request node to apply buffered updates", asyncId, requestMap);
        try {
            log.info("Deleting temporary collection: " + tempSourceCollectionName);
            props = Utils.makeMap("operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", tempSourceCollectionName);
            this.deleteCollection(new ZkNodeProps(props), results);
        }
        catch (Exception e) {
            log.error("Unable to delete temporary collection: " + tempSourceCollectionName + ". Please remove it manually", (Throwable)e);
        }
    }

    private DocRouter.Range intersect(DocRouter.Range a, DocRouter.Range b) {
        if (a == null || b == null || !a.overlaps(b)) {
            return null;
        }
        if (a.isSubsetOf(b)) {
            return a;
        }
        if (b.isSubsetOf(a)) {
            return b;
        }
        if (b.includes(a.max)) {
            return new DocRouter.Range(b.min, a.max);
        }
        return new DocRouter.Range(a.min, b.max);
    }

    private void sendShardRequest(String nodeName, ModifiableSolrParams params, ShardHandler shardHandler, String asyncId, Map<String, String> requestMap) {
        OverseerCollectionMessageHandler.sendShardRequest(nodeName, params, shardHandler, asyncId, requestMap, this.adminPath, this.zkStateReader);
    }

    public static void sendShardRequest(String nodeName, ModifiableSolrParams params, ShardHandler shardHandler, String asyncId, Map<String, String> requestMap, String adminPath, ZkStateReader zkStateReader) {
        if (asyncId != null) {
            String coreAdminAsyncId = asyncId + Math.abs(System.nanoTime());
            params.set("async", coreAdminAsyncId);
            requestMap.put(nodeName, coreAdminAsyncId);
        }
        ShardRequest sreq = new ShardRequest();
        params.set("qt", adminPath);
        sreq.purpose = 1;
        String replica = zkStateReader.getBaseUrlForNodeName(nodeName);
        sreq.shards = new String[]{replica};
        sreq.actualShards = sreq.shards;
        sreq.nodeName = nodeName;
        sreq.params = params;
        shardHandler.submit(sreq, replica, sreq.params);
    }

    private void addPropertyParams(ZkNodeProps message, ModifiableSolrParams params) {
        for (String key : message.keySet()) {
            if (!key.startsWith(COLL_PROP_PREFIX)) continue;
            params.set(key, message.getStr(key));
        }
    }

    private static List<String> getLiveOrLiveAndCreateNodeSetList(Set<String> liveNodes, ZkNodeProps message, Random random) {
        ArrayList<String> nodeList;
        List<String> createNodeList;
        String createNodeSetStr = message.getStr(CREATE_NODE_SET);
        List<String> list = createNodeSetStr == null ? null : (createNodeList = StrUtils.splitSmart(CREATE_NODE_SET_EMPTY.equals(createNodeSetStr) ? "" : createNodeSetStr, ",", true));
        if (createNodeList != null) {
            nodeList = new ArrayList<String>(createNodeList);
            nodeList.retainAll(liveNodes);
            if (message.getBool(CREATE_NODE_SET_SHUFFLE, true)) {
                Collections.shuffle(nodeList, random);
            }
        } else {
            nodeList = new ArrayList<String>(liveNodes);
            Collections.shuffle(nodeList, random);
        }
        return nodeList;
    }

    private void createCollection(ClusterState clusterState, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String collectionName = message.getStr("name");
        log.info("Create collection {}", (Object)collectionName);
        if (clusterState.hasCollection(collectionName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "collection already exists: " + collectionName);
        }
        String configName = this.getConfigName(collectionName, message);
        if (configName == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No config set found to associate with the collection.");
        }
        if (!this.validateConfig(configName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not find the specified config set: " + configName);
        }
        try {
            Map<Object, Object> positionVsNodes;
            int repFactor = message.getInt("replicationFactor", 1);
            ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
            String async = message.getStr("async");
            Integer numSlices = message.getInt(NUM_SLICES, null);
            String router = message.getStr("router.name", "compositeId");
            ArrayList<String> shardNames = new ArrayList<String>();
            if ("implicit".equals(router)) {
                ClusterStateMutator.getShardNames(shardNames, message.getStr(SHARDS_PROP, null));
                numSlices = shardNames.size();
            } else {
                if (numSlices == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards is a required param (when using CompositeId router).");
                }
                ClusterStateMutator.getShardNames(numSlices, shardNames);
            }
            int maxShardsPerNode = message.getInt("maxShardsPerNode", 1);
            if (repFactor <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "replicationFactor must be greater than 0");
            }
            if (numSlices <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards must be > 0");
            }
            List<String> nodeList = OverseerCollectionMessageHandler.getLiveOrLiveAndCreateNodeSetList(clusterState.getLiveNodes(), message, RANDOM);
            if (nodeList.isEmpty()) {
                log.warn("It is unusual to create a collection (" + collectionName + ") without cores.");
                positionVsNodes = new HashMap();
            } else {
                int requestedShardsToCreate;
                int maxShardsAllowedToCreate;
                if (repFactor > nodeList.size()) {
                    log.warn("Specified replicationFactor of " + repFactor + " on collection " + collectionName + " is higher than or equal to the number of Solr instances currently live or live and part of your " + CREATE_NODE_SET + "(" + nodeList.size() + "). It's unusual to run two replica of the same slice on the same Solr-instance.");
                }
                if ((maxShardsAllowedToCreate = maxShardsPerNode * nodeList.size()) < (requestedShardsToCreate = numSlices * repFactor)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot create collection " + collectionName + ". Value of " + "maxShardsPerNode" + " is " + maxShardsPerNode + ", and the number of nodes currently live or live and part of your " + CREATE_NODE_SET + " is " + nodeList.size() + ". This allows a maximum of " + maxShardsAllowedToCreate + " to be created. Value of " + NUM_SLICES + " is " + numSlices + " and value of " + "replicationFactor" + " is " + repFactor + ". This requires " + requestedShardsToCreate + " shards to be created (higher than the allowed number)");
                }
                positionVsNodes = this.identifyNodes(clusterState, nodeList, message, shardNames, repFactor);
            }
            boolean isLegacyCloud = Overseer.isLegacy(this.zkStateReader.getClusterProps());
            this.createConfNode(configName, collectionName, isLegacyCloud);
            Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(Utils.toJSON(message));
            TimeOut waitUntil = new TimeOut(30L, TimeUnit.SECONDS);
            boolean created = false;
            while (!waitUntil.hasTimedOut()) {
                Thread.sleep(100L);
                created = this.zkStateReader.getClusterState().hasCollection(collectionName);
                if (!created) continue;
            }
            if (!created) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully create collection: " + collectionName);
            }
            if (nodeList.isEmpty()) {
                log.info("Finished create command for collection: {}", (Object)collectionName);
                return;
            }
            HashMap<String, String> requestMap = new HashMap<String, String>();
            log.info(StrUtils.formatString("Creating SolrCores for new collection {0}, shardNames {1} , replicationFactor : {2}", collectionName, shardNames, repFactor));
            LinkedHashMap<String, ShardRequest> coresToCreate = new LinkedHashMap<String, ShardRequest>();
            for (Map.Entry<Object, Object> e : positionVsNodes.entrySet()) {
                ReplicaAssigner.Position position = (ReplicaAssigner.Position)e.getKey();
                String nodeName = (String)e.getValue();
                String coreName = collectionName + "_" + position.shard + "_replica" + (position.index + 1);
                log.info(StrUtils.formatString("Creating core {0} as part of shard {1} of collection {2} on {3}", coreName, position.shard, collectionName, nodeName));
                String baseUrl = this.zkStateReader.getBaseUrlForNodeName(nodeName);
                if (!isLegacyCloud) {
                    ZkNodeProps props = new ZkNodeProps("operation", CollectionParams.CollectionAction.ADDREPLICA.toString(), "collection", collectionName, "shard", position.shard, "core", coreName, "state", Replica.State.DOWN.toString(), "base_url", baseUrl);
                    Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(Utils.toJSON(props));
                }
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.set("action", CoreAdminParams.CoreAdminAction.CREATE.toString());
                params.set("name", coreName);
                params.set(COLL_CONF, configName);
                params.set("collection", collectionName);
                params.set("shard", position.shard);
                params.set(NUM_SLICES, numSlices);
                if (async != null) {
                    String coreAdminAsyncId = async + Math.abs(System.nanoTime());
                    params.add("async", coreAdminAsyncId);
                    requestMap.put(nodeName, coreAdminAsyncId);
                }
                this.addPropertyParams(message, params);
                ShardRequest sreq = new ShardRequest();
                sreq.nodeName = nodeName;
                params.set("qt", this.adminPath);
                sreq.purpose = 1;
                sreq.shards = new String[]{baseUrl};
                sreq.actualShards = sreq.shards;
                sreq.params = params;
                if (isLegacyCloud) {
                    shardHandler.submit(sreq, sreq.shards[0], sreq.params);
                    continue;
                }
                coresToCreate.put(coreName, sreq);
            }
            if (!isLegacyCloud) {
                Map<String, Replica> replicas = this.waitToSeeReplicasInState(collectionName, coresToCreate.keySet());
                for (Map.Entry e : coresToCreate.entrySet()) {
                    ShardRequest sreq = (ShardRequest)e.getValue();
                    sreq.params.set("coreNodeName", replicas.get(e.getKey()).getName());
                    shardHandler.submit(sreq, sreq.shards[0], sreq.params);
                }
            }
            this.processResponses(results, shardHandler, false, null, async, requestMap, Collections.emptySet());
            if (results.get("failure") != null && ((SimpleOrderedMap)results.get("failure")).size() > 0) {
                this.cleanupCollection(collectionName, new NamedList());
                log.info("Cleaned up  artifacts for failed create collection for [" + collectionName + "]");
            } else {
                log.debug("Finished create command on all shards for collection: " + collectionName);
            }
        }
        catch (SolrException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)ex);
        }
    }

    private void cleanupCollection(String collectionName, NamedList results) throws KeeperException, InterruptedException {
        log.error("Cleaning up collection [" + collectionName + "].");
        Map<String, Object> props = Utils.makeMap("operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", collectionName);
        this.deleteCollection(new ZkNodeProps(props), results);
    }

    private Map<ReplicaAssigner.Position, String> identifyNodes(ClusterState clusterState, List<String> nodeList, ZkNodeProps message, List<String> shardNames, int repFactor) throws IOException {
        List rulesMap = (List)message.get("rule");
        if (rulesMap == null) {
            int i = 0;
            HashMap<ReplicaAssigner.Position, String> result = new HashMap<ReplicaAssigner.Position, String>();
            for (String aShard : shardNames) {
                for (int j = 0; j < repFactor; ++j) {
                    result.put(new ReplicaAssigner.Position(aShard, j), nodeList.get(i % nodeList.size()));
                    ++i;
                }
            }
            return result;
        }
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Object map : rulesMap) {
            rules.add(new Rule((Map)map));
        }
        HashMap<String, Integer> sharVsReplicaCount = new HashMap<String, Integer>();
        for (String shard : shardNames) {
            sharVsReplicaCount.put(shard, repFactor);
        }
        ReplicaAssigner replicaAssigner = new ReplicaAssigner(rules, sharVsReplicaCount, (List)message.get("snitch"), new HashMap<String, Map<String, Integer>>(), nodeList, this.overseer.getZkController().getCoreContainer(), clusterState);
        return replicaAssigner.getNodeMappings();
    }

    private Map<String, Replica> waitToSeeReplicasInState(String collectionName, Collection<String> coreNames) throws InterruptedException {
        HashMap<String, Replica> result = new HashMap<String, Replica>();
        TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS);
        while (true) {
            DocCollection coll = this.zkStateReader.getClusterState().getCollection(collectionName);
            for (String coreName : coreNames) {
                if (result.containsKey(coreName)) continue;
                block2: for (Slice slice : coll.getSlices()) {
                    for (Replica replica : slice.getReplicas()) {
                        if (!coreName.equals(replica.getStr("core"))) continue;
                        result.put(coreName, replica);
                        continue block2;
                    }
                }
            }
            if (result.size() == coreNames.size()) {
                return result;
            }
            if (timeout.hasTimedOut()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Timed out waiting to see all replicas: " + coreNames + " in cluster state.");
            }
            Thread.sleep(100L);
        }
    }

    private void addReplica(ClusterState clusterState, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String collection = message.getStr("collection");
        String node = message.getStr("node");
        String shard = message.getStr("shard");
        String coreName = message.getStr("name");
        if (StringUtils.isBlank(coreName)) {
            coreName = message.getStr("property.name");
        }
        String asyncId = message.getStr("async");
        DocCollection coll = clusterState.getCollection(collection);
        if (coll == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collection + " does not exist");
        }
        if (coll.getSlice(shard) == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection: " + collection + " shard: " + shard + " does not exist");
        }
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        boolean skipCreateReplicaInClusterState = message.getBool(SKIP_CREATE_REPLICA_IN_CLUSTER_STATE, false);
        if (!skipCreateReplicaInClusterState) {
            node = Assign.getNodesForNewReplicas((ClusterState)clusterState, (String)collection, (String)shard, (int)1, (String)node, (CoreContainer)this.overseer.getZkController().getCoreContainer()).get((int)0).nodeName;
        }
        log.info("Node not provided, Identified {} for creating new replica", (Object)node);
        if (!clusterState.liveNodesContain(node)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Node: " + node + " is not live");
        }
        if (coreName == null) {
            coreName = Assign.buildCoreName(coll, shard);
        } else if (!skipCreateReplicaInClusterState) {
            for (Slice slice : coll.getSlices()) {
                for (Replica replica : slice.getReplicas()) {
                    String replicaCoreName = replica.getStr("core");
                    if (!coreName.equals(replicaCoreName)) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Another replica with the same core name already exists for this collection");
                }
            }
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        if (!Overseer.isLegacy(this.zkStateReader.getClusterProps())) {
            if (!skipCreateReplicaInClusterState) {
                ZkNodeProps props = new ZkNodeProps("operation", CollectionParams.CollectionAction.ADDREPLICA.toLower(), "collection", collection, "shard", shard, "core", coreName, "state", Replica.State.DOWN.toString(), "base_url", this.zkStateReader.getBaseUrlForNodeName(node), "node_name", node);
                Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(Utils.toJSON(props));
            }
            params.set("coreNodeName", this.waitToSeeReplicasInState(collection, Collections.singletonList(coreName)).get(coreName).getName());
        }
        String configName = this.zkStateReader.readConfigName(collection);
        String routeKey = message.getStr("_route_");
        String dataDir = message.getStr("dataDir");
        String instanceDir = message.getStr("instanceDir");
        params.set("action", CoreAdminParams.CoreAdminAction.CREATE.toString());
        params.set("name", coreName);
        params.set(COLL_CONF, configName);
        params.set("collection", collection);
        if (shard != null) {
            params.set("shard", shard);
        } else if (routeKey != null) {
            Collection<Slice> slices = coll.getRouter().getSearchSlicesSingle(routeKey, null, coll);
            if (slices.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No active shard serving _route_=" + routeKey + " found");
            }
            params.set("shard", slices.iterator().next().getName());
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specify either 'shard' or _route_ param");
        }
        if (dataDir != null) {
            params.set("dataDir", dataDir);
        }
        if (instanceDir != null) {
            params.set("instanceDir", instanceDir);
        }
        this.addPropertyParams(message, params);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        this.sendShardRequest(node, params, shardHandler, asyncId, requestMap);
        this.processResponses(results, shardHandler, true, "ADDREPLICA failed to create replica", asyncId, requestMap);
    }

    private void processResponses(NamedList results, ShardHandler shardHandler, boolean abortOnError, String msgOnError, String asyncId, Map<String, String> requestMap) {
        this.processResponses(results, shardHandler, abortOnError, msgOnError, asyncId, requestMap, Collections.emptySet());
    }

    private void processResponses(NamedList results, ShardHandler shardHandler, boolean abortOnError, String msgOnError, String asyncId, Map<String, String> requestMap, Set<String> okayExceptions) {
        ShardResponse srsp;
        do {
            if ((srsp = shardHandler.takeCompletedOrError()) == null) continue;
            this.processResponse(results, srsp, okayExceptions);
            Throwable exception = srsp.getException();
            if (!abortOnError || exception == null) continue;
            while (srsp != null) {
                srsp = shardHandler.takeCompletedOrError();
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msgOnError, exception);
        } while (srsp != null);
        if (asyncId != null) {
            this.waitForAsyncCallsToComplete(requestMap, results);
            requestMap.clear();
        }
    }

    private String getConfigName(String coll, ZkNodeProps message) throws KeeperException, InterruptedException {
        String configName = message.getStr(COLL_CONF);
        if (configName == null) {
            List<String> configNames = null;
            try {
                configNames = this.zkStateReader.getZkClient().getChildren("/configs", null, true);
                if (configNames != null && configNames.size() == 1) {
                    configName = configNames.get(0);
                    log.info("Only one config set found in zk - using it:" + configName);
                } else if (configNames.contains(coll)) {
                    configName = coll;
                }
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
        }
        return configName;
    }

    private boolean validateConfig(String configName) throws KeeperException, InterruptedException {
        return this.zkStateReader.getZkClient().exists("/configs/" + configName, true);
    }

    private void createConfNode(String configName, String coll, boolean isLegacyCloud) throws KeeperException, InterruptedException {
        if (configName != null) {
            String collDir = "/collections/" + coll;
            log.info("creating collections conf node {} ", (Object)collDir);
            byte[] data = Utils.toJSON(Utils.makeMap("configName", configName));
            if (this.zkStateReader.getZkClient().exists(collDir, true).booleanValue()) {
                this.zkStateReader.getZkClient().setData(collDir, data, true);
            } else {
                this.zkStateReader.getZkClient().makePath(collDir, data, true);
            }
        } else if (isLegacyCloud) {
            log.warn("Could not obtain config name");
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to get config name");
        }
    }

    private void collectionCmd(ZkNodeProps message, ModifiableSolrParams params, NamedList results, Replica.State stateMatcher, String asyncId, Map<String, String> requestMap) {
        this.collectionCmd(message, params, results, stateMatcher, asyncId, requestMap, Collections.emptySet());
    }

    private void collectionCmd(ZkNodeProps message, ModifiableSolrParams params, NamedList results, Replica.State stateMatcher, String asyncId, Map<String, String> requestMap, Set<String> okayExceptions) {
        log.info("Executing Collection Cmd : " + params);
        String collectionName = message.getStr("name");
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        ClusterState clusterState = this.zkStateReader.getClusterState();
        DocCollection coll = clusterState.getCollection(collectionName);
        for (Slice slice : coll.getSlices()) {
            this.sliceCmd(clusterState, params, stateMatcher, slice, shardHandler, asyncId, requestMap);
        }
        this.processResponses(results, shardHandler, false, null, asyncId, requestMap, okayExceptions);
    }

    private void sliceCmd(ClusterState clusterState, ModifiableSolrParams params, Replica.State stateMatcher, Slice slice, ShardHandler shardHandler, String asyncId, Map<String, String> requestMap) {
        for (Replica replica : slice.getReplicas()) {
            if (!clusterState.liveNodesContain(replica.getStr("node_name")) || stateMatcher != null && Replica.State.getState(replica.getStr("state")) != stateMatcher) continue;
            ModifiableSolrParams cloneParams = new ModifiableSolrParams();
            cloneParams.add(params);
            cloneParams.set("core", replica.getStr("core"));
            this.sendShardRequest(replica.getStr("node_name"), cloneParams, shardHandler, asyncId, requestMap);
        }
    }

    private void processResponse(NamedList results, ShardResponse srsp, Set<String> okayExceptions) {
        Throwable e = srsp.getException();
        String nodeName = srsp.getNodeName();
        SolrResponse solrResponse = srsp.getSolrResponse();
        String shard = srsp.getShard();
        this.processResponse(results, e, nodeName, solrResponse, shard, okayExceptions);
    }

    private void processResponse(NamedList results, Throwable e, String nodeName, SolrResponse solrResponse, String shard, Set<String> okayExceptions) {
        String rootThrowable = null;
        if (e instanceof HttpSolrClient.RemoteSolrException) {
            rootThrowable = ((HttpSolrClient.RemoteSolrException)e).getRootThrowable();
        }
        if (!(e == null || rootThrowable != null && okayExceptions.contains(rootThrowable))) {
            log.error("Error from shard: " + shard, e);
            SimpleOrderedMap<String> failure = (SimpleOrderedMap<String>)results.get("failure");
            if (failure == null) {
                failure = new SimpleOrderedMap<String>();
                results.add("failure", failure);
            }
            failure.add(nodeName, e.getClass().getName() + ":" + e.getMessage());
        } else {
            SimpleOrderedMap<NamedList<Object>> success = (SimpleOrderedMap<NamedList<Object>>)results.get("success");
            if (success == null) {
                success = new SimpleOrderedMap<NamedList<Object>>();
                results.add("success", success);
            }
            success.add(nodeName, solrResponse.getResponse());
        }
    }

    private void waitForAsyncCallsToComplete(Map<String, String> requestMap, NamedList results) {
        for (String k : requestMap.keySet()) {
            log.debug("I am Waiting for :{}/{}", (Object)k, (Object)requestMap.get(k));
            results.add(requestMap.get(k), this.waitForCoreAdminAsyncCallToComplete(k, requestMap.get(k)));
        }
    }

    private NamedList waitForCoreAdminAsyncCallToComplete(String nodeName, String requestId) {
        ShardHandler shardHandler = this.shardHandlerFactory.getShardHandler();
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", CoreAdminParams.CoreAdminAction.REQUESTSTATUS.toString());
        params.set(REQUESTID, requestId);
        int counter = 0;
        block4: while (true) {
            ShardResponse srsp;
            ShardRequest sreq = new ShardRequest();
            params.set("qt", this.adminPath);
            sreq.purpose = 1;
            String replica = this.zkStateReader.getBaseUrlForNodeName(nodeName);
            sreq.shards = new String[]{replica};
            sreq.actualShards = sreq.shards;
            sreq.params = params;
            shardHandler.submit(sreq, replica, sreq.params);
            do {
                if ((srsp = shardHandler.takeCompletedOrError()) == null) continue;
                NamedList results = new NamedList();
                this.processResponse(results, srsp, Collections.emptySet());
                String r = (String)srsp.getSolrResponse().getResponse().get("STATUS");
                if (r.equals("running")) {
                    log.debug("The task is still RUNNING, continuing to wait.");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                if (r.equals("completed")) {
                    log.debug("The task is COMPLETED, returning");
                    return srsp.getSolrResponse().getResponse();
                }
                if (r.equals("failed")) {
                    log.debug("The task is FAILED, returning");
                    return srsp.getSolrResponse().getResponse();
                }
                if (r.equals("notfound")) {
                    log.debug("The task is notfound, retry");
                    if (counter++ < 5) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue block4;
                    }
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid status request for requestId: " + requestId + "" + srsp.getSolrResponse().getResponse().get("STATUS") + "retried " + counter + "times");
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid status request " + srsp.getSolrResponse().getResponse().get("STATUS"));
            } while (srsp != null);
        }
    }

    @Override
    public String getName() {
        return "Overseer Collection Message Handler";
    }

    @Override
    public String getTimerName(String operation) {
        return "collection_" + operation;
    }

    @Override
    public String getTaskKey(ZkNodeProps message) {
        return message.containsKey("collection") ? message.getStr("collection") : message.getStr("name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markExclusiveTask(String collectionName, ZkNodeProps message) {
        if (collectionName != null) {
            Set set = this.collectionWip;
            synchronized (set) {
                this.collectionWip.add(collectionName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unmarkExclusiveTask(String collectionName, String operation, ZkNodeProps message) {
        if (collectionName != null) {
            Set set = this.collectionWip;
            synchronized (set) {
                this.collectionWip.remove(collectionName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OverseerMessageHandler.ExclusiveMarking checkExclusiveMarking(String collectionName, ZkNodeProps message) {
        Set set = this.collectionWip;
        synchronized (set) {
            if (this.collectionWip.contains(collectionName)) {
                return OverseerMessageHandler.ExclusiveMarking.NONEXCLUSIVE;
            }
        }
        return OverseerMessageHandler.ExclusiveMarking.NOTDETERMINED;
    }

    static {
        String seed = System.getProperty("tests.seed");
        RANDOM = seed == null ? new Random() : new Random(seed.hashCode());
    }
}

