/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import org.apache.solr.cloud.DistributedMap;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.OverseerConfigSetMessageHandler;
import org.apache.solr.cloud.OverseerMessageHandler;
import org.apache.solr.cloud.OverseerNodePrioritizer;
import org.apache.solr.cloud.OverseerTaskProcessor;
import org.apache.solr.cloud.OverseerTaskQueue;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;

public class OverseerCollectionConfigSetProcessor
extends OverseerTaskProcessor {
    public OverseerCollectionConfigSetProcessor(ZkStateReader zkStateReader, String myId, ShardHandler shardHandler, String adminPath, Overseer.Stats stats, Overseer overseer, OverseerNodePrioritizer overseerNodePrioritizer) {
        this(zkStateReader, myId, shardHandler.getShardHandlerFactory(), adminPath, stats, overseer, overseerNodePrioritizer, Overseer.getCollectionQueue(zkStateReader.getZkClient(), stats), Overseer.getRunningMap(zkStateReader.getZkClient()), Overseer.getCompletedMap(zkStateReader.getZkClient()), Overseer.getFailureMap(zkStateReader.getZkClient()));
    }

    protected OverseerCollectionConfigSetProcessor(ZkStateReader zkStateReader, String myId, ShardHandlerFactory shardHandlerFactory, String adminPath, Overseer.Stats stats, Overseer overseer, OverseerNodePrioritizer overseerNodePrioritizer, OverseerTaskQueue workQueue, DistributedMap runningMap, DistributedMap completedMap, DistributedMap failureMap) {
        super(zkStateReader, myId, shardHandlerFactory, adminPath, stats, OverseerCollectionConfigSetProcessor.getOverseerMessageHandlerSelector(zkStateReader, myId, shardHandlerFactory, adminPath, stats, overseer, overseerNodePrioritizer), overseerNodePrioritizer, workQueue, runningMap, completedMap, failureMap);
    }

    private static OverseerTaskProcessor.OverseerMessageHandlerSelector getOverseerMessageHandlerSelector(ZkStateReader zkStateReader, String myId, ShardHandlerFactory shardHandlerFactory, String adminPath, Overseer.Stats stats, Overseer overseer, OverseerNodePrioritizer overseerNodePrioritizer) {
        final OverseerCollectionMessageHandler collMessageHandler = new OverseerCollectionMessageHandler(zkStateReader, myId, shardHandlerFactory, adminPath, stats, overseer, overseerNodePrioritizer);
        final OverseerConfigSetMessageHandler configMessageHandler = new OverseerConfigSetMessageHandler(zkStateReader);
        return new OverseerTaskProcessor.OverseerMessageHandlerSelector(){

            @Override
            public OverseerMessageHandler selectOverseerMessageHandler(ZkNodeProps message) {
                String operation = message.getStr("operation");
                if (operation != null && operation.startsWith("configsets:")) {
                    return configMessageHandler;
                }
                return collMessageHandler;
            }
        };
    }
}

