/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import com.spatial4j.core.shape.impl.RectangleImpl;
import org.apache.lucene.geo3d.Bounds;
import org.apache.lucene.geo3d.GeoArea;
import org.apache.lucene.geo3d.GeoAreaFactory;
import org.apache.lucene.geo3d.GeoPoint;
import org.apache.lucene.geo3d.GeoShape;
import org.apache.lucene.geo3d.LatLonBounds;
import org.apache.lucene.geo3d.PlanetModel;
import org.apache.lucene.geo3d.Vector;

public class Geo3dShape
implements Shape {
    protected static final double ROUNDOFF_ADJUSTMENT = 0.05;
    public final SpatialContext ctx;
    public final GeoShape shape;
    public final PlanetModel planetModel;
    private volatile Rectangle boundingBox = null;

    public Geo3dShape(GeoShape shape, SpatialContext ctx) {
        this(PlanetModel.SPHERE, shape, ctx);
    }

    public Geo3dShape(PlanetModel planetModel, GeoShape shape, SpatialContext ctx) {
        if (!ctx.isGeo()) {
            throw new IllegalArgumentException("SpatialContext.isGeo() must be true");
        }
        this.ctx = ctx;
        this.planetModel = planetModel;
        this.shape = shape;
    }

    @Override
    public SpatialContext getContext() {
        return this.ctx;
    }

    @Override
    public SpatialRelation relate(Shape other) {
        if (other instanceof Rectangle) {
            return this.relate((Rectangle)other);
        }
        if (other instanceof Point) {
            return this.relate((Point)other);
        }
        throw new RuntimeException("Unimplemented shape relationship determination: " + other.getClass());
    }

    protected SpatialRelation relate(Rectangle r) {
        GeoArea geoArea = GeoAreaFactory.makeGeoArea((PlanetModel)this.planetModel, (double)(r.getMaxY() * (Math.PI / 180)), (double)(r.getMinY() * (Math.PI / 180)), (double)(r.getMinX() * (Math.PI / 180)), (double)(r.getMaxX() * (Math.PI / 180)));
        int relationship = geoArea.getRelationship(this.shape);
        if (relationship == 1) {
            return SpatialRelation.WITHIN;
        }
        if (relationship == 0) {
            return SpatialRelation.CONTAINS;
        }
        if (relationship == 2) {
            return SpatialRelation.INTERSECTS;
        }
        if (relationship == 3) {
            return SpatialRelation.DISJOINT;
        }
        throw new RuntimeException("Unknown relationship returned: " + relationship);
    }

    protected SpatialRelation relate(Point p) {
        GeoPoint point = new GeoPoint(this.planetModel, p.getY() * (Math.PI / 180), p.getX() * (Math.PI / 180));
        if (this.shape.isWithin((Vector)point)) {
            return SpatialRelation.CONTAINS;
        }
        return SpatialRelation.DISJOINT;
    }

    @Override
    public Rectangle getBoundingBox() {
        Rectangle bbox = this.boundingBox;
        if (bbox == null) {
            double rightLon;
            double leftLon;
            LatLonBounds bounds = new LatLonBounds();
            this.shape.getBounds((Bounds)bounds);
            if (bounds.checkNoLongitudeBound()) {
                leftLon = -180.0;
                rightLon = 180.0;
            } else {
                leftLon = bounds.getLeftLongitude() * 57.29577951308232;
                rightLon = bounds.getRightLongitude() * 57.29577951308232;
            }
            double minLat = bounds.checkNoBottomLatitudeBound() ? -90.0 : bounds.getMinLatitude() * 57.29577951308232;
            double maxLat = bounds.checkNoTopLatitudeBound() ? 90.0 : bounds.getMaxLatitude() * 57.29577951308232;
            this.boundingBox = bbox = new RectangleImpl(leftLon, rightLon, minLat, maxLat, this.ctx).getBuffered(0.05, this.ctx);
        }
        return bbox;
    }

    @Override
    public boolean hasArea() {
        return true;
    }

    @Override
    public double getArea(SpatialContext ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Point getCenter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Shape getBuffered(double distance, SpatialContext ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        return "Geo3dShape{planetmodel=" + this.planetModel + ", shape=" + this.shape + '}';
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Geo3dShape)) {
            return false;
        }
        Geo3dShape tr = (Geo3dShape)other;
        return tr.ctx.equals(this.ctx) && tr.planetModel.equals((Object)this.planetModel) && tr.shape.equals(this.shape);
    }

    public int hashCode() {
        return this.planetModel.hashCode() + this.shape.hashCode();
    }
}

