/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RandomAccessWeight;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public class DocValuesNumbersQuery
extends Query {
    private final String field;
    private final Set<Long> numbers;

    public DocValuesNumbersQuery(String field, Set<Long> numbers) {
        this.field = Objects.requireNonNull(field);
        this.numbers = Objects.requireNonNull(numbers, "Set of numbers must not be null");
    }

    public DocValuesNumbersQuery(String field, Long ... numbers) {
        this(field, new HashSet<Long>(Arrays.asList(numbers)));
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        DocValuesNumbersQuery that = (DocValuesNumbersQuery)obj;
        if (!this.field.equals(that.field)) {
            return false;
        }
        return this.numbers.equals(that.numbers);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.field, this.numbers);
    }

    @Override
    public String toString(String defaultField) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.field).append(": [");
        for (Long number : this.numbers) {
            sb.append(number).append(", ");
        }
        if (this.numbers.size() > 0) {
            sb.setLength(sb.length() - 2);
        }
        return sb.append(']').append(ToStringUtils.boost(this.getBoost())).toString();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new RandomAccessWeight(this){

            @Override
            protected Bits getMatchingDocs(final LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = DocValues.getSortedNumeric(context.reader(), DocValuesNumbersQuery.this.field);
                return new Bits(){

                    @Override
                    public boolean get(int doc) {
                        values.setDocument(doc);
                        int count = values.count();
                        for (int i = 0; i < count; ++i) {
                            if (!DocValuesNumbersQuery.this.numbers.contains(values.valueAt(i))) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public int length() {
                        return context.reader().maxDoc();
                    }
                };
            }
        };
    }
}

