/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.payloads;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.queries.payloads.PayloadFunction;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.spans.FilterSpans;
import org.apache.lucene.search.spans.SpanCollector;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanScorer;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.BytesRef;

@Deprecated
public class PayloadTermQuery
extends SpanTermQuery {
    protected PayloadFunction function;
    private boolean includeSpanScore;

    public PayloadTermQuery(Term term, PayloadFunction function) {
        this(term, function, true);
    }

    public PayloadTermQuery(Term term, PayloadFunction function, boolean includeSpanScore) {
        super(term);
        this.function = Objects.requireNonNull(function);
        this.includeSpanScore = includeSpanScore;
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        TermContext context = TermContext.build(searcher.getTopReaderContext(), this.term);
        return new PayloadTermWeight(context, searcher, needsScores ? Collections.singletonMap(this.term, context) : null);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.function.hashCode();
        result = 31 * result + (this.includeSpanScore ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        PayloadTermQuery other = (PayloadTermQuery)obj;
        return this.includeSpanScore == other.includeSpanScore && this.function.equals(other.function);
    }

    private class PayloadTermWeight
    extends SpanTermQuery.SpanTermWeight {
        public PayloadTermWeight(TermContext context, IndexSearcher searcher, Map<Term, TermContext> terms) throws IOException {
            super(PayloadTermQuery.this, context, searcher, terms);
        }

        @Override
        public PayloadTermSpanScorer scorer(LeafReaderContext context) throws IOException {
            Spans spans = super.getSpans(context, SpanWeight.Postings.PAYLOADS);
            if (spans == null) {
                return null;
            }
            Similarity.SimScorer simScorer = this.getSimScorer(context);
            PayloadSpans payloadSpans = new PayloadSpans(spans, simScorer);
            return new PayloadTermSpanScorer(payloadSpans, this, simScorer);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            int newDoc;
            PayloadTermSpanScorer scorer = this.scorer(context);
            if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
                float freq = scorer.sloppyFreq();
                Explanation freqExplanation = Explanation.match(freq, "phraseFreq=" + freq, new Explanation[0]);
                Similarity.SimScorer docScorer = this.similarity.simScorer(this.simWeight, context);
                Explanation scoreExplanation = docScorer.explain(doc, freqExplanation);
                Explanation expl = Explanation.match(scoreExplanation.getValue(), "weight(" + this.getQuery() + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "], result of:", scoreExplanation);
                String field = ((SpanQuery)this.getQuery()).getField();
                Explanation payloadExpl = PayloadTermQuery.this.function.explain(doc, field, ((PayloadTermSpanScorer)scorer).spans.payloadsSeen, ((PayloadTermSpanScorer)scorer).spans.payloadScore);
                if (PayloadTermQuery.this.includeSpanScore) {
                    return Explanation.match(expl.getValue() * payloadExpl.getValue(), "btq, product of:", expl, payloadExpl);
                }
                return Explanation.match(payloadExpl.getValue(), "btq(includeSpanScore=false), result of:", payloadExpl);
            }
            return Explanation.noMatch("no matching term", new Explanation[0]);
        }

        protected class PayloadTermSpanScorer
        extends SpanScorer {
            private final PayloadSpans spans;

            public PayloadTermSpanScorer(PayloadSpans spans, SpanWeight weight, Similarity.SimScorer docScorer) throws IOException {
                super(weight, spans, docScorer);
                this.spans = spans;
            }

            @Override
            public float scoreCurrentDoc() throws IOException {
                return PayloadTermQuery.this.includeSpanScore ? this.getSpanScore() * this.getPayloadScore() : this.getPayloadScore();
            }

            protected float getSpanScore() throws IOException {
                return super.scoreCurrentDoc();
            }

            protected float getPayloadScore() {
                return PayloadTermQuery.this.function.docScore(this.docID(), PayloadTermQuery.this.term.field(), this.spans.payloadsSeen, this.spans.payloadScore);
            }
        }

        private class PayloadSpans
        extends FilterSpans {
            private final PayloadTermCollector payloadCollector;
            private final Similarity.SimScorer docScorer;
            float payloadScore;
            int payloadsSeen;

            protected PayloadSpans(Spans in, Similarity.SimScorer docScorer) {
                super(in);
                this.payloadCollector = new PayloadTermCollector();
                this.docScorer = docScorer;
            }

            @Override
            protected FilterSpans.AcceptStatus accept(Spans candidate) throws IOException {
                return FilterSpans.AcceptStatus.YES;
            }

            @Override
            protected void doStartCurrentDoc() throws IOException {
                this.payloadScore = 0.0f;
                this.payloadsSeen = 0;
            }

            @Override
            protected void doCurrentSpans() throws IOException {
                this.payloadCollector.reset();
                this.collect(this.payloadCollector);
                this.processPayload();
            }

            protected void processPayload() throws IOException {
                float payloadFactor = this.payloadCollector.payload == null ? 1.0f : this.docScorer.computePayloadFactor(this.docID(), this.startPosition(), this.endPosition(), this.payloadCollector.payload);
                this.payloadScore = PayloadTermQuery.this.function.currentScore(this.docID(), PayloadTermQuery.this.term.field(), this.startPosition(), this.endPosition(), this.payloadsSeen, this.payloadScore, payloadFactor);
                ++this.payloadsSeen;
            }
        }
    }

    private static class PayloadTermCollector
    implements SpanCollector {
        BytesRef payload;

        private PayloadTermCollector() {
        }

        @Override
        public void collectLeaf(PostingsEnum postings, int position, Term term) throws IOException {
            this.payload = postings.getPayload();
        }

        @Override
        public void reset() {
            this.payload = null;
        }
    }
}

