/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.server;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfiguration;
import org.apache.solr.client.solrj.SolrClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SolrServerRegistry {
    private static final Map<String, SolrClient> searchingServerRegistry = new HashMap<String, SolrClient>();
    private static final Map<String, SolrClient> indexingServerRegistry = new HashMap<String, SolrClient>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(@NotNull SolrServerConfiguration configuration, @NotNull SolrClient solrServer, @NotNull Strategy strategy) {
        switch (strategy) {
            case INDEXING: {
                Map<String, SolrClient> map = indexingServerRegistry;
                synchronized (map) {
                    indexingServerRegistry.put(configuration.toString(), solrServer);
                    break;
                }
            }
            case SEARCHING: {
                Map<String, SolrClient> map = searchingServerRegistry;
                synchronized (map) {
                    searchingServerRegistry.put(configuration.toString(), solrServer);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static SolrClient get(@NotNull SolrServerConfiguration configuration, @NotNull Strategy strategy) {
        switch (strategy) {
            case INDEXING: {
                Map<String, SolrClient> map = indexingServerRegistry;
                synchronized (map) {
                    return indexingServerRegistry.get(configuration.toString());
                }
            }
            case SEARCHING: {
                Map<String, SolrClient> map = searchingServerRegistry;
                synchronized (map) {
                    return searchingServerRegistry.get(configuration.toString());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(SolrServerConfiguration configuration, @NotNull Strategy strategy) {
        switch (strategy) {
            case INDEXING: {
                Map<String, SolrClient> map = indexingServerRegistry;
                synchronized (map) {
                    SolrClient removed = indexingServerRegistry.remove(configuration.toString());
                    try {
                        removed.shutdown();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    break;
                }
            }
            case SEARCHING: {
                Map<String, SolrClient> map = searchingServerRegistry;
                synchronized (map) {
                    SolrClient removed = searchingServerRegistry.remove(configuration.toString());
                    try {
                        removed.shutdown();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    break;
                }
            }
        }
    }

    public static enum Strategy {
        INDEXING,
        SEARCHING;

    }
}

