/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.query.SolrQueryIndex;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SolrQueryIndexProvider
implements QueryIndexProvider {
    private final SolrServerProvider solrServerProvider;
    private final OakSolrConfigurationProvider oakSolrConfigurationProvider;
    private final QueryIndex.NodeAggregator aggregator;

    public SolrQueryIndexProvider(@NotNull SolrServerProvider solrServerProvider, @NotNull OakSolrConfigurationProvider oakSolrConfigurationProvider, @Nullable QueryIndex.NodeAggregator nodeAggregator) {
        this.oakSolrConfigurationProvider = oakSolrConfigurationProvider;
        this.solrServerProvider = solrServerProvider;
        this.aggregator = nodeAggregator;
    }

    public SolrQueryIndexProvider(@NotNull SolrServerProvider solrServerProvider, @NotNull OakSolrConfigurationProvider oakSolrConfigurationProvider) {
        this(solrServerProvider, oakSolrConfigurationProvider, null);
    }

    @NotNull
    public List<? extends QueryIndex> getQueryIndexes(NodeState nodeState) {
        return ImmutableList.of((Object)new SolrQueryIndex(this.aggregator, this.oakSolrConfigurationProvider, this.solrServerProvider));
    }
}

