/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.osgi;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.OakSolrServer;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.solr.client.solrj.SolrClient;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Apache Jackrabbit Oak Solr server provider", immediate=true)
@References(value={@Reference(name="solrServerConfigurationProvider", referenceInterface=SolrServerConfigurationProvider.class, cardinality=ReferenceCardinality.MANDATORY_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindSolrServerConfigurationProvider", unbind="unbindSolrServerConfigurationProvider", updated="updatedSolrServerConfigurationProvider")})
@Service(value={SolrServerProvider.class})
public class SolrServerProviderService
implements SolrServerProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Property(options={@PropertyOption(name="none", value="None"), @PropertyOption(name="embedded", value="Embedded Solr"), @PropertyOption(name="remote", value="Remote Solr")}, value={"none"})
    private static final String SERVER_TYPE = "server.type";
    private final Map<String, SolrServerConfigurationProvider> solrServerConfigurationProviders = new HashMap<String, SolrServerConfigurationProvider>();
    private String serverType;
    private SolrClient cachedSolrServer;

    @Activate
    protected void activate(ComponentContext context) throws Exception {
        this.serverType = String.valueOf(context.getProperties().get(SERVER_TYPE));
    }

    @Deactivate
    protected void deactivate() throws Exception {
        this.solrServerConfigurationProviders.clear();
        this.close();
    }

    @Override
    public void close() throws IOException {
        if (this.cachedSolrServer != null) {
            try {
                this.cachedSolrServer.shutdown();
            }
            catch (Exception e) {
                this.log.error("could not correctly shutdown Solr {} server {}", (Object)this.serverType, (Object)this.cachedSolrServer);
            }
            finally {
                this.cachedSolrServer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindSolrServerConfigurationProvider(SolrServerConfigurationProvider solrServerConfigurationProvider, Map<String, Object> properties) {
        Map<String, SolrServerConfigurationProvider> map = this.solrServerConfigurationProviders;
        synchronized (map) {
            String name = String.valueOf(properties.get("name"));
            this.solrServerConfigurationProviders.put(name, solrServerConfigurationProvider);
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindSolrServerConfigurationProvider(SolrServerConfigurationProvider solrServerConfigurationProvider, Map<String, Object> properties) {
        Map<String, SolrServerConfigurationProvider> map = this.solrServerConfigurationProviders;
        synchronized (map) {
            String name = String.valueOf(properties.get("name"));
            this.solrServerConfigurationProviders.remove(name);
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatedSolrServerConfigurationProvider(SolrServerConfigurationProvider solrServerConfigurationProvider, Map<String, Object> properties) {
        Map<String, SolrServerConfigurationProvider> map = this.solrServerConfigurationProviders;
        synchronized (map) {
            String name = String.valueOf(properties.get("name"));
            this.solrServerConfigurationProviders.put(name, solrServerConfigurationProvider);
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public SolrClient getSolrServer() throws Exception {
        Map<String, SolrServerConfigurationProvider> map = this.solrServerConfigurationProviders;
        synchronized (map) {
            if (this.cachedSolrServer == null) {
                this.cachedSolrServer = this.getServer();
            }
            return this.cachedSolrServer;
        }
    }

    @Override
    @Nullable
    public SolrClient getIndexingSolrServer() throws Exception {
        return this.getSolrServer();
    }

    @Override
    @Nullable
    public SolrClient getSearchingSolrServer() throws Exception {
        return this.getSolrServer();
    }

    private SolrClient getServer() {
        SolrServerConfigurationProvider solrServerConfigurationProvider;
        OakSolrServer solrServer = null;
        if (this.serverType != null && !"none".equals(this.serverType) && (solrServerConfigurationProvider = this.solrServerConfigurationProviders.get(this.serverType)) != null) {
            try {
                solrServer = new OakSolrServer(solrServerConfigurationProvider);
                this.log.info("created new SolrServer {}", (Object)solrServer);
            }
            catch (Exception e) {
                this.log.error("could not get a SolrServerProvider of type {}", (Object)this.serverType, (Object)e);
            }
        }
        return solrServer;
    }
}

