/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.osgi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.ComponentContext;

@Component(label="Apache Jackrabbit Oak Solr indexing / search configuration", metatype=true, immediate=true)
@Service(value={OakSolrConfigurationProvider.class})
public class OakSolrConfigurationProviderService
implements OakSolrConfigurationProvider {
    @Property(value={"path_des"}, label="field for descendants search")
    private static final String PATH_DESCENDANTS_FIELD = "path.desc.field";
    @Property(value={"path_child"}, label="field for children search")
    private static final String PATH_CHILDREN_FIELD = "path.child.field";
    @Property(value={"path_anc"}, label="field for parent search")
    private static final String PATH_PARENT_FIELD = "path.parent.field";
    @Property(value={"path_exact"}, label="field for path search")
    private static final String PATH_EXACT_FIELD = "path.exact.field";
    @Property(value={"catch_all"}, label="catch all field")
    private static final String CATCH_ALL_FIELD = "catch.all.field";
    @Property(value={"path_collapsed"}, label="field for collapsing jcr:content paths")
    private static final String COLLAPSED_PATH_FIELD = "collapsed.path.field";
    @Property(value={"path_depth"}, label="field for path depth")
    private static final String PATH_DEPTH_FIELD = "path.depth.field";
    @Property(options={@PropertyOption(name="HARD", value="Hard commit"), @PropertyOption(name="SOFT", value="Soft commit"), @PropertyOption(name="AUTO", value="Auto commit")}, value={"SOFT"})
    private static final String COMMIT_POLICY = "commit.policy";
    @Property(intValue={10}, label="rows")
    private static final String ROWS = "rows";
    @Property(boolValue={false}, label="path restrictions")
    private static final String PATH_RESTRICTIONS = "path.restrictions";
    @Property(boolValue={false}, label="property restrictions")
    private static final String PROPERTY_RESTRICTIONS = "property.restrictions";
    @Property(boolValue={false}, label="primary types restrictions")
    private static final String PRIMARY_TYPES_RESTRICTIONS = "primarytypes.restrictions";
    @Property(value={"rep:members", "rep:authorizableId", "jcr:uuid", "rep:principalName", "rep:password"}, label="ignored properties", unbounded=PropertyUnbounded.ARRAY)
    private static final String IGNORED_PROPERTIES = "ignored.properties";
    @Property(value={}, label="used properties", unbounded=PropertyUnbounded.ARRAY)
    private static final String USED_PROPERTIES = "used.properties";
    @Property(value={""}, cardinality=13, description="each item should be in the form TypeString=FieldName (e.g. STRING=text_general)", label="mappings from Oak Types to Solr fields")
    private static final String TYPE_MAPPINGS = "type.mappings";
    @Property(value={""}, unbounded=PropertyUnbounded.ARRAY, description="each item should be in the form PropertyName=FieldName (e.g. jcr:title=text_en)", label="mappings from JCR property names to Solr fields")
    private static final String PROPERTY_MAPPINGS = "property.mappings";
    @Property(boolValue={false}, label="collapse jcr:content nodes")
    private static final String COLLAPSE_JCR_CONTENT_NODES = "collapse.jcrcontent.nodes";
    private String pathChildrenFieldName;
    private String pathParentFieldName;
    private String pathDescendantsFieldName;
    private String pathExactFieldName;
    private String collapsedPathField;
    private String catchAllField;
    private OakSolrConfiguration.CommitPolicy commitPolicy;
    private int rows;
    private boolean useForPathRestrictions;
    private boolean useForPropertyRestrictions;
    private boolean useForPrimaryTypes;
    private String[] ignoredProperties;
    private String[] usedProperties;
    private String[] typeMappings;
    private String[] propertyMappings;
    private boolean collapseJcrContentNodes;
    private String depthField;
    private OakSolrConfiguration oakSolrConfiguration;

    @Activate
    protected void activate(ComponentContext componentContext) throws Exception {
        this.pathChildrenFieldName = String.valueOf(componentContext.getProperties().get(PATH_CHILDREN_FIELD));
        this.pathParentFieldName = String.valueOf(componentContext.getProperties().get(PATH_PARENT_FIELD));
        this.pathExactFieldName = String.valueOf(componentContext.getProperties().get(PATH_EXACT_FIELD));
        this.collapsedPathField = String.valueOf(componentContext.getProperties().get(COLLAPSED_PATH_FIELD));
        this.pathDescendantsFieldName = String.valueOf(componentContext.getProperties().get(PATH_DESCENDANTS_FIELD));
        this.catchAllField = String.valueOf(componentContext.getProperties().get(CATCH_ALL_FIELD));
        this.depthField = String.valueOf(componentContext.getProperties().get(PATH_DEPTH_FIELD));
        this.rows = Integer.parseInt(String.valueOf(componentContext.getProperties().get(ROWS)));
        this.commitPolicy = OakSolrConfiguration.CommitPolicy.valueOf(String.valueOf(componentContext.getProperties().get(COMMIT_POLICY)));
        this.useForPathRestrictions = Boolean.valueOf(String.valueOf(componentContext.getProperties().get(PATH_RESTRICTIONS)));
        this.useForPropertyRestrictions = Boolean.valueOf(String.valueOf(componentContext.getProperties().get(PROPERTY_RESTRICTIONS)));
        this.useForPrimaryTypes = Boolean.valueOf(String.valueOf(componentContext.getProperties().get(PRIMARY_TYPES_RESTRICTIONS)));
        this.typeMappings = PropertiesUtil.toStringArray(componentContext.getProperties().get(TYPE_MAPPINGS));
        this.ignoredProperties = PropertiesUtil.toStringArray(componentContext.getProperties().get(IGNORED_PROPERTIES));
        this.usedProperties = PropertiesUtil.toStringArray(componentContext.getProperties().get(USED_PROPERTIES));
        this.propertyMappings = PropertiesUtil.toStringArray(componentContext.getProperties().get(PROPERTY_MAPPINGS));
        this.collapseJcrContentNodes = Boolean.valueOf(String.valueOf(componentContext.getProperties().get(COLLAPSE_JCR_CONTENT_NODES)));
    }

    @Deactivate
    protected void deactivate() {
        this.oakSolrConfiguration = null;
    }

    @Override
    @NotNull
    public OakSolrConfiguration getConfiguration() {
        if (this.oakSolrConfiguration == null) {
            this.oakSolrConfiguration = new OakSolrConfiguration(){

                @Override
                public String getFieldNameFor(Type<?> propertyType) {
                    for (String typeMapping : OakSolrConfigurationProviderService.this.typeMappings) {
                        Type type;
                        String[] mapping = typeMapping.split("=");
                        if (mapping.length != 2 || mapping[0] == null || mapping[1] == null || (type = Type.fromString((String)mapping[0])) == null || type.tag() != propertyType.tag()) continue;
                        return mapping[1];
                    }
                    return null;
                }

                @Override
                public String getFieldForPropertyRestriction(Filter.PropertyRestriction propertyRestriction) {
                    for (String propertyMapping : OakSolrConfigurationProviderService.this.propertyMappings) {
                        String[] mapping = propertyMapping.split("=");
                        if (mapping.length != 2 || mapping[0] == null || mapping[1] == null || !mapping[0].equals(propertyRestriction.propertyName)) continue;
                        return mapping[1];
                    }
                    return null;
                }

                @Override
                @NotNull
                public String getPathField() {
                    return OakSolrConfigurationProviderService.this.pathExactFieldName;
                }

                @Override
                @Nullable
                public String getFieldForPathRestriction(Filter.PathRestriction pathRestriction) {
                    String fieldName = null;
                    switch (pathRestriction) {
                        case ALL_CHILDREN: {
                            fieldName = OakSolrConfigurationProviderService.this.pathDescendantsFieldName;
                            break;
                        }
                        case DIRECT_CHILDREN: {
                            fieldName = OakSolrConfigurationProviderService.this.pathChildrenFieldName;
                            break;
                        }
                        case EXACT: {
                            fieldName = OakSolrConfigurationProviderService.this.pathExactFieldName;
                            break;
                        }
                        case PARENT: {
                            fieldName = OakSolrConfigurationProviderService.this.pathParentFieldName;
                            break;
                        }
                        case NO_RESTRICTION: {
                            break;
                        }
                    }
                    return fieldName;
                }

                @Override
                @NotNull
                public OakSolrConfiguration.CommitPolicy getCommitPolicy() {
                    return OakSolrConfigurationProviderService.this.commitPolicy;
                }

                @Override
                public String getCatchAllField() {
                    return OakSolrConfigurationProviderService.this.catchAllField;
                }

                @Override
                public int getRows() {
                    return OakSolrConfigurationProviderService.this.rows;
                }

                @Override
                public boolean useForPropertyRestrictions() {
                    return OakSolrConfigurationProviderService.this.useForPropertyRestrictions;
                }

                @Override
                public boolean useForPrimaryTypes() {
                    return OakSolrConfigurationProviderService.this.useForPrimaryTypes;
                }

                @Override
                public boolean useForPathRestrictions() {
                    return OakSolrConfigurationProviderService.this.useForPathRestrictions;
                }

                @Override
                @NotNull
                public Collection<String> getIgnoredProperties() {
                    if (OakSolrConfigurationProviderService.this.ignoredProperties != null && OakSolrConfigurationProviderService.this.ignoredProperties.length > 0 && OakSolrConfigurationProviderService.this.ignoredProperties[0].length() > 0) {
                        return Arrays.asList(OakSolrConfigurationProviderService.this.ignoredProperties);
                    }
                    return Collections.emptyList();
                }

                @Override
                @NotNull
                public Collection<String> getUsedProperties() {
                    if (OakSolrConfigurationProviderService.this.usedProperties != null && OakSolrConfigurationProviderService.this.usedProperties.length > 0 && OakSolrConfigurationProviderService.this.usedProperties[0].length() > 0) {
                        return Arrays.asList(OakSolrConfigurationProviderService.this.usedProperties);
                    }
                    return Collections.emptyList();
                }

                @Override
                public boolean collapseJcrContentNodes() {
                    return OakSolrConfigurationProviderService.this.collapseJcrContentNodes;
                }

                @Override
                @NotNull
                public String getCollapsedPathField() {
                    return OakSolrConfigurationProviderService.this.collapsedPathField;
                }

                @Override
                public String getPathDepthField() {
                    return OakSolrConfigurationProviderService.this.depthField;
                }
            };
        }
        return this.oakSolrConfiguration;
    }
}

