/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.configuration;

import java.util.Collection;
import java.util.Collections;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationDefaults;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultSolrConfiguration
implements OakSolrConfiguration {
    private static final Collection<String> ignoredProperties = OakSolrConfigurationDefaults.IGNORED_PROPERTIES;
    private static final Collection<String> usedProperties = Collections.emptyList();

    @Override
    public String getFieldNameFor(Type<?> propertyType) {
        return null;
    }

    @Override
    @NotNull
    public String getPathField() {
        return "path_exact";
    }

    @Override
    @Nullable
    public String getFieldForPathRestriction(Filter.PathRestriction pathRestriction) {
        String fieldName = null;
        switch (pathRestriction) {
            case ALL_CHILDREN: {
                fieldName = "path_des";
                break;
            }
            case DIRECT_CHILDREN: {
                fieldName = "path_child";
                break;
            }
            case EXACT: {
                fieldName = "path_exact";
                break;
            }
            case PARENT: {
                fieldName = "path_anc";
                break;
            }
            case NO_RESTRICTION: {
                break;
            }
        }
        return fieldName;
    }

    @Override
    public String getFieldForPropertyRestriction(Filter.PropertyRestriction propertyRestriction) {
        return null;
    }

    @Override
    @NotNull
    public OakSolrConfiguration.CommitPolicy getCommitPolicy() {
        return OakSolrConfiguration.CommitPolicy.SOFT;
    }

    @Override
    public String getCatchAllField() {
        return "catch_all";
    }

    @Override
    public int getRows() {
        return 10;
    }

    @Override
    public boolean useForPropertyRestrictions() {
        return false;
    }

    @Override
    public boolean useForPrimaryTypes() {
        return false;
    }

    @Override
    public boolean useForPathRestrictions() {
        return false;
    }

    @Override
    @NotNull
    public Collection<String> getIgnoredProperties() {
        return ignoredProperties;
    }

    @Override
    @NotNull
    public Collection<String> getUsedProperties() {
        return usedProperties;
    }

    @Override
    public boolean collapseJcrContentNodes() {
        return false;
    }

    @Override
    @NotNull
    public String getCollapsedPathField() {
        return "path_collapsed";
    }

    @Override
    public String getPathDepthField() {
        return "path_depth";
    }
}

