/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.SpatialContextFactory;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.io.ShapeReader;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.noggit.JSONParser;

public class GeoJSONReader
implements ShapeReader {
    protected static final String BUFFER = "buffer";
    protected static final String BUFFER_UNITS = "buffer_units";
    final SpatialContext ctx;

    public GeoJSONReader(SpatialContext ctx, SpatialContextFactory factory) {
        this.ctx = ctx;
    }

    @Override
    public String getFormatName() {
        return "GeoJSON";
    }

    @Override
    public final Shape read(Reader reader) throws IOException, ParseException {
        return this.readShape(new JSONParser(reader));
    }

    @Override
    public Shape read(Object value) throws IOException, ParseException, InvalidShapeException {
        String v = value.toString().trim();
        return this.read(new StringReader(v));
    }

    @Override
    public Shape readIfSupported(Object value) throws InvalidShapeException {
        String v = value.toString().trim();
        if (!v.startsWith("{") || !v.endsWith("}")) {
            return null;
        }
        try {
            return this.read(new StringReader(v));
        }
        catch (IOException ex) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    public List<?> readCoordinates(JSONParser parser) throws IOException, ParseException {
        int evt;
        assert (parser.lastEvent() == 9);
        ArrayDeque stack = new ArrayDeque();
        stack.push(new ArrayList());
        int depth = 1;
        block5: while (true) {
            evt = parser.nextEvent();
            switch (evt) {
                case 2: 
                case 3: 
                case 4: {
                    ((List)stack.peek()).add(parser.getDouble());
                    continue block5;
                }
                case 9: {
                    stack.push(new ArrayList());
                    ++depth;
                    continue block5;
                }
                case 10: {
                    List val = (List)stack.pop();
                    if (--depth == 0) {
                        return val;
                    }
                    ((List)stack.peek()).add(val);
                    continue block5;
                }
            }
            break;
        }
        throw new ParseException("Unexpected " + JSONParser.getEventString(evt), (int)parser.getPosition());
    }

    public double[] readCoordXY(JSONParser parser) throws IOException, ParseException {
        assert (parser.lastEvent() == 9);
        double[] coord = new double[3];
        int idx = 0;
        int evt = parser.nextEvent();
        while (evt != 11) {
            switch (evt) {
                case 2: 
                case 3: 
                case 4: {
                    coord[idx++] = parser.getDouble();
                    break;
                }
                case 10: {
                    return coord;
                }
                default: {
                    throw new ParseException("Unexpected " + JSONParser.getEventString(evt), (int)parser.getPosition());
                }
            }
            evt = parser.nextEvent();
        }
        return coord;
    }

    public List<double[]> readCoordListXY(JSONParser parser) throws IOException, ParseException {
        assert (parser.lastEvent() == 9);
        ArrayList<double[]> coords = new ArrayList<double[]>();
        int evt = parser.nextEvent();
        while (evt != 11) {
            switch (evt) {
                case 9: {
                    coords.add(this.readCoordXY(parser));
                    break;
                }
                case 10: {
                    return coords;
                }
                default: {
                    throw new ParseException("Unexpected " + JSONParser.getEventString(evt), (int)parser.getPosition());
                }
            }
            evt = parser.nextEvent();
        }
        return coords;
    }

    protected void readUntilEvent(JSONParser parser, int event) throws IOException {
        int evt = parser.lastEvent();
        while (evt != event && evt != 11) {
            evt = parser.nextEvent();
        }
        return;
    }

    protected Shape readPoint(JSONParser parser) throws IOException, ParseException {
        assert (parser.lastEvent() == 9);
        double[] coord = this.readCoordXY(parser);
        Point v = this.ctx.makePoint(coord[0], coord[1]);
        this.readUntilEvent(parser, 8);
        return v;
    }

    protected Shape readLineString(JSONParser parser) throws IOException, ParseException {
        assert (parser.lastEvent() == 9);
        List<double[]> coords = this.readCoordListXY(parser);
        ArrayList<Point> points = new ArrayList<Point>(coords.size());
        for (double[] coord : coords) {
            points.add(this.ctx.makePoint(coord[0], coord[1]));
        }
        double buf = this.readDistance(BUFFER, BUFFER_UNITS, parser);
        Shape out = buf == 0.0 ? this.ctx.makeLineString(points) : this.ctx.makeBufferedLineString(points, buf);
        this.readUntilEvent(parser, 8);
        return out;
    }

    protected Circle readCircle(JSONParser parser) throws IOException, ParseException {
        assert (parser.lastEvent() == 9);
        double[] coord = this.readCoordXY(parser);
        Point point = this.ctx.makePoint(coord[0], coord[1]);
        return this.ctx.makeCircle(point, this.readDistance("radius", "radius_units", parser));
    }

    protected double readDistance(String distProperty, String distUnitsProperty, JSONParser parser) throws IOException {
        double dist = 0.0;
        String key = null;
        int event = 8;
        int evt = parser.lastEvent();
        while (evt != event && evt != 11) {
            String units;
            evt = parser.nextEvent();
            if (parser.wasKey()) {
                key = parser.getString();
                continue;
            }
            if (evt == 3 || evt == 2) {
                if (!distProperty.equals(key)) continue;
                dist = parser.getDouble();
                continue;
            }
            if (evt != 1 || !distUnitsProperty.equals(key) || !"km".equals(units = parser.getString())) continue;
            dist = DistanceUtils.dist2Degrees(dist, 6371.0087714);
        }
        return dist;
    }

    protected Shape readPolygon(JSONParser parser) throws IOException, ParseException {
        assert (parser.lastEvent() == 9);
        double[] min = new double[]{Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE};
        double[] max = new double[]{Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE};
        double[] coords = new double[3];
        int idx = 0;
        int evt = parser.nextEvent();
        while (evt != 11) {
            switch (evt) {
                case 2: 
                case 3: 
                case 4: {
                    coords[idx] = parser.getDouble();
                    if (coords[idx] > max[idx]) {
                        max[idx] = coords[idx];
                    }
                    if (coords[idx] < min[idx]) {
                        min[idx] = coords[idx];
                    }
                    ++idx;
                    break;
                }
                case 10: {
                    idx = 0;
                    break;
                }
                case 8: {
                    return this.ctx.makeRectangle(min[0], max[0], min[1], max[1]);
                }
            }
            evt = parser.nextEvent();
        }
        throw new RuntimeException("Could not find polygon");
    }

    public Shape readShape(JSONParser parser) throws IOException, ParseException {
        String type = null;
        String key = null;
        int evt = parser.nextEvent();
        while (evt != 11) {
            switch (evt) {
                case 1: {
                    if (parser.wasKey()) {
                        key = parser.getString();
                        break;
                    }
                    if ("type".equals(key)) {
                        type = parser.getString();
                        break;
                    }
                    throw new ParseException("Unexpected String Value for key: " + key, (int)parser.getPosition());
                }
                case 9: {
                    if ("coordinates".equals(key)) {
                        Shape shape = null;
                        shape = "Point".equals(type) ? this.readPoint(parser) : ("LineString".equals(type) ? this.readLineString(parser) : ("Circle".equals(type) ? this.readCircle(parser) : this.makeShapeFromCoords(type, this.readCoordinates(parser))));
                        if (shape != null) {
                            this.readUntilEvent(parser, 8);
                            return shape;
                        }
                        throw new ParseException("Unable to make shape type: " + type, (int)parser.getPosition());
                    }
                    if ("geometries".equals(key)) {
                        ArrayList<Shape> shapes = new ArrayList<Shape>();
                        int sub = parser.nextEvent();
                        while (sub != 11) {
                            if (sub == 7) {
                                Shape s = this.readShape(parser);
                                if (s != null) {
                                    shapes.add(s);
                                }
                            } else if (sub == 8) break;
                            sub = parser.nextEvent();
                        }
                        if (shapes.isEmpty()) {
                            throw new ParseException("Shape Collection with now geometries!", (int)parser.getPosition());
                        }
                        return this.ctx.makeCollection(shapes);
                    }
                    throw new ParseException("Unknown type: " + type, (int)parser.getPosition());
                }
                case 10: {
                    break;
                }
                case 7: {
                    if (key == null) break;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    break;
                }
                default: {
                    throw new ParseException("Unexpected " + JSONParser.getEventString(evt), (int)parser.getPosition());
                }
            }
            evt = parser.nextEvent();
        }
        throw new RuntimeException("unable to parse shape");
    }

    protected Shape makeShapeFromCoords(String type, List coords) {
        throw new RuntimeException("Unsupported: " + type);
    }
}

