/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.shape.Point;
import org.apache.solr.common.SolrException;

public class SpatialUtils {
    private SpatialUtils() {
    }

    public static Point parsePoint(String str, SpatialContext ctx) throws InvalidShapeException {
        try {
            double y;
            double x;
            str = str.trim();
            int commaIdx = str.indexOf(44);
            if (commaIdx == -1) {
                int spaceIdx = str.indexOf(32);
                if (spaceIdx == -1) {
                    throw new InvalidShapeException("Point must be in 'lat, lon' or 'x y' format: " + str);
                }
                int middleEndIdx = SpatialUtils.findIndexNotSpace(str, spaceIdx + 1, 1);
                x = Double.parseDouble(str.substring(0, spaceIdx));
                y = Double.parseDouble(str.substring(middleEndIdx));
            } else {
                int middleStartIdx = SpatialUtils.findIndexNotSpace(str, commaIdx - 1, -1);
                int middleEndIdx = SpatialUtils.findIndexNotSpace(str, commaIdx + 1, 1);
                y = Double.parseDouble(str.substring(0, middleStartIdx + 1));
                x = Double.parseDouble(str.substring(middleEndIdx));
            }
            x = ctx.normX(x);
            y = ctx.normY(y);
            return ctx.makePoint(x, y);
        }
        catch (InvalidShapeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidShapeException(e.toString(), e);
        }
    }

    private static int findIndexNotSpace(String str, int startIdx, int inc) {
        int idx;
        assert (inc == 1 || inc == -1);
        for (idx = startIdx; idx >= 0 && idx < str.length() && str.charAt(idx) == ' '; idx += inc) {
        }
        return idx;
    }

    public static Point parsePointSolrException(String externalVal, SpatialContext ctx) throws SolrException {
        try {
            return SpatialUtils.parsePoint(externalVal, ctx);
        }
        catch (InvalidShapeException e) {
            String message = e.getMessage();
            if (!message.contains(externalVal)) {
                message = "Can't parse point '" + externalVal + "' because: " + message;
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message, (Throwable)e);
        }
    }
}

