/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.IndexWriter;
import org.apache.solr.cloud.RecoveryStrategy;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.update.SolrCoreState;
import org.apache.solr.update.SolrIndexWriter;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultSolrCoreState
extends SolrCoreState
implements RecoveryStrategy.RecoveryListener {
    public static Logger log = LoggerFactory.getLogger(DefaultSolrCoreState.class);
    private final boolean SKIP_AUTO_RECOVERY = Boolean.getBoolean("solrcloud.skip.autorecovery");
    private final Object recoveryLock = new Object();
    private final Object writerPauseLock = new Object();
    private SolrIndexWriter indexWriter = null;
    private DirectoryFactory directoryFactory;
    private volatile boolean recoveryRunning;
    private RecoveryStrategy recoveryStrat;
    private RefCounted<IndexWriter> refCntWriter;
    private boolean pauseWriter;
    private boolean writerFree = true;
    protected final ReentrantLock commitLock = new ReentrantLock();

    public DefaultSolrCoreState(DirectoryFactory directoryFactory) {
        this.directoryFactory = directoryFactory;
    }

    private void closeIndexWriter(SolrCoreState.IndexWriterCloser closer) {
        try {
            log.info("SolrCoreState ref count has reached 0 - closing IndexWriter");
            if (closer != null) {
                log.info("closing IndexWriter with IndexWriterCloser");
                closer.closeWriter(this.indexWriter);
            } else if (this.indexWriter != null) {
                log.info("closing IndexWriter...");
                this.indexWriter.close();
            }
            this.indexWriter = null;
        }
        catch (Exception e) {
            log.error("Error during shutdown of writer.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RefCounted<IndexWriter> getIndexWriter(SolrCore core) throws IOException {
        Object object = this.writerPauseLock;
        synchronized (object) {
            if (this.closed) {
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "SolrCoreState already closed");
            }
            while (this.pauseWriter) {
                try {
                    this.writerPauseLock.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.closed) continue;
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Already closed");
            }
            if (core == null) {
                this.initRefCntWriter();
                if (this.refCntWriter == null) {
                    return null;
                }
                this.writerFree = false;
                this.writerPauseLock.notifyAll();
                if (this.refCntWriter != null) {
                    this.refCntWriter.incref();
                }
                return this.refCntWriter;
            }
            if (this.indexWriter == null) {
                this.indexWriter = this.createMainIndexWriter(core, "DirectUpdateHandler2");
            }
            this.initRefCntWriter();
            this.writerFree = false;
            this.writerPauseLock.notifyAll();
            this.refCntWriter.incref();
            return this.refCntWriter;
        }
    }

    private void initRefCntWriter() {
        if (this.refCntWriter == null && this.indexWriter != null) {
            this.refCntWriter = new RefCounted<IndexWriter>((IndexWriter)this.indexWriter){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() {
                    Object object = DefaultSolrCoreState.this.writerPauseLock;
                    synchronized (object) {
                        DefaultSolrCoreState.this.writerFree = true;
                        DefaultSolrCoreState.this.writerPauseLock.notifyAll();
                    }
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void newIndexWriter(SolrCore core, boolean rollback) throws IOException {
        log.info("Creating new IndexWriter...");
        String coreName = core.getName();
        Object object = this.writerPauseLock;
        synchronized (object) {
            if (this.closed) {
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Already closed");
            }
            this.pauseWriter = true;
            log.info("Waiting until IndexWriter is unused... core=" + coreName);
            while (!this.writerFree) {
                try {
                    this.writerPauseLock.wait(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!this.closed) continue;
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "SolrCoreState already closed");
            }
            try {
                if (this.indexWriter != null) {
                    if (!rollback) {
                        try {
                            log.info("Closing old IndexWriter... core=" + coreName);
                            this.indexWriter.close();
                        }
                        catch (Exception e) {
                            SolrException.log(log, "Error closing old IndexWriter. core=" + coreName, e);
                        }
                    } else {
                        try {
                            log.info("Rollback old IndexWriter... core=" + coreName);
                            this.indexWriter.rollback();
                        }
                        catch (Exception e) {
                            SolrException.log(log, "Error rolling back old IndexWriter. core=" + coreName, e);
                        }
                    }
                }
                this.indexWriter = this.createMainIndexWriter(core, "DirectUpdateHandler2");
                log.info("New IndexWriter is ready to be used.");
                this.refCntWriter = null;
            }
            finally {
                this.pauseWriter = false;
                this.writerPauseLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void closeIndexWriter(SolrCore core, boolean rollback) throws IOException {
        log.info("Closing IndexWriter...");
        String coreName = core.getName();
        Object object = this.writerPauseLock;
        synchronized (object) {
            if (this.closed) {
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Already closed");
            }
            this.pauseWriter = true;
            log.info("Waiting until IndexWriter is unused... core=" + coreName);
            while (!this.writerFree) {
                try {
                    this.writerPauseLock.wait(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!this.closed) continue;
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "SolrCoreState already closed");
            }
            if (this.indexWriter != null) {
                if (!rollback) {
                    try {
                        log.info("Closing old IndexWriter... core=" + coreName);
                        this.indexWriter.close();
                    }
                    catch (Exception e) {
                        SolrException.log(log, "Error closing old IndexWriter. core=" + coreName, e);
                    }
                } else {
                    try {
                        log.info("Rollback old IndexWriter... core=" + coreName);
                        this.indexWriter.rollback();
                    }
                    catch (Exception e) {
                        SolrException.log(log, "Error rolling back old IndexWriter. core=" + coreName, e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void openIndexWriter(SolrCore core) throws IOException {
        log.info("Creating new IndexWriter...");
        Object object = this.writerPauseLock;
        synchronized (object) {
            if (this.closed) {
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Already closed");
            }
            try {
                this.indexWriter = this.createMainIndexWriter(core, "DirectUpdateHandler2");
                log.info("New IndexWriter is ready to be used.");
                this.refCntWriter = null;
            }
            finally {
                this.pauseWriter = false;
                this.writerPauseLock.notifyAll();
            }
        }
    }

    @Override
    public synchronized void rollbackIndexWriter(SolrCore core) throws IOException {
        this.newIndexWriter(core, true);
    }

    protected SolrIndexWriter createMainIndexWriter(SolrCore core, String name) throws IOException {
        return SolrIndexWriter.create(name, core.getNewIndexDir(), core.getDirectoryFactory(), false, core.getLatestSchema(), core.getSolrConfig().indexConfig, core.getDeletionPolicy(), core.getCodec());
    }

    @Override
    public DirectoryFactory getDirectoryFactory() {
        return this.directoryFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRecovery(CoreContainer cc, CoreDescriptor cd) {
        if (this.SKIP_AUTO_RECOVERY) {
            log.warn("Skipping recovery according to sys prop solrcloud.skip.autorecovery");
            return;
        }
        if (cc.isShutDown()) {
            log.warn("Skipping recovery because Solr is shutdown");
            return;
        }
        Object object = this.recoveryLock;
        synchronized (object) {
            if (cc.isShutDown()) {
                log.warn("Skipping recovery because Solr is shutdown");
                return;
            }
            log.info("Running recovery - first canceling any ongoing recovery");
            this.cancelRecovery();
            while (this.recoveryRunning) {
                try {
                    this.recoveryLock.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (cc.isShutDown()) {
                    log.warn("Skipping recovery because Solr is shutdown");
                    return;
                }
                if (!this.closed) continue;
                return;
            }
            boolean recoveringAfterStartup = this.recoveryStrat == null;
            this.recoveryStrat = new RecoveryStrategy(cc, cd, this);
            this.recoveryStrat.setRecoveringAfterStartup(recoveringAfterStartup);
            this.recoveryStrat.start();
            this.recoveryRunning = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelRecovery() {
        Object object = this.recoveryLock;
        synchronized (object) {
            if (this.recoveryStrat != null && this.recoveryRunning) {
                this.recoveryStrat.close();
                while (true) {
                    try {
                        this.recoveryStrat.join();
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
                this.recoveryRunning = false;
                this.recoveryLock.notifyAll();
            }
        }
    }

    @Override
    public void recovered() {
        this.recoveryRunning = false;
    }

    @Override
    public void failed() {
        this.recoveryRunning = false;
    }

    @Override
    public synchronized void close(SolrCoreState.IndexWriterCloser closer) {
        this.closed = true;
        this.cancelRecovery();
        this.closeIndexWriter(closer);
    }

    @Override
    public Lock getCommitLock() {
        return this.commitLock;
    }
}

