/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.AbstractExecutionAwareRequest;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.util.EntityUtils;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.ConfigSolr;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.ContentStreamHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.BinaryQueryResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.servlet.ResponseUtils;
import org.apache.solr.servlet.SolrRequestParsers;
import org.apache.solr.servlet.cache.HttpCacheHeaderUtil;
import org.apache.solr.servlet.cache.Method;
import org.apache.solr.util.FastWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrDispatchFilter
implements Filter {
    private static final String CONNECTION_HEADER = "Connection";
    private static final String TRANSFER_ENCODING_HEADER = "Transfer-Encoding";
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    final Logger log;
    protected volatile CoreContainer cores;
    protected String pathPrefix = null;
    protected String abortErrorMessage = null;
    protected final HttpClient httpClient = HttpClientUtil.createClient(new ModifiableSolrParams());
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public SolrDispatchFilter() {
        try {
            this.log = LoggerFactory.getLogger(SolrDispatchFilter.class);
        }
        catch (NoClassDefFoundError e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not find necessary SLF4j logging jars. If using Jetty, the SLF4j logging jars need to go in the jetty lib/ext directory. For other containers, the corresponding directory should be used. For more information, see: http://wiki.apache.org/solr/SolrLogging", (Throwable)e);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        block2: {
            this.log.info("SolrDispatchFilter.init()");
            try {
                this.pathPrefix = config.getInitParameter("path-prefix");
                this.cores = this.createCoreContainer();
                this.log.info("user.dir=" + System.getProperty("user.dir"));
            }
            catch (Throwable t) {
                this.log.error("Could not start Solr. Check solr/home property and the logs");
                SolrCore.log(t);
                if (!(t instanceof Error)) break block2;
                throw (Error)t;
            }
        }
        this.log.info("SolrDispatchFilter.init() done");
    }

    private ConfigSolr loadConfigSolr(SolrResourceLoader loader) {
        String solrxmlLocation = System.getProperty("solr.solrxml.location", "solrhome");
        if (solrxmlLocation == null || "solrhome".equalsIgnoreCase(solrxmlLocation)) {
            return ConfigSolr.fromSolrHome(loader, loader.getInstanceDir());
        }
        if ("zookeeper".equalsIgnoreCase(solrxmlLocation)) {
            String zkHost = System.getProperty("zkHost");
            this.log.info("Trying to read solr.xml from " + zkHost);
            if (StringUtils.isEmpty(zkHost)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load solr.xml from zookeeper: zkHost system property not set");
            }
            SolrZkClient zkClient = new SolrZkClient(zkHost, 30000);
            try {
                if (!zkClient.exists("/solr.xml", true).booleanValue()) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load solr.xml from zookeeper: node not found");
                }
                byte[] data = zkClient.getData("/solr.xml", null, null, true);
                ConfigSolr configSolr = ConfigSolr.fromInputStream(loader, new ByteArrayInputStream(data));
                return configSolr;
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load solr.xml from zookeeper", (Throwable)e);
            }
            finally {
                zkClient.close();
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Bad solr.solrxml.location set: " + solrxmlLocation + " - should be 'solrhome' or 'zookeeper'");
    }

    protected CoreContainer createCoreContainer() {
        SolrResourceLoader loader = new SolrResourceLoader(SolrResourceLoader.locateSolrHome());
        ConfigSolr config = this.loadConfigSolr(loader);
        CoreContainer cores = new CoreContainer(loader, config);
        cores.load();
        return cores;
    }

    public CoreContainer getCores() {
        return this.cores;
    }

    public void destroy() {
        if (this.cores != null) {
            this.cores.shutdown();
            this.cores = null;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter(request, response, chain, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain, boolean retry) throws IOException, ServletException {
        block159: {
            block145: {
                block150: {
                    block146: {
                        block147: {
                            block139: {
                                block140: {
                                    block136: {
                                        block133: {
                                            block130: {
                                                if (this.abortErrorMessage != null) {
                                                    ((HttpServletResponse)response).sendError(500, this.abortErrorMessage);
                                                    return;
                                                }
                                                if (this.cores == null) {
                                                    ((HttpServletResponse)response).sendError(503, "Server is shutting down or failed to initialize");
                                                    return;
                                                }
                                                cores = this.cores;
                                                core = null;
                                                solrReq = null;
                                                aliases = null;
                                                if (!(request instanceof HttpServletRequest)) break block159;
                                                req = (HttpServletRequest)request;
                                                resp = (HttpServletResponse)response;
                                                handler /* !! */  = null;
                                                corename = "";
                                                origCorename = null;
                                                req.setAttribute("org.apache.solr.CoreContainer", (Object)cores);
                                                path = req.getServletPath();
                                                if (req.getPathInfo() != null) {
                                                    path = path + req.getPathInfo();
                                                }
                                                if (this.pathPrefix != null && path.startsWith(this.pathPrefix)) {
                                                    path = path.substring(this.pathPrefix.length());
                                                }
                                                if ((alternate = cores.getManagementPath()) != null && path.startsWith(alternate)) {
                                                    path = path.substring(0, alternate.length());
                                                }
                                                if ((idx = path.indexOf(58)) > 0) {
                                                    path = path.substring(0, idx);
                                                }
                                                if (!path.equals(cores.getAdminPath())) break block130;
                                                handler /* !! */  = cores.getMultiCoreHandler();
                                                solrReq = SolrRequestParsers.DEFAULT.parse(null, path, req);
                                                this.handleAdminRequest(req, response, handler /* !! */ , solrReq);
                                                try {
                                                    if (solrReq != null) {
                                                        this.log.debug("Closing out SolrRequest: {}", (Object)solrReq);
                                                        solrReq.close();
                                                    }
                                                }
                                                finally {
                                                    try {
                                                        if (core != null) {
                                                            core.close();
                                                        }
                                                    }
                                                    finally {
                                                        SolrRequestInfo.clearRequestInfo();
                                                    }
                                                }
                                                return;
                                            }
                                            usingAliases = false;
                                            collectionsList = null;
                                            if (!path.equals("/admin/collections")) break block133;
                                            handler /* !! */  = cores.getCollectionsHandler();
                                            solrReq = SolrRequestParsers.DEFAULT.parse(null, path, req);
                                            this.handleAdminRequest(req, response, handler /* !! */ , solrReq);
                                            try {
                                                if (solrReq != null) {
                                                    this.log.debug("Closing out SolrRequest: {}", (Object)solrReq);
                                                    solrReq.close();
                                                }
                                            }
                                            finally {
                                                try {
                                                    if (core != null) {
                                                        core.close();
                                                    }
                                                }
                                                finally {
                                                    SolrRequestInfo.clearRequestInfo();
                                                }
                                            }
                                            return;
                                        }
                                        if (!path.startsWith("/admin/info")) break block136;
                                        handler /* !! */  = cores.getInfoHandler();
                                        solrReq = SolrRequestParsers.DEFAULT.parse(null, path, req);
                                        this.handleAdminRequest(req, response, handler /* !! */ , solrReq);
                                        try {
                                            if (solrReq != null) {
                                                this.log.debug("Closing out SolrRequest: {}", (Object)solrReq);
                                                solrReq.close();
                                            }
                                        }
                                        finally {
                                            try {
                                                if (core != null) {
                                                    core.close();
                                                }
                                            }
                                            finally {
                                                SolrRequestInfo.clearRequestInfo();
                                            }
                                        }
                                        return;
                                    }
                                    idx = path.indexOf("/", 1);
                                    if (idx > 1) {
                                        corename = path.substring(1, idx);
                                        if (cores.isZooKeeperAware()) {
                                            origCorename = corename;
                                            reader = cores.getZkController().getZkStateReader();
                                            aliases = reader.getAliases();
                                            if (aliases != null && aliases.collectionAliasSize() > 0) {
                                                usingAliases = true;
                                                alias = aliases.getCollectionAlias(corename);
                                                if (alias != null) {
                                                    collectionsList = StrUtils.splitSmart(alias, ",", true);
                                                    corename = collectionsList.get(0);
                                                }
                                            }
                                        }
                                        if ((core = cores.getCore(corename)) != null) {
                                            path = path.substring(idx);
                                        }
                                    }
                                    if (core == null && !cores.isZooKeeperAware()) {
                                        core = cores.getCore("");
                                    }
                                    if (core != null || !cores.isZooKeeperAware()) ** GOTO lbl170
                                    core = this.getCoreByCollection(cores, corename, path);
                                    if (core != null) {
                                        path = path.substring(idx);
                                    }
                                    if (core != null || idx <= 0) break block139;
                                    coreUrl = this.getRemotCoreUrl(cores, corename, origCorename);
                                    queryParams = SolrRequestParsers.parseQueryString(req.getQueryString());
                                    if (coreUrl == null || queryParams.get("update.distrib") != null) break block140;
                                    path = path.substring(idx);
                                    this.remoteQuery(coreUrl + path, req, solrReq, resp);
                                    try {
                                        if (solrReq != null) {
                                            this.log.debug("Closing out SolrRequest: {}", (Object)solrReq);
                                            solrReq.close();
                                        }
                                    }
                                    finally {
                                        try {
                                            if (core != null) {
                                                core.close();
                                            }
                                        }
                                        finally {
                                            SolrRequestInfo.clearRequestInfo();
                                        }
                                    }
                                    return;
                                }
                                if (retry) break block139;
                                reader = cores.getZkController().getZkStateReader();
                                reader.updateAliases();
                                this.doFilter(request, response, chain, true);
                                try {
                                    if (solrReq != null) {
                                        this.log.debug("Closing out SolrRequest: {}", (Object)solrReq);
                                        solrReq.close();
                                    }
                                }
                                finally {
                                    try {
                                        if (core != null) {
                                            core.close();
                                        }
                                    }
                                    finally {
                                        SolrRequestInfo.clearRequestInfo();
                                    }
                                }
                                return;
                            }
                            if (core == null) {
                                core = cores.getCore("");
                            }
lbl170:
                            // 4 sources

                            if (core == null) break block145;
                            config = core.getSolrConfig();
                            parser = config.getRequestParsers();
                            if (!path.startsWith("/schema")) break block146;
                            solrReq = parser.parse(core, path, req);
                            SolrRequestInfo.setRequestInfo(new SolrRequestInfo(solrReq, new SolrQueryResponse()));
                            if (path.equals(req.getServletPath())) {
                                chain.doFilter(request, response);
                                break block147;
                            }
                            req.getRequestDispatcher(path).forward(request, response);
                        }
                        try {
                            if (solrReq != null) {
                                this.log.debug("Closing out SolrRequest: {}", (Object)solrReq);
                                solrReq.close();
                            }
                        }
                        finally {
                            try {
                                if (core != null) {
                                    core.close();
                                }
                            }
                            finally {
                                SolrRequestInfo.clearRequestInfo();
                            }
                        }
                        return;
                    }
                    if (handler /* !! */  == null && path.length() > 1 && (handler /* !! */  = core.getRequestHandler(path)) == null && parser.isHandleSelect() && ("/select".equals(path) || "/select/".equals(path))) {
                        solrReq = parser.parse(core, path, req);
                        qt = solrReq.getParams().get("qt");
                        handler /* !! */  = core.getRequestHandler(qt);
                        if (handler /* !! */  == null) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown handler: " + qt);
                        }
                        if (qt != null && qt.startsWith("/") && handler /* !! */  instanceof ContentStreamHandlerBase) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Request Handler ('qt').  Do not use /select to access: " + qt);
                        }
                    }
                    if (handler /* !! */  == null) break block145;
                    if (solrReq == null) {
                        solrReq = parser.parse(core, path, req);
                    }
                    if (usingAliases) {
                        this.processAliases(solrReq, aliases, collectionsList);
                    }
                    reqMethod = Method.getMethod(req.getMethod());
                    HttpCacheHeaderUtil.setCacheControlHeader(config, resp, reqMethod);
                    if (!config.getHttpCachingConfig().isNever304() && HttpCacheHeaderUtil.doCacheHeaderValidation(solrReq, req, reqMethod, resp)) break block150;
                    solrRsp = new SolrQueryResponse();
                    SolrRequestInfo.setRequestInfo(new SolrRequestInfo(solrReq, solrRsp));
                    this.execute(req, handler /* !! */ , solrReq, solrRsp);
                    HttpCacheHeaderUtil.checkHttpCachingVeto(solrRsp, resp, reqMethod);
                    responseWriter = core.getQueryResponseWriter(solrReq);
                    this.writeResponse(solrRsp, response, responseWriter, solrReq, reqMethod);
                }
                try {
                    if (solrReq != null) {
                        this.log.debug("Closing out SolrRequest: {}", (Object)solrReq);
                        solrReq.close();
                    }
                }
                finally {
                    try {
                        if (core != null) {
                            core.close();
                        }
                    }
                    finally {
                        SolrRequestInfo.clearRequestInfo();
                    }
                }
                return;
            }
            this.log.debug("no handler or core retrieved for " + path + ", follow through...");
            try {
                if (solrReq == null) ** GOTO lbl299
                this.log.debug("Closing out SolrRequest: {}", (Object)solrReq);
                solrReq.close();
            }
            finally {
                try {
                    if (core != null) {
                        core.close();
                    }
                }
                finally {
                    SolrRequestInfo.clearRequestInfo();
                }
            }
            catch (Throwable ex) {
                block154: {
                    try {
                        this.sendError(core, solrReq, request, (HttpServletResponse)response, ex);
                        if (!(ex instanceof Error)) break block154;
                        throw (Error)ex;
                    }
                    catch (Throwable var44_53) {
                        try {
                            if (solrReq != null) {
                                this.log.debug("Closing out SolrRequest: {}", solrReq);
                                solrReq.close();
                            }
                        }
                        finally {
                            try {
                                if (core != null) {
                                    core.close();
                                }
                            }
                            finally {
                                SolrRequestInfo.clearRequestInfo();
                            }
                        }
                        throw var44_53;
                    }
                }
                try {
                    if (solrReq != null) {
                        this.log.debug("Closing out SolrRequest: {}", (Object)solrReq);
                        solrReq.close();
                    }
                }
                finally {
                    try {
                        if (core != null) {
                            core.close();
                        }
                    }
                    finally {
                        SolrRequestInfo.clearRequestInfo();
                    }
                }
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private void processAliases(SolrQueryRequest solrReq, Aliases aliases, List<String> collectionsList) {
        String collection = solrReq.getParams().get("collection");
        if (collection != null) {
            collectionsList = StrUtils.splitSmart(collection, ",", true);
        }
        if (collectionsList != null) {
            HashSet<String> newCollectionsList = new HashSet<String>(collectionsList.size());
            for (String col : collectionsList) {
                String al = aliases.getCollectionAlias(col);
                if (al != null) {
                    List<String> aliasList = StrUtils.splitSmart(al, ",", true);
                    newCollectionsList.addAll(aliasList);
                    continue;
                }
                newCollectionsList.add(col);
            }
            if (newCollectionsList.size() > 0) {
                StringBuilder collectionString = new StringBuilder();
                Iterator it = newCollectionsList.iterator();
                int sz = newCollectionsList.size();
                for (int i = 0; i < sz; ++i) {
                    collectionString.append((String)it.next());
                    if (i >= newCollectionsList.size() - 1) continue;
                    collectionString.append(",");
                }
                ModifiableSolrParams params = new ModifiableSolrParams(solrReq.getParams());
                params.set("collection", collectionString.toString());
                solrReq.setParams(params);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void remoteQuery(String coreUrl, HttpServletRequest req, SolrQueryRequest solrReq, HttpServletResponse resp) throws IOException {
        AbstractExecutionAwareRequest method = null;
        HttpEntity httpEntity = null;
        boolean success = false;
        try {
            boolean isPostOrPutRequest;
            String urlstr = coreUrl;
            String queryString = req.getQueryString();
            urlstr = urlstr + (queryString == null ? "" : "?" + queryString);
            URL url = new URL(urlstr);
            boolean bl = isPostOrPutRequest = "POST".equals(req.getMethod()) || "PUT".equals(req.getMethod());
            if ("GET".equals(req.getMethod())) {
                method = new HttpGet(urlstr);
            } else if ("HEAD".equals(req.getMethod())) {
                method = new HttpHead(urlstr);
            } else {
                if (!isPostOrPutRequest) throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected method type: " + req.getMethod());
                HttpEntityEnclosingRequestBase entityRequest = "POST".equals(req.getMethod()) ? new HttpPost(urlstr) : new HttpPut(urlstr);
                InputStreamEntity entity = new InputStreamEntity((InputStream)req.getInputStream(), req.getContentLength());
                entityRequest.setEntity(entity);
                method = entityRequest;
            }
            Enumeration e = req.getHeaderNames();
            while (e.hasMoreElements()) {
                String headerName = (String)e.nextElement();
                method.addHeader(headerName, req.getHeader(headerName));
            }
            if (method instanceof HttpEntityEnclosingRequest) {
                method.removeHeaders(TRANSFER_ENCODING_HEADER);
                method.removeHeaders(CONTENT_LENGTH_HEADER);
            }
            HttpResponse response = this.httpClient.execute((HttpUriRequest)((Object)method));
            int httpStatus = response.getStatusLine().getStatusCode();
            httpEntity = response.getEntity();
            resp.setStatus(httpStatus);
            HeaderIterator responseHeaders = response.headerIterator();
            while (responseHeaders.hasNext()) {
                Header header = responseHeaders.nextHeader();
                if (header == null || header.getName().equals(TRANSFER_ENCODING_HEADER) || header.getName().equals(CONNECTION_HEADER)) continue;
                resp.addHeader(header.getName(), header.getValue());
            }
            if (httpEntity != null) {
                if (httpEntity.getContentEncoding() != null) {
                    resp.setCharacterEncoding(httpEntity.getContentEncoding().getValue());
                }
                if (httpEntity.getContentType() != null) {
                    resp.setContentType(httpEntity.getContentType().getValue());
                }
                InputStream is = httpEntity.getContent();
                ServletOutputStream os = resp.getOutputStream();
                try {
                    IOUtils.copyLarge((InputStream)is, (OutputStream)os);
                    os.flush();
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)os);
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
            success = true;
            EntityUtils.consumeQuietly(httpEntity);
            if (method == null || success) return;
        }
        catch (IOException e) {
            this.sendError(null, solrReq, (ServletRequest)req, resp, new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error trying to proxy request for url: " + coreUrl, (Throwable)e));
            return;
        }
        finally {
            EntityUtils.consumeQuietly(httpEntity);
            if (method != null && !success) {
                method.abort();
            }
        }
        method.abort();
        return;
    }

    private String getRemotCoreUrl(CoreContainer cores, String collectionName, String origCorename) {
        ClusterState clusterState = cores.getZkController().getClusterState();
        Collection<Slice> slices = clusterState.getActiveSlices(collectionName);
        boolean byCoreName = false;
        if (slices == null) {
            slices = new ArrayList<Slice>();
            byCoreName = true;
            if ((slices = this.getSlicesForCollections(clusterState, slices, true)) == null || slices.size() == 0) {
                slices = this.getSlicesForCollections(clusterState, slices, false);
            }
        }
        if (slices == null || slices.size() == 0) {
            return null;
        }
        String coreUrl = this.getCoreUrl(cores, collectionName, origCorename, clusterState, slices, byCoreName, true);
        if (coreUrl == null) {
            coreUrl = this.getCoreUrl(cores, collectionName, origCorename, clusterState, slices, byCoreName, false);
        }
        return coreUrl;
    }

    private String getCoreUrl(CoreContainer cores, String collectionName, String origCorename, ClusterState clusterState, Collection<Slice> slices, boolean byCoreName, boolean activeReplicas) {
        Set<String> liveNodes = clusterState.getLiveNodes();
        for (Slice slice : slices) {
            Map<String, Replica> sliceShards = slice.getReplicasMap();
            for (Replica nodeProps : sliceShards.values()) {
                String coreUrl;
                ZkCoreNodeProps coreNodeProps = new ZkCoreNodeProps(nodeProps);
                if (activeReplicas && (!liveNodes.contains(coreNodeProps.getNodeName()) || !coreNodeProps.getState().equals("active")) || byCoreName && !collectionName.equals(coreNodeProps.getCoreName()) || coreNodeProps.getBaseUrl().equals(cores.getZkController().getBaseUrl())) continue;
                if (origCorename != null) {
                    coreUrl = coreNodeProps.getBaseUrl() + "/" + origCorename;
                } else {
                    coreUrl = coreNodeProps.getCoreUrl();
                    if (coreUrl.endsWith("/")) {
                        coreUrl = coreUrl.substring(0, coreUrl.length() - 1);
                    }
                }
                return coreUrl;
            }
        }
        return null;
    }

    private Collection<Slice> getSlicesForCollections(ClusterState clusterState, Collection<Slice> slices, boolean activeSlices) {
        Set<String> collections = clusterState.getCollections();
        for (String collection : collections) {
            if (activeSlices) {
                slices.addAll(clusterState.getActiveSlices(collection));
                continue;
            }
            slices.addAll(clusterState.getSlices(collection));
        }
        return slices;
    }

    private SolrCore getCoreByCollection(CoreContainer cores, String corename, String path) {
        String collection = corename;
        ZkStateReader zkStateReader = cores.getZkController().getZkStateReader();
        ClusterState clusterState = zkStateReader.getClusterState();
        Map<String, Slice> slices = clusterState.getActiveSlicesMap(collection);
        if (slices == null) {
            return null;
        }
        Set<Map.Entry<String, Slice>> entries = slices.entrySet();
        SolrCore core = null;
        block0: for (Map.Entry<String, Slice> entry : entries) {
            Replica leaderProps = clusterState.getLeader(collection, entry.getKey());
            if (leaderProps != null) {
                core = this.checkProps(cores, path, leaderProps);
            }
            if (core != null) break;
            Map<String, Replica> shards = entry.getValue().getReplicasMap();
            Set<Map.Entry<String, Replica>> shardEntries = shards.entrySet();
            for (Map.Entry<String, Replica> shardEntry : shardEntries) {
                Replica zkProps = shardEntry.getValue();
                core = this.checkProps(cores, path, zkProps);
                if (core == null) continue;
                break block0;
            }
        }
        return core;
    }

    private SolrCore checkProps(CoreContainer cores, String path, ZkNodeProps zkProps) {
        SolrCore core = null;
        if (cores.getZkController().getNodeName().equals(zkProps.getStr("node_name"))) {
            String corename = zkProps.getStr("core");
            core = cores.getCore(corename);
        }
        return core;
    }

    private void handleAdminRequest(HttpServletRequest req, ServletResponse response, SolrRequestHandler handler, SolrQueryRequest solrReq) throws IOException {
        QueryResponseWriter respWriter;
        SolrQueryResponse solrResp = new SolrQueryResponse();
        SolrCore.preDecorateResponse(solrReq, solrResp);
        handler.handleRequest(solrReq, solrResp);
        SolrCore.postDecorateResponse(handler, solrReq, solrResp);
        if (this.log.isInfoEnabled() && solrResp.getToLog().size() > 0) {
            this.log.info(solrResp.getToLogAsString("[admin] "));
        }
        if ((respWriter = SolrCore.DEFAULT_RESPONSE_WRITERS.get(solrReq.getParams().get("wt"))) == null) {
            respWriter = SolrCore.DEFAULT_RESPONSE_WRITERS.get("standard");
        }
        this.writeResponse(solrResp, response, respWriter, solrReq, Method.getMethod(req.getMethod()));
    }

    private void writeResponse(SolrQueryResponse solrRsp, ServletResponse response, QueryResponseWriter responseWriter, SolrQueryRequest solrReq, Method reqMethod) throws IOException {
        String ct = responseWriter.getContentType(solrReq, solrRsp);
        if (null != ct) {
            response.setContentType(ct);
        }
        if (solrRsp.getException() != null) {
            SimpleOrderedMap info = new SimpleOrderedMap();
            int code = ResponseUtils.getErrorInfo(solrRsp.getException(), info, this.log);
            solrRsp.add("error", info);
            ((HttpServletResponse)response).setStatus(code);
        }
        if (Method.HEAD != reqMethod) {
            if (responseWriter instanceof BinaryQueryResponseWriter) {
                BinaryQueryResponseWriter binWriter = (BinaryQueryResponseWriter)responseWriter;
                binWriter.write((OutputStream)response.getOutputStream(), solrReq, solrRsp);
            } else {
                String charset = ContentStreamBase.getCharsetFromContentType(ct);
                Writer out = charset == null || charset.equalsIgnoreCase("UTF-8") ? new OutputStreamWriter((OutputStream)response.getOutputStream(), UTF8) : new OutputStreamWriter((OutputStream)response.getOutputStream(), charset);
                out = new FastWriter(out);
                responseWriter.write(out, solrReq, solrRsp);
                out.flush();
            }
        }
    }

    protected void execute(HttpServletRequest req, SolrRequestHandler handler, SolrQueryRequest sreq, SolrQueryResponse rsp) {
        sreq.getContext().put("webapp", req.getContextPath());
        sreq.getCore().execute(handler, sreq, rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendError(SolrCore core, SolrQueryRequest req, ServletRequest request, HttpServletResponse response, Throwable ex) throws IOException {
        Exception exp = null;
        SolrCore localCore = null;
        try {
            SolrQueryResponse solrResp = new SolrQueryResponse();
            if (ex instanceof Exception) {
                solrResp.setException((Exception)ex);
            } else {
                solrResp.setException(new RuntimeException(ex));
            }
            localCore = core == null ? this.cores.getCore("") : core;
            if (req == null) {
                SolrParams solrParams = request instanceof HttpServletRequest ? SolrRequestParsers.parseQueryString(((HttpServletRequest)request).getQueryString()) : new MapSolrParams(Collections.<String, String>emptyMap());
                req = new SolrQueryRequestBase(core, solrParams){};
            }
            QueryResponseWriter writer = core.getQueryResponseWriter(req);
            this.writeResponse(solrResp, (ServletResponse)response, writer, req, Method.GET);
        }
        catch (Exception e) {
            exp = e;
        }
        finally {
            try {
                if (exp != null) {
                    SimpleOrderedMap info = new SimpleOrderedMap();
                    int code = ResponseUtils.getErrorInfo(ex, info, this.log);
                    response.sendError(code, info.toString());
                }
            }
            finally {
                if (core == null && localCore != null) {
                    localCore.close();
                }
            }
        }
    }

    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }
}

