/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.search.grouping.term.TermSecondPassGroupingCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.grouping.Command;

public class TopGroupsFieldCommand
implements Command<TopGroups<BytesRef>> {
    private final SchemaField field;
    private final Sort groupSort;
    private final Sort sortWithinGroup;
    private final Collection<SearchGroup<BytesRef>> firstPhaseGroups;
    private final int maxDocPerGroup;
    private final boolean needScores;
    private final boolean needMaxScore;
    private TermSecondPassGroupingCollector secondPassCollector;

    private TopGroupsFieldCommand(SchemaField field, Sort groupSort, Sort sortWithinGroup, Collection<SearchGroup<BytesRef>> firstPhaseGroups, int maxDocPerGroup, boolean needScores, boolean needMaxScore) {
        this.field = field;
        this.groupSort = groupSort;
        this.sortWithinGroup = sortWithinGroup;
        this.firstPhaseGroups = firstPhaseGroups;
        this.maxDocPerGroup = maxDocPerGroup;
        this.needScores = needScores;
        this.needMaxScore = needMaxScore;
    }

    @Override
    public List<Collector> create() throws IOException {
        if (this.firstPhaseGroups.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Collector> collectors = new ArrayList<Collector>();
        this.secondPassCollector = new TermSecondPassGroupingCollector(this.field.getName(), this.firstPhaseGroups, this.groupSort, this.sortWithinGroup, this.maxDocPerGroup, this.needScores, this.needMaxScore, true);
        collectors.add(this.secondPassCollector);
        return collectors;
    }

    @Override
    public TopGroups<BytesRef> result() {
        if (this.firstPhaseGroups.isEmpty()) {
            return new TopGroups<BytesRef>(this.groupSort.getSort(), this.sortWithinGroup.getSort(), 0, 0, new GroupDocs[0], Float.NaN);
        }
        return this.secondPassCollector.getTopGroups(0);
    }

    @Override
    public String getKey() {
        return this.field.getName();
    }

    @Override
    public Sort getGroupSort() {
        return this.groupSort;
    }

    @Override
    public Sort getSortWithinGroup() {
        return this.sortWithinGroup;
    }

    public static class Builder {
        private SchemaField field;
        private Sort groupSort;
        private Sort sortWithinGroup;
        private Collection<SearchGroup<BytesRef>> firstPhaseGroups;
        private Integer maxDocPerGroup;
        private boolean needScores = false;
        private boolean needMaxScore = false;

        public Builder setField(SchemaField field) {
            this.field = field;
            return this;
        }

        public Builder setGroupSort(Sort groupSort) {
            this.groupSort = groupSort;
            return this;
        }

        public Builder setSortWithinGroup(Sort sortWithinGroup) {
            this.sortWithinGroup = sortWithinGroup;
            return this;
        }

        public Builder setFirstPhaseGroups(Collection<SearchGroup<BytesRef>> firstPhaseGroups) {
            this.firstPhaseGroups = firstPhaseGroups;
            return this;
        }

        public Builder setMaxDocPerGroup(int maxDocPerGroup) {
            this.maxDocPerGroup = maxDocPerGroup;
            return this;
        }

        public Builder setNeedScores(Boolean needScores) {
            this.needScores = needScores;
            return this;
        }

        public Builder setNeedMaxScore(Boolean needMaxScore) {
            this.needMaxScore = needMaxScore;
            return this;
        }

        public TopGroupsFieldCommand build() {
            if (this.field == null || this.groupSort == null || this.sortWithinGroup == null || this.firstPhaseGroups == null || this.maxDocPerGroup == null) {
                throw new IllegalStateException("All required fields must be set");
            }
            return new TopGroupsFieldCommand(this.field, this.groupSort, this.sortWithinGroup, this.firstPhaseGroups, this.maxDocPerGroup, this.needScores, this.needMaxScore);
        }
    }
}

