/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.util.Iterator;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.SimpleOrderedMap;

public abstract class SimilarityFactory {
    public static final String CLASS_NAME = "class";
    protected SolrParams params;

    public void init(SolrParams params) {
        this.params = params;
    }

    public SolrParams getParams() {
        return this.params;
    }

    public abstract Similarity getSimilarity();

    public SimpleOrderedMap<Object> getNamedPropertyValues() {
        SimpleOrderedMap<Object> props = new SimpleOrderedMap<Object>();
        props.add(CLASS_NAME, this.getClassArg());
        if (null != this.params) {
            Iterator<String> iter = this.params.getParameterNamesIterator();
            while (iter.hasNext()) {
                String key = iter.next();
                if (CLASS_NAME.equals(key)) continue;
                props.add(key, this.params.get(key));
            }
        }
        return props;
    }

    public String getClassArg() {
        String className;
        if (null != this.params && null != (className = this.params.get(CLASS_NAME))) {
            return className;
        }
        className = this.getClass().getName();
        if (className.startsWith("org.apache.solr.schema.IndexSchema$")) {
            className = this.getSimilarity().getClass().getName();
        }
        return className;
    }
}

