/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BinaryQueryResponseWriter;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.response.transform.TransformContext;
import org.apache.solr.schema.BCDIntField;
import org.apache.solr.schema.BCDLongField;
import org.apache.solr.schema.BCDStrField;
import org.apache.solr.schema.BinaryField;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.ByteField;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.DoubleField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.FloatField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IntField;
import org.apache.solr.schema.LongField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.ShortField;
import org.apache.solr.schema.SortableDoubleField;
import org.apache.solr.schema.SortableFloatField;
import org.apache.solr.schema.SortableIntField;
import org.apache.solr.schema.SortableLongField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TextField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.schema.TrieDoubleField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.schema.TrieFloatField;
import org.apache.solr.schema.TrieIntField;
import org.apache.solr.schema.TrieLongField;
import org.apache.solr.search.DocList;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryResponseWriter
implements BinaryQueryResponseWriter {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryResponseWriter.class);
    public static final Set<Class> KNOWN_TYPES = new HashSet<Class>();

    @Override
    public void write(OutputStream out, SolrQueryRequest req, SolrQueryResponse response) throws IOException {
        Resolver resolver = new Resolver(req, response.getReturnFields());
        Boolean omitHeader = req.getParams().getBool("omitHeader");
        if (omitHeader != null && omitHeader.booleanValue()) {
            response.getValues().remove("responseHeader");
        }
        JavaBinCodec codec = new JavaBinCodec(resolver);
        codec.marshal(response.getValues(), out);
    }

    @Override
    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        throw new RuntimeException("This is a binary writer , Cannot write to a characterstream");
    }

    @Override
    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        return "application/octet-stream";
    }

    @Override
    public void init(NamedList args) {
    }

    public static NamedList<Object> getParsedResponse(SolrQueryRequest req, SolrQueryResponse rsp) {
        try {
            Resolver resolver = new Resolver(req, rsp.getReturnFields());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            new JavaBinCodec(resolver).marshal(rsp.getValues(), out);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            return (NamedList)new JavaBinCodec(resolver).unmarshal(in);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        KNOWN_TYPES.add(BoolField.class);
        KNOWN_TYPES.add(BCDIntField.class);
        KNOWN_TYPES.add(BCDLongField.class);
        KNOWN_TYPES.add(BCDStrField.class);
        KNOWN_TYPES.add(ByteField.class);
        KNOWN_TYPES.add(DateField.class);
        KNOWN_TYPES.add(DoubleField.class);
        KNOWN_TYPES.add(FloatField.class);
        KNOWN_TYPES.add(ShortField.class);
        KNOWN_TYPES.add(IntField.class);
        KNOWN_TYPES.add(LongField.class);
        KNOWN_TYPES.add(SortableLongField.class);
        KNOWN_TYPES.add(SortableIntField.class);
        KNOWN_TYPES.add(SortableFloatField.class);
        KNOWN_TYPES.add(SortableDoubleField.class);
        KNOWN_TYPES.add(StrField.class);
        KNOWN_TYPES.add(TextField.class);
        KNOWN_TYPES.add(TrieField.class);
        KNOWN_TYPES.add(TrieIntField.class);
        KNOWN_TYPES.add(TrieLongField.class);
        KNOWN_TYPES.add(TrieFloatField.class);
        KNOWN_TYPES.add(TrieDoubleField.class);
        KNOWN_TYPES.add(TrieDateField.class);
        KNOWN_TYPES.add(BinaryField.class);
    }

    public static class Resolver
    implements JavaBinCodec.ObjectResolver {
        protected final SolrQueryRequest solrQueryRequest;
        protected IndexSchema schema;
        protected SolrIndexSearcher searcher;
        protected final ReturnFields returnFields;
        boolean useFieldObjects = true;

        public Resolver(SolrQueryRequest req, ReturnFields returnFields) {
            this.solrQueryRequest = req;
            this.returnFields = returnFields;
        }

        @Override
        public Object resolve(Object o, JavaBinCodec codec) throws IOException {
            if (o instanceof ResultContext) {
                this.writeResults((ResultContext)o, codec);
                return null;
            }
            if (o instanceof DocList) {
                ResultContext ctx = new ResultContext();
                ctx.docs = (DocList)o;
                this.writeResults(ctx, codec);
                return null;
            }
            if (o instanceof IndexableField) {
                if (this.schema == null) {
                    this.schema = this.solrQueryRequest.getSchema();
                }
                IndexableField f = (IndexableField)o;
                SchemaField sf = this.schema.getFieldOrNull(f.name());
                try {
                    o = this.getValue(sf, f);
                }
                catch (Exception e) {
                    LOG.warn("Error reading a field : " + o, (Throwable)e);
                }
            }
            if (o instanceof SolrDocument) {
                SolrDocument doc = (SolrDocument)o;
                Iterator<Map.Entry<String, Object>> i = doc.iterator();
                while (i.hasNext()) {
                    String fname = i.next().getKey();
                    if (this.returnFields.wantsField(fname)) continue;
                    i.remove();
                }
                return doc;
            }
            return o;
        }

        protected void writeResultsBody(ResultContext res, JavaBinCodec codec) throws IOException {
            DocList ids = res.docs;
            int sz = ids.size();
            codec.writeTag((byte)-128, sz);
            if (this.searcher == null) {
                this.searcher = this.solrQueryRequest.getSearcher();
            }
            if (this.schema == null) {
                this.schema = this.solrQueryRequest.getSchema();
            }
            DocTransformer transformer = this.returnFields.getTransformer();
            TransformContext context = new TransformContext();
            context.query = res.query;
            context.wantsScores = this.returnFields.wantsScore() && ids.hasScores();
            context.req = this.solrQueryRequest;
            context.searcher = this.searcher;
            if (transformer != null) {
                transformer.setContext(context);
            }
            Set<String> fnames = this.returnFields.getLuceneFieldNames();
            context.iterator = ids.iterator();
            for (int i = 0; i < sz; ++i) {
                int id = context.iterator.nextDoc();
                Document doc = this.searcher.doc(id, fnames);
                SolrDocument sdoc = this.getDoc(doc);
                if (transformer != null) {
                    transformer.transform(sdoc, id);
                }
                codec.writeSolrDocument(sdoc);
            }
            if (transformer != null) {
                transformer.setContext(null);
            }
        }

        public void writeResults(ResultContext ctx, JavaBinCodec codec) throws IOException {
            codec.writeTag((byte)12);
            boolean wantsScores = this.returnFields.wantsScore() && ctx.docs.hasScores();
            ArrayList<Number> l = new ArrayList<Number>(3);
            l.add(Long.valueOf(ctx.docs.matches()));
            l.add(Long.valueOf(ctx.docs.offset()));
            Float maxScore = null;
            if (wantsScores) {
                maxScore = Float.valueOf(ctx.docs.maxScore());
            }
            l.add(maxScore);
            codec.writeArray(l);
            this.writeResultsBody(ctx, codec);
        }

        public SolrDocument getDoc(Document doc) {
            SolrDocument solrDoc = new SolrDocument();
            for (IndexableField f : doc) {
                String fieldName = f.name();
                if (!this.returnFields.wantsField(fieldName)) continue;
                SchemaField sf = this.schema.getFieldOrNull(fieldName);
                Object val = null;
                try {
                    val = this.getValue(sf, f);
                }
                catch (Exception e) {
                    LOG.warn("Error reading a field from document : " + solrDoc, (Throwable)e);
                    continue;
                }
                if (sf != null && sf.multiValued() && !solrDoc.containsKey(fieldName)) {
                    ArrayList<Object> l = new ArrayList<Object>();
                    l.add(val);
                    solrDoc.addField(fieldName, l);
                    continue;
                }
                solrDoc.addField(fieldName, val);
            }
            return solrDoc;
        }

        public Object getValue(SchemaField sf, IndexableField f) throws Exception {
            FieldType ft = null;
            if (sf != null) {
                ft = sf.getType();
            }
            if (ft == null) {
                BytesRef bytesRef = f.binaryValue();
                if (bytesRef != null) {
                    if (bytesRef.offset == 0 && bytesRef.length == bytesRef.bytes.length) {
                        return bytesRef.bytes;
                    }
                    byte[] bytes = new byte[bytesRef.length];
                    System.arraycopy(bytesRef.bytes, bytesRef.offset, bytes, 0, bytesRef.length);
                    return bytes;
                }
                return f.stringValue();
            }
            if (this.useFieldObjects && KNOWN_TYPES.contains(ft.getClass())) {
                return ft.toObject(f);
            }
            return ft.toExternal(f);
        }
    }
}

