/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.internal.csv.writer;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.internal.csv.writer.CSVConfig;
import org.apache.solr.internal.csv.writer.CSVField;

public class CSVConfigGuesser {
    private InputStream in;
    private boolean hasFieldHeader = false;
    protected CSVConfig config = new CSVConfig();

    public CSVConfigGuesser() {
    }

    public CSVConfigGuesser(InputStream in) {
        this();
        this.setInputStream(in);
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    protected InputStream getInputStream() {
        return this.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSVConfig guess() {
        try {
            int counter;
            BufferedReader bIn = new BufferedReader(new InputStreamReader(this.getInputStream(), IOUtils.CHARSET_UTF_8));
            String[] lines = new String[10];
            String line = null;
            for (counter = 0; (line = bIn.readLine()) != null && counter <= 10; ++counter) {
                lines[counter] = line;
            }
            if (counter < 10) {
                String[] newLines = new String[counter];
                System.arraycopy(lines, 0, newLines, 0, counter);
                lines = newLines;
            }
            this.analyseLines(lines);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (Exception e) {}
            }
        }
        CSVConfig conf = this.config;
        this.config = null;
        return conf;
    }

    protected void analyseLines(String[] lines) {
        this.guessFixedWidth(lines);
        this.guessFieldSeperator(lines);
    }

    protected void guessFixedWidth(String[] lines) {
        int lastLength = 0;
        this.config.setFixedWidth(true);
        for (int i = 0; i < lines.length; ++i) {
            if (i == 0) {
                lastLength = lines[i].length();
                continue;
            }
            if (lastLength == lines[i].length()) continue;
            this.config.setFixedWidth(false);
        }
    }

    protected void guessFieldSeperator(String[] lines) {
        if (this.config.isFixedWidth()) {
            this.guessFixedWidthSeperator(lines);
            return;
        }
        for (int i = 0; i < lines.length; ++i) {
        }
    }

    protected void guessFixedWidthSeperator(String[] lines) {
        int previousMatch = -1;
        for (int i = 0; i < lines[0].length(); ++i) {
            char last = ' ';
            boolean charMatches = true;
            for (int j = 0; j < lines.length; ++j) {
                if (j == 0) {
                    last = lines[j].charAt(i);
                }
                if (last == lines[j].charAt(i)) continue;
                charMatches = false;
                break;
            }
            if (!charMatches) continue;
            if (previousMatch == -1) {
                previousMatch = 0;
            }
            CSVField field = new CSVField();
            field.setName("field" + this.config.getFields().length + 1);
            field.setSize(i - previousMatch);
            this.config.addField(field);
        }
    }

    public boolean hasFieldHeader() {
        return this.hasFieldHeader;
    }

    public void setHasFieldHeader(boolean hasFieldHeader) {
        this.hasFieldHeader = hasFieldHeader;
    }
}

