/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.AbstractStatsValues;
import org.apache.solr.schema.SchemaField;

class StringStatsValues
extends AbstractStatsValues<String> {
    public StringStatsValues(SchemaField sf, boolean calcDistinct) {
        super(sf, calcDistinct);
    }

    @Override
    public void accumulate(int docID) {
        if (this.values.exists(docID)) {
            String value = this.values.strVal(docID);
            if (value != null) {
                this.accumulate(value, 1);
            } else {
                this.missing();
            }
        } else {
            this.missing();
        }
    }

    @Override
    protected void updateTypeSpecificStats(NamedList stv) {
    }

    @Override
    protected void updateTypeSpecificStats(String value, int count) {
    }

    @Override
    protected void updateMinMax(String min, String max) {
        this.max = StringStatsValues.max((String)this.max, max);
        this.min = StringStatsValues.min((String)this.min, min);
    }

    @Override
    protected void addTypeSpecificStats(NamedList<Object> res) {
    }

    private static String max(String str1, String str2) {
        if (str1 == null) {
            return str2;
        }
        if (str2 == null) {
            return str1;
        }
        return str1.compareTo(str2) > 0 ? str1 : str2;
    }

    private static String min(String str1, String str2) {
        if (str1 == null) {
            return str2;
        }
        if (str2 == null) {
            return str1;
        }
        return str1.compareTo(str2) < 0 ? str1 : str2;
    }
}

