/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.plugins.segment.ListRecord;
import org.apache.jackrabbit.oak.plugins.segment.MapEntry;
import org.apache.jackrabbit.oak.plugins.segment.MapRecord;
import org.apache.jackrabbit.oak.plugins.segment.PropertyTemplate;
import org.apache.jackrabbit.oak.plugins.segment.Record;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentPropertyState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentVersion;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;

@Deprecated
public class Template {
    static final short ZERO_CHILD_NODES_TYPE = 0;
    static final short SINGLE_CHILD_NODE_TYPE = 1;
    static final short MANY_CHILD_NODES_TYPE = 2;
    static final String ZERO_CHILD_NODES = null;
    static final String MANY_CHILD_NODES = "";
    @CheckForNull
    private final PropertyState primaryType;
    @CheckForNull
    private final PropertyState mixinTypes;
    @Nonnull
    private final PropertyTemplate[] properties;
    @CheckForNull
    private final String childName;

    Template(PropertyState primaryType, PropertyState mixinTypes, PropertyTemplate[] properties, String childName) {
        this.primaryType = primaryType;
        this.mixinTypes = mixinTypes;
        if (properties != null) {
            this.properties = properties;
            Arrays.sort(this.properties);
        } else {
            this.properties = new PropertyTemplate[0];
        }
        this.childName = childName;
    }

    Template(NodeState state) {
        PropertyState primary = null;
        PropertyState mixins = null;
        ArrayList templates = Lists.newArrayList();
        for (PropertyState property : state.getProperties()) {
            String name = property.getName();
            Type type = property.getType();
            if ("jcr:primaryType".equals(name) && type == Type.NAME) {
                primary = property;
                continue;
            }
            if ("jcr:mixinTypes".equals(name) && type == Type.NAMES) {
                mixins = property;
                continue;
            }
            templates.add(new PropertyTemplate(property));
        }
        this.primaryType = primary;
        this.mixinTypes = mixins;
        this.properties = templates.toArray(new PropertyTemplate[templates.size()]);
        Arrays.sort(this.properties);
        long count = state.getChildNodeCount(2L);
        if (count == 0L) {
            this.childName = ZERO_CHILD_NODES;
        } else if (count == 1L) {
            this.childName = (String)state.getChildNodeNames().iterator().next();
            Preconditions.checkState((this.childName != null && !this.childName.equals(MANY_CHILD_NODES) ? 1 : 0) != 0);
        } else {
            this.childName = MANY_CHILD_NODES;
        }
    }

    PropertyState getPrimaryType() {
        return this.primaryType;
    }

    PropertyState getMixinTypes() {
        return this.mixinTypes;
    }

    PropertyTemplate[] getPropertyTemplates() {
        return this.properties;
    }

    PropertyTemplate getPropertyTemplate(String name) {
        int index;
        int hash = name.hashCode();
        for (index = 0; index < this.properties.length && this.properties[index].getName().hashCode() < hash; ++index) {
        }
        while (index < this.properties.length && this.properties[index].getName().hashCode() == hash) {
            if (name.equals(this.properties[index].getName())) {
                return this.properties[index];
            }
            ++index;
        }
        return null;
    }

    String getChildName() {
        return this.childName;
    }

    SegmentPropertyState getProperty(RecordId recordId, int index) {
        Preconditions.checkElementIndex((int)index, (int)this.properties.length);
        Segment segment = ((RecordId)Preconditions.checkNotNull((Object)recordId)).getSegment();
        int offset = recordId.getOffset() + 3;
        if (this.childName != ZERO_CHILD_NODES) {
            offset += 3;
        }
        RecordId rid = null;
        if (segment.getSegmentVersion().onOrAfter(SegmentVersion.V_11)) {
            RecordId lid = segment.readRecordId(offset);
            ListRecord props = new ListRecord(lid, this.properties.length);
            rid = props.getEntry(index);
        } else {
            rid = segment.readRecordId(offset += index * 3);
        }
        return new SegmentPropertyState(rid, this.properties[index]);
    }

    MapRecord getChildNodeMap(RecordId recordId) {
        Preconditions.checkState((this.childName != ZERO_CHILD_NODES ? 1 : 0) != 0);
        Segment segment = recordId.getSegment();
        int offset = recordId.getOffset() + 3;
        RecordId childNodesId = segment.readRecordId(offset);
        return segment.readMap(childNodesId);
    }

    @Deprecated
    public NodeState getChildNode(String name, RecordId recordId) {
        if (this.childName == ZERO_CHILD_NODES) {
            return EmptyNodeState.MISSING_NODE;
        }
        if (this.childName == MANY_CHILD_NODES) {
            MapRecord map = this.getChildNodeMap(recordId);
            MapEntry child = map.getEntry(name);
            if (child != null) {
                return child.getNodeState();
            }
            return EmptyNodeState.MISSING_NODE;
        }
        if (name.equals(this.childName)) {
            Segment segment = recordId.getSegment();
            int offset = recordId.getOffset() + 3;
            RecordId childNodeId = segment.readRecordId(offset);
            return new SegmentNodeState(childNodeId);
        }
        return EmptyNodeState.MISSING_NODE;
    }

    Iterable<? extends ChildNodeEntry> getChildNodeEntries(RecordId recordId) {
        if (this.childName == ZERO_CHILD_NODES) {
            return Collections.emptyList();
        }
        if (this.childName == MANY_CHILD_NODES) {
            MapRecord map = this.getChildNodeMap(recordId);
            return map.getEntries();
        }
        Segment segment = recordId.getSegment();
        int offset = recordId.getOffset() + 3;
        RecordId childNodeId = segment.readRecordId(offset);
        return Collections.singletonList(new MemoryChildNodeEntry(this.childName, (NodeState)new SegmentNodeState(childNodeId)));
    }

    @Deprecated
    public boolean compare(RecordId thisId, RecordId thatId) {
        MapRecord thatMap;
        Preconditions.checkNotNull((Object)thisId);
        Preconditions.checkNotNull((Object)thatId);
        for (int i = 0; i < this.properties.length; ++i) {
            SegmentPropertyState thatProperty;
            SegmentPropertyState thisProperty = this.getProperty(thisId, i);
            if (((Object)thisProperty).equals(thatProperty = this.getProperty(thatId, i))) continue;
            return false;
        }
        if (this.childName == ZERO_CHILD_NODES) {
            return true;
        }
        if (this.childName != MANY_CHILD_NODES) {
            NodeState thisChild = this.getChildNode(this.childName, thisId);
            NodeState thatChild = this.getChildNode(this.childName, thatId);
            return thisChild.equals(thatChild);
        }
        MapRecord thisMap = this.getChildNodeMap(thisId);
        if (Record.fastEquals((Record)thisMap, thatMap = this.getChildNodeMap(thatId))) {
            return true;
        }
        if (thisMap.size() != thatMap.size()) {
            return false;
        }
        for (MapEntry entry : thisMap.getEntries()) {
            String name = entry.getName();
            MapEntry thatEntry = thatMap.getEntry(name);
            if (thatEntry == null) {
                return false;
            }
            if (entry.getNodeState().equals(thatEntry.getNodeState())) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Template) {
            Template that = (Template)object;
            return Objects.equal((Object)this.primaryType, (Object)that.primaryType) && Objects.equal((Object)this.mixinTypes, (Object)that.mixinTypes) && Arrays.equals(this.properties, that.properties) && Objects.equal((Object)this.childName, (Object)that.childName);
        }
        return false;
    }

    @Deprecated
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.primaryType, this.mixinTypes, Arrays.asList(this.properties), this.getTemplateType(), this.childName});
    }

    @Deprecated
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        if (this.primaryType != null) {
            builder.append(this.primaryType);
            builder.append(", ");
        }
        if (this.mixinTypes != null) {
            builder.append(this.mixinTypes);
            builder.append(", ");
        }
        for (int i = 0; i < this.properties.length; ++i) {
            builder.append(this.properties[i]);
            builder.append(" = ?, ");
        }
        if (this.childName == ZERO_CHILD_NODES) {
            builder.append("<no children>");
        } else if (this.childName == MANY_CHILD_NODES) {
            builder.append("<many children>");
        } else {
            builder.append(this.childName + " = <node>");
        }
        builder.append(" }");
        return builder.toString();
    }

    short getTemplateType() {
        if (this.childName == ZERO_CHILD_NODES) {
            return 0;
        }
        if (this.childName == MANY_CHILD_NODES) {
            return 2;
        }
        return 1;
    }
}

