/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.cache.RemovalCause;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.cache.CacheLIRS;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.plugins.blob.ReferenceCollector;
import org.apache.jackrabbit.oak.plugins.segment.CompactionMap;
import org.apache.jackrabbit.oak.plugins.segment.PartialCompactionMap;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentIdTable;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentVersion;
import org.apache.jackrabbit.oak.plugins.segment.SegmentWriter;
import org.apache.jackrabbit.oak.plugins.segment.StringCache;
import org.apache.jackrabbit.oak.plugins.segment.compaction.CompactionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentTracker {
    private static final Logger log = LoggerFactory.getLogger(SegmentTracker.class);
    private static final boolean DISABLE_STRING_CACHE = Boolean.getBoolean("oak.segment.disableStringCache");
    static final String STRING_CACHE_SIZE = "oak.segment.stringCache";
    private static final long MSB_MASK = -61441L;
    private static final long VERSION = 16384L;
    private static final long LSB_MASK = 0xFFFFFFFFFFFFFFFL;
    private static final long DATA = -6917529027641081856L;
    private static final long BULK = -5764607523034234880L;
    private static final long MB = 0x100000L;
    private static final int DEFAULT_MEMORY_CACHE_SIZE = 256;
    private final SecureRandom random = new SecureRandom();
    private final SegmentStore store;
    private final SegmentWriter writer;
    private final AtomicReference<CompactionMap> compactionMap;
    private final SegmentIdTable[] tables = new SegmentIdTable[32];
    private final StringCache stringCache;
    private final CacheLIRS<SegmentId, Segment> segmentCache;
    private final AtomicInteger segmentCounter = new AtomicInteger();
    private final SegmentVersion segmentVersion;

    public SegmentTracker(SegmentStore store, int cacheSizeMB, SegmentVersion version) {
        StringCache c;
        this.segmentVersion = version;
        for (int i = 0; i < this.tables.length; ++i) {
            this.tables[i] = new SegmentIdTable(this);
        }
        this.store = store;
        this.compactionMap = new AtomicReference<CompactionMap>(CompactionMap.EMPTY);
        this.writer = this.createSegmentWriter("sys");
        if (DISABLE_STRING_CACHE) {
            c = null;
        } else {
            long cache = Long.getLong(STRING_CACHE_SIZE, cacheSizeMB);
            c = new StringCache(cache * 0x100000L);
        }
        this.stringCache = c;
        this.segmentCache = CacheLIRS.newBuilder().module("SegmentTracker").maximumWeight((long)cacheSizeMB * 0x100000L).averageWeight(131072).evictionCallback((CacheLIRS.EvictionCallback)new CacheLIRS.EvictionCallback<SegmentId, Segment>(){

            public void evicted(SegmentId segmentId, Segment segment, RemovalCause cause) {
                if (segment != null) {
                    segmentId.setSegment(null);
                }
            }
        }).build();
    }

    public SegmentTracker(SegmentStore store, SegmentVersion version) {
        this(store, 256, version);
    }

    public SegmentTracker(SegmentStore store) {
        this(store, 256, SegmentVersion.V_11);
    }

    int getNextSegmentNo() {
        return this.segmentCounter.incrementAndGet();
    }

    public final SegmentWriter createSegmentWriter(String wid) {
        return new SegmentWriter(this.store, this.segmentVersion, wid);
    }

    @Nonnull
    public CacheStats getSegmentCacheStats() {
        return new CacheStats(this.segmentCache, "Segment Cache", null, -1L);
    }

    @CheckForNull
    public CacheStats getStringCacheStats() {
        return this.stringCache == null ? null : this.stringCache.getStats();
    }

    public SegmentWriter getWriter() {
        return this.writer;
    }

    public SegmentStore getStore() {
        return this.store;
    }

    public synchronized void clearCache() {
        this.segmentCache.invalidateAll();
        if (this.stringCache != null) {
            this.stringCache.clear();
        }
    }

    StringCache getStringCache() {
        return this.stringCache;
    }

    Segment getCachedSegment(SegmentId id) {
        try {
            return (Segment)this.segmentCache.get((Object)id);
        }
        catch (ExecutionException e) {
            log.error("Error reading from segment cache", (Throwable)e);
            return null;
        }
    }

    Segment readSegment(SegmentId id) {
        try {
            Segment segment = this.store.readSegment(id);
            this.setSegment(id, segment);
            return segment;
        }
        catch (SegmentNotFoundException snfe) {
            long delta = System.currentTimeMillis() - id.getCreationTime();
            log.error("Segment not found: {}. Creation date delta is {} ms.", new Object[]{id, delta, snfe});
            throw snfe;
        }
    }

    void setSegment(SegmentId id, Segment segment) {
        id.setSegment(segment);
        this.segmentCache.put((Object)id, (Object)segment, segment.size());
    }

    public void setCompactionMap(PartialCompactionMap map) {
        this.compactionMap.set(this.compactionMap.get().cons(map));
    }

    @Nonnull
    public CompactionMap getCompactionMap() {
        return this.compactionMap.get();
    }

    public synchronized Set<SegmentId> getReferencedSegmentIds() {
        HashSet ids = Sets.newHashSet();
        for (SegmentIdTable table : this.tables) {
            table.collectReferencedIds(ids);
        }
        return ids;
    }

    public void collectBlobReferences(ReferenceCollector collector) {
        try {
            HashSet processed = Sets.newHashSet();
            for (SegmentId sid : this.getReferencedSegmentIds()) {
                if (!sid.isDataSegmentId()) continue;
                processed.add(sid.asUUID());
            }
            ArrayDeque queue = Queues.newArrayDeque((Iterable)processed);
            this.writer.flush();
            while (!queue.isEmpty()) {
                UUID uid = (UUID)queue.remove();
                SegmentId id = this.getSegmentId(uid.getMostSignificantBits(), uid.getLeastSignificantBits());
                Segment segment = null;
                try {
                    segment = id.getSegment();
                }
                catch (SegmentNotFoundException segmentNotFoundException) {
                    // empty catch block
                }
                if (segment == null) continue;
                segment.collectBlobReferences(collector);
                for (SegmentId refid : segment.getReferencedIds()) {
                    UUID rid = refid.asUUID();
                    if (!refid.isDataSegmentId() || processed.contains(rid)) continue;
                    queue.add(rid);
                    processed.add(rid);
                }
            }
        }
        catch (IOException e) {
            log.error("Error while flushing pending segments", (Throwable)e);
            throw new IllegalStateException("Unexpected IOException", e);
        }
    }

    public SegmentId getSegmentId(long msb, long lsb) {
        int index = (int)msb & this.tables.length - 1;
        return this.tables[index].getSegmentId(msb, lsb);
    }

    SegmentId newDataSegmentId() {
        return this.newSegmentId(-6917529027641081856L);
    }

    SegmentId newBulkSegmentId() {
        return this.newSegmentId(-5764607523034234880L);
    }

    private SegmentId newSegmentId(long type) {
        long msb = this.random.nextLong() & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        long lsb = this.random.nextLong() & 0xFFFFFFFFFFFFFFFL | type;
        return this.getSegmentId(msb, lsb);
    }

    public synchronized void clearSegmentIdTables(CompactionStrategy strategy) {
        for (SegmentIdTable table : this.tables) {
            table.clearSegmentIdTables(strategy);
        }
    }
}

