/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.segment.Record;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeBuilder;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeStoreBuilder;
import org.apache.jackrabbit.oak.plugins.segment.SegmentOverflowException;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.memory.MemoryStore;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.commit.ChangeDispatcher;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.ConflictAnnotatingRebaseDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentNodeStore
implements NodeStore,
Observable {
    private static final Logger log = LoggerFactory.getLogger(SegmentNodeStore.class);
    static final String ROOT = "root";
    public static final String CHECKPOINTS = "checkpoints";
    private final SegmentStore store;
    private final ChangeDispatcher changeDispatcher;
    private final AtomicReference<SegmentNodeState> head;
    private final Semaphore commitSemaphore;
    private long maximumBackoff = TimeUnit.MILLISECONDS.convert(10L, TimeUnit.SECONDS);
    private int checkpointsLockWaitTime = Integer.getInteger("oak.checkpoints.lockWaitTime", 10);
    private final boolean commitFairLock = Boolean.getBoolean("oak.segmentNodeStore.commitFairLock");
    private static final Closeable NOOP = new Closeable(){

        @Override
        public void close() throws IOException {
        }
    };

    @Nonnull
    public static SegmentNodeStoreBuilder newSegmentNodeStore(@Nonnull SegmentStore store) {
        return SegmentNodeStoreBuilder.newSegmentNodeStore((SegmentStore)Preconditions.checkNotNull((Object)store));
    }

    @Deprecated
    public SegmentNodeStore(SegmentStore store) {
        this(store, false);
    }

    SegmentNodeStore(SegmentStore store, boolean internal) {
        this(store, internal, true);
    }

    SegmentNodeStore(SegmentStore store, boolean internal, boolean dispatchChanges) {
        if (this.commitFairLock) {
            log.info("initializing SegmentNodeStore with the commitFairLock option enabled.");
        }
        this.commitSemaphore = new Semaphore(1, this.commitFairLock);
        this.store = store;
        this.head = new AtomicReference<SegmentNodeState>(store.getHead());
        this.changeDispatcher = dispatchChanges ? new ChangeDispatcher(this.getRoot()) : null;
    }

    public SegmentNodeStore() throws IOException {
        this(new MemoryStore());
    }

    void setMaximumBackoff(long max) {
        this.maximumBackoff = max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean locked(Callable<Boolean> c) throws Exception {
        if (this.commitSemaphore.tryAcquire()) {
            try {
                boolean bl = c.call();
                return bl;
            }
            finally {
                this.commitSemaphore.release();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean locked(Callable<Boolean> c, long timeout, TimeUnit unit) throws Exception {
        if (this.commitSemaphore.tryAcquire(timeout, unit)) {
            try {
                boolean bl = c.call();
                return bl;
            }
            finally {
                this.refreshHead();
                this.commitSemaphore.release();
            }
        }
        return false;
    }

    private void refreshHead() {
        SegmentNodeState state = this.store.getHead();
        if (!state.getRecordId().equals(this.head.get().getRecordId())) {
            this.head.set(state);
            this.contentChanged(state.getChildNode(ROOT), null);
        }
    }

    public Closeable addObserver(Observer observer) {
        if (this.changeDispatcher == null) {
            return NOOP;
        }
        return this.changeDispatcher.addObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public NodeState getRoot() {
        if (this.commitSemaphore.tryAcquire()) {
            try {
                this.refreshHead();
            }
            finally {
                this.commitSemaphore.release();
            }
        }
        return this.head.get().getChildNode(ROOT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public NodeState getSuperRoot() {
        if (this.commitSemaphore.tryAcquire()) {
            try {
                this.refreshHead();
            }
            finally {
                this.commitSemaphore.release();
            }
        }
        return this.head.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeState merge(@Nonnull NodeBuilder builder, @Nonnull CommitHook commitHook, @Nonnull CommitInfo info) throws CommitFailedException {
        Preconditions.checkArgument((boolean)(builder instanceof SegmentNodeBuilder));
        SegmentNodeBuilder snb = (SegmentNodeBuilder)builder;
        Preconditions.checkArgument((boolean)snb.isRootBuilder());
        Preconditions.checkNotNull((Object)commitHook);
        this.commitSemaphore.acquire();
        try {
            Commit commit = new Commit(snb, commitHook, info);
            NodeState merged = commit.execute();
            snb.reset(merged);
            NodeState nodeState = merged;
            this.commitSemaphore.release();
            return nodeState;
        }
        catch (Throwable throwable) {
            try {
                this.commitSemaphore.release();
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CommitFailedException("Segment", 2, "Merge interrupted", (Throwable)e);
            }
            catch (SegmentOverflowException e) {
                throw new CommitFailedException("Segment", 3, "Merge failed", (Throwable)e);
            }
        }
    }

    @Nonnull
    public NodeState rebase(@Nonnull NodeBuilder builder) {
        Preconditions.checkArgument((boolean)(builder instanceof SegmentNodeBuilder));
        SegmentNodeBuilder snb = (SegmentNodeBuilder)builder;
        NodeState root = this.getRoot();
        NodeState before = snb.getBaseState();
        if (!Record.fastEquals(before, (Object)root)) {
            SegmentNodeState after = snb.getNodeState();
            snb.reset(root);
            after.compareAgainstBaseState(before, (NodeStateDiff)new ConflictAnnotatingRebaseDiff((NodeBuilder)snb));
        }
        return snb.getNodeState();
    }

    @Nonnull
    public NodeState reset(@Nonnull NodeBuilder builder) {
        Preconditions.checkArgument((boolean)(builder instanceof SegmentNodeBuilder));
        SegmentNodeBuilder snb = (SegmentNodeBuilder)builder;
        NodeState root = this.getRoot();
        snb.reset(root);
        return root;
    }

    public Blob createBlob(InputStream stream) throws IOException {
        return this.store.getTracker().getWriter().writeStream(stream);
    }

    public Blob getBlob(@Nonnull String reference) {
        BlobStore blobStore = this.store.getBlobStore();
        if (blobStore != null) {
            String blobId = blobStore.getBlobId(reference);
            if (blobId != null) {
                return this.store.readBlob(blobId);
            }
            return null;
        }
        throw new IllegalStateException("Attempt to read external blob with blobId [" + reference + "] " + "without specifying BlobStore");
    }

    @Nonnull
    public String checkpoint(long lifetime, @Nonnull Map<String, String> properties) {
        Preconditions.checkArgument((lifetime > 0L ? 1 : 0) != 0);
        Preconditions.checkNotNull(properties);
        String name = UUID.randomUUID().toString();
        try {
            CPCreator cpc = new CPCreator(name, lifetime, properties);
            if (this.locked(cpc, this.checkpointsLockWaitTime, TimeUnit.SECONDS)) {
                return name;
            }
            log.warn("Failed to create checkpoint {} in {} seconds.", (Object)name, (Object)this.checkpointsLockWaitTime);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("Failed to create checkpoint {}.", (Object)name, (Object)e);
        }
        catch (Exception e) {
            log.error("Failed to create checkpoint {}.", (Object)name, (Object)e);
        }
        return name;
    }

    @Nonnull
    public synchronized String checkpoint(long lifetime) {
        return this.checkpoint(lifetime, Collections.emptyMap());
    }

    @Nonnull
    public Map<String, String> checkpointInfo(@Nonnull String checkpoint) {
        HashMap properties = Maps.newHashMap();
        Preconditions.checkNotNull((Object)checkpoint);
        NodeState cp = this.head.get().getChildNode(CHECKPOINTS).getChildNode(checkpoint).getChildNode("properties");
        for (PropertyState prop : cp.getProperties()) {
            properties.put(prop.getName(), prop.getValue(Type.STRING));
        }
        return properties;
    }

    @Nonnull
    public Iterable<String> checkpoints() {
        return this.getCheckpoints().getChildNodeNames();
    }

    @CheckForNull
    public NodeState retrieve(@Nonnull String checkpoint) {
        Preconditions.checkNotNull((Object)checkpoint);
        NodeState cp = this.head.get().getChildNode(CHECKPOINTS).getChildNode(checkpoint).getChildNode(ROOT);
        if (cp.exists()) {
            return cp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release(@Nonnull String checkpoint) {
        Preconditions.checkNotNull((Object)checkpoint);
        for (int i = 0; i < 5; ++i) {
            if (!this.commitSemaphore.tryAcquire()) continue;
            try {
                this.refreshHead();
                SegmentNodeState state = this.head.get();
                SegmentNodeBuilder builder = state.builder();
                NodeBuilder cp = builder.child(CHECKPOINTS).child(checkpoint);
                if (!cp.exists()) continue;
                cp.remove();
                SegmentNodeState newState = builder.getNodeState();
                if (!this.store.setHead(state, newState)) continue;
                this.refreshHead();
                boolean bl = true;
                return bl;
            }
            finally {
                this.commitSemaphore.release();
            }
        }
        return false;
    }

    NodeState getCheckpoints() {
        return this.head.get().getChildNode(CHECKPOINTS);
    }

    void setCheckpointsLockWaitTime(int checkpointsLockWaitTime) {
        this.checkpointsLockWaitTime = checkpointsLockWaitTime;
    }

    void contentChanged(NodeState root, CommitInfo info) {
        if (this.changeDispatcher != null) {
            this.changeDispatcher.contentChanged(root, info);
        }
    }

    private class Commit {
        private final Random random = new Random();
        private final NodeState before;
        private final SegmentNodeState after;
        private final CommitHook hook;
        private final CommitInfo info;

        Commit(@Nonnull SegmentNodeBuilder builder, @Nonnull CommitHook hook, CommitInfo info) {
            Preconditions.checkNotNull((Object)((Object)builder));
            this.before = builder.getBaseState();
            this.after = builder.getNodeState();
            this.hook = (CommitHook)Preconditions.checkNotNull((Object)hook);
            this.info = (CommitInfo)Preconditions.checkNotNull((Object)info);
        }

        private boolean setHead(SegmentNodeState before, SegmentNodeState after) {
            SegmentNodeStore.this.refreshHead();
            if (SegmentNodeStore.this.store.setHead(before, after)) {
                SegmentNodeStore.this.head.set(after);
                SegmentNodeStore.this.contentChanged(after.getChildNode(SegmentNodeStore.ROOT), this.info);
                SegmentNodeStore.this.refreshHead();
                return true;
            }
            return false;
        }

        private SegmentNodeBuilder prepare(SegmentNodeState state) throws CommitFailedException {
            SegmentNodeBuilder builder = state.builder();
            if (Record.fastEquals(this.before, (Object)state.getChildNode(SegmentNodeStore.ROOT))) {
                builder.setChildNode(SegmentNodeStore.ROOT, this.hook.processCommit(this.before, (NodeState)this.after, this.info));
            } else {
                ConflictAnnotatingRebaseDiff diff = new ConflictAnnotatingRebaseDiff(builder.child(SegmentNodeStore.ROOT));
                this.after.compareAgainstBaseState(this.before, (NodeStateDiff)diff);
                builder.setChildNode(SegmentNodeStore.ROOT, this.hook.processCommit(builder.getBaseState().getChildNode(SegmentNodeStore.ROOT), builder.getNodeState().getChildNode(SegmentNodeStore.ROOT), this.info));
            }
            return builder;
        }

        private long optimisticMerge() throws CommitFailedException, InterruptedException {
            long timeout = 1L;
            for (long backoff = 1L; backoff < SegmentNodeStore.this.maximumBackoff; backoff *= 2L) {
                SegmentNodeBuilder builder;
                long start = System.nanoTime();
                SegmentNodeStore.this.refreshHead();
                SegmentNodeState state = (SegmentNodeState)SegmentNodeStore.this.head.get();
                if ((!state.hasProperty("token") || state.getLong("timeout") < System.currentTimeMillis()) && this.setHead(state, (builder = this.prepare(state)).getNodeState())) {
                    return -1L;
                }
                Thread.sleep(backoff, this.random.nextInt(1000000));
                long stop = System.nanoTime();
                if (stop - start <= timeout) continue;
                timeout = stop - start;
            }
            return TimeUnit.MILLISECONDS.convert(timeout, TimeUnit.NANOSECONDS);
        }

        private void pessimisticMerge(long timeout) throws CommitFailedException, InterruptedException {
            while (true) {
                long now = System.currentTimeMillis();
                SegmentNodeState state = (SegmentNodeState)SegmentNodeStore.this.head.get();
                if (state.hasProperty("token") && state.getLong("timeout") >= now) {
                    Thread.sleep(Math.min(state.getLong("timeout") - now, 1000L), this.random.nextInt(1000000));
                    continue;
                }
                SegmentNodeBuilder builder = state.builder();
                builder.setProperty("token", UUID.randomUUID().toString());
                builder.setProperty("timeout", now + timeout);
                if (!this.setHead(state, builder.getNodeState())) continue;
                builder = this.prepare(state);
                builder.removeProperty("token");
                builder.removeProperty("timeout");
                if (this.setHead(state, builder.getNodeState())) break;
            }
        }

        @Nonnull
        NodeState execute() throws CommitFailedException, InterruptedException {
            long timeout;
            if (!Record.fastEquals(this.before, (Object)this.after) && (timeout = this.optimisticMerge()) >= 0L) {
                this.pessimisticMerge(timeout);
            }
            return ((SegmentNodeState)SegmentNodeStore.this.head.get()).getChildNode(SegmentNodeStore.ROOT);
        }
    }

    private final class CPCreator
    implements Callable<Boolean> {
        private final String name;
        private final long lifetime;
        private final Map<String, String> properties;

        CPCreator(String name, long lifetime, Map<String, String> properties) {
            this.name = name;
            this.lifetime = lifetime;
            this.properties = properties;
        }

        @Override
        public Boolean call() {
            long now = System.currentTimeMillis();
            SegmentNodeStore.this.refreshHead();
            SegmentNodeState state = (SegmentNodeState)SegmentNodeStore.this.head.get();
            SegmentNodeBuilder builder = state.builder();
            NodeBuilder checkpoints = builder.child(SegmentNodeStore.CHECKPOINTS);
            for (String n : checkpoints.getChildNodeNames()) {
                NodeBuilder cp = checkpoints.getChildNode(n);
                PropertyState ts = cp.getProperty("timestamp");
                if (ts != null && ts.getType() == Type.LONG && now <= (Long)ts.getValue(Type.LONG)) continue;
                cp.remove();
            }
            NodeBuilder cp = checkpoints.child(this.name);
            cp.setProperty("timestamp", (Object)(now + this.lifetime));
            cp.setProperty("created", (Object)now);
            NodeBuilder props = cp.setChildNode("properties");
            for (Map.Entry<String, String> p : this.properties.entrySet()) {
                props.setProperty(p.getKey(), (Object)p.getValue());
            }
            cp.setChildNode(SegmentNodeStore.ROOT, state.getChildNode(SegmentNodeStore.ROOT));
            SegmentNodeState newState = builder.getNodeState();
            if (SegmentNodeStore.this.store.setHead(state, newState)) {
                SegmentNodeStore.this.refreshHead();
                return true;
            }
            return false;
        }
    }
}

