/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReaper {
    private static final Logger logger = LoggerFactory.getLogger(FileReaper.class);
    private final Set<String> files = new HashSet<String>();
    private final Object lock = new Object();
    private final SegmentArchiveManager archiveManager;

    public FileReaper(SegmentArchiveManager archiveManager) {
        this.archiveManager = archiveManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(Iterable<String> files) {
        Object object = this.lock;
        synchronized (object) {
            for (String file : files) {
                this.files.add(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reap() {
        HashSet<String> reap;
        Object object = this.lock;
        synchronized (object) {
            reap = new HashSet<String>(this.files);
            this.files.clear();
        }
        HashSet<String> redo = new HashSet<String>();
        ArrayList<String> removed = new ArrayList<String>();
        for (String file : reap) {
            if (this.archiveManager.delete(file)) {
                removed.add(file);
                continue;
            }
            logger.warn("Unable to remove file {}", (Object)file);
            redo.add(file);
        }
        if (!removed.isEmpty()) {
            logger.info("Removed files {}", (Object)String.join((CharSequence)",", removed));
        }
        if (redo.isEmpty()) {
            return;
        }
        this.add(redo);
    }
}

