/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.segment.ListRecord;
import org.apache.jackrabbit.oak.segment.LoggingHook;
import org.apache.jackrabbit.oak.segment.MapRecord;
import org.apache.jackrabbit.oak.segment.PropertyTemplate;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentBlob;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentPropertyState;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.StringCache;
import org.apache.jackrabbit.oak.segment.Template;
import org.apache.jackrabbit.oak.segment.TemplateCache;
import org.apache.jackrabbit.oak.segment.util.SafeEncode;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingSegmentReader
implements SegmentReader {
    public static final int DEFAULT_STRING_CACHE_MB = 256;
    public static final int DEFAULT_TEMPLATE_CACHE_MB = 64;
    private static final Logger LOG = LoggerFactory.getLogger((String)(LoggingHook.class.getName() + ".reader"));
    @NotNull
    private final Supplier<SegmentWriter> writer;
    @Nullable
    private final BlobStore blobStore;
    @NotNull
    private final StringCache stringCache;
    @NotNull
    private final TemplateCache templateCache;
    private final MeterStats readStats;

    public CachingSegmentReader(@NotNull Supplier<SegmentWriter> writer, @Nullable BlobStore blobStore, long stringCacheMB, long templateCacheMB, MeterStats readStats) {
        this.writer = Objects.requireNonNull(writer);
        this.blobStore = blobStore;
        this.stringCache = new StringCache(stringCacheMB * 1024L * 1024L);
        this.templateCache = new TemplateCache(templateCacheMB * 1024L * 1024L);
        this.readStats = readStats;
    }

    @Override
    @NotNull
    public String readString(@NotNull RecordId id) {
        SegmentId segmentId = id.getSegmentId();
        long msb = segmentId.getMostSignificantBits();
        long lsb = segmentId.getLeastSignificantBits();
        return this.stringCache.get(msb, lsb, id.getRecordNumber(), offset -> segmentId.getSegment().readString((int)offset));
    }

    @Override
    @NotNull
    public MapRecord readMap(@NotNull RecordId id) {
        return new MapRecord(this, id);
    }

    @Override
    @NotNull
    public Template readTemplate(@NotNull RecordId id) {
        SegmentId segmentId = id.getSegmentId();
        long msb = segmentId.getMostSignificantBits();
        long lsb = segmentId.getLeastSignificantBits();
        return this.templateCache.get(msb, lsb, id.getRecordNumber(), offset -> this.readTemplate(segmentId.getSegment(), (int)offset));
    }

    private Template readTemplate(Segment segment, int recordNumber) {
        int head = segment.readInt(recordNumber);
        boolean hasPrimaryType = (head & Integer.MIN_VALUE) != 0;
        boolean hasMixinTypes = (head & 0x40000000) != 0;
        boolean zeroChildNodes = (head & 0x20000000) != 0;
        boolean manyChildNodes = (head & 0x10000000) != 0;
        int mixinCount = head >> 18 & 0x3FF;
        int propertyCount = head & 0x3FFFF;
        int offset = 4;
        PropertyState primaryType = null;
        if (hasPrimaryType) {
            RecordId primaryId = segment.readRecordId(recordNumber, offset);
            primaryType = PropertyStates.createProperty((String)"jcr:primaryType", (Object)this.readString(primaryId), (Type)Type.NAME);
            offset += 6;
        }
        PropertyState mixinTypes = null;
        if (hasMixinTypes) {
            String[] mixins = new String[mixinCount];
            for (int i = 0; i < mixins.length; ++i) {
                RecordId mixinId = segment.readRecordId(recordNumber, offset);
                mixins[i] = this.readString(mixinId);
                offset += 6;
            }
            mixinTypes = PropertyStates.createProperty((String)"jcr:mixinTypes", Arrays.asList(mixins), (Type)Type.NAMES);
        }
        String childName = Template.ZERO_CHILD_NODES;
        if (manyChildNodes) {
            childName = "";
        } else if (!zeroChildNodes) {
            RecordId childNameId = segment.readRecordId(recordNumber, offset);
            childName = this.readString(childNameId);
            offset += 6;
        }
        PropertyTemplate[] properties = this.readProps(segment, propertyCount, recordNumber, offset);
        return new Template(this, primaryType, mixinTypes, properties, childName);
    }

    private PropertyTemplate[] readProps(Segment segment, int propertyCount, int recordNumber, int offset) {
        PropertyTemplate[] properties = new PropertyTemplate[propertyCount];
        if (propertyCount > 0) {
            RecordId id = segment.readRecordId(recordNumber, offset);
            ListRecord propertyNames = new ListRecord(id, properties.length);
            offset += 6;
            for (int i = 0; i < propertyCount; ++i) {
                byte type = segment.readByte(recordNumber, offset++);
                properties[i] = new PropertyTemplate(i, this.readString(propertyNames.getEntry(i)), Type.fromTag((int)Math.abs(type), (type < 0 ? 1 : 0) != 0));
            }
        }
        return properties;
    }

    private static String safeEncode(String value) {
        try {
            return SafeEncode.safeEncode(value);
        }
        catch (UnsupportedEncodingException e) {
            return "ERROR: " + String.valueOf(e);
        }
    }

    @Override
    @NotNull
    public SegmentNodeState readNode(@NotNull RecordId id) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} n? {}", (Object)Thread.currentThread().getId(), (Object)id);
        }
        return new SegmentNodeState((SegmentReader)this, this.writer, this.blobStore, id, this.readStats);
    }

    @Override
    @NotNull
    public SegmentNodeState readHeadState(@NotNull Revisions revisions) {
        return this.readNode(revisions.getHead());
    }

    @Override
    @NotNull
    public SegmentPropertyState readProperty(@NotNull RecordId id, @NotNull PropertyTemplate template) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} p? {}", (Object)Thread.currentThread().getId(), (Object)id);
        }
        return new SegmentPropertyState(this, id, template);
    }

    @Override
    @NotNull
    public SegmentBlob readBlob(@NotNull RecordId id) {
        return new SegmentBlob(this.blobStore, id);
    }

    @NotNull
    public CacheStats getStringCacheStats() {
        return this.stringCache.getStats();
    }

    @NotNull
    public CacheStats getTemplateCacheStats() {
        return this.templateCache.getStats();
    }
}

