/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.JournalReader;

public class Compact
implements Runnable {
    private final File path;
    @CheckForNull
    private final Boolean mmap;

    public static Builder builder() {
        return new Builder();
    }

    private Compact(Builder builder) {
        this.path = builder.path;
        this.mmap = builder.mmap;
    }

    @Override
    public void run() {
        try {
            this.compact();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void compact() throws IOException, InvalidFileStoreVersionException {
        try (FileStore store = this.newFileStore();){
            store.compact();
        }
        System.out.println("    -> cleaning up");
        store = this.newFileStore();
        var2_2 = null;
        try {
            String head;
            store.cleanup();
            File journal = new File(this.path, "journal.log");
            try (JournalReader journalReader = new JournalReader(journal);){
                head = (String)journalReader.next() + " root " + System.currentTimeMillis() + "\n";
            }
            var6_12 = null;
            try (RandomAccessFile journalFile = new RandomAccessFile(journal, "rw");){
                System.out.println("    -> writing new " + journal.getName() + ": " + head);
                journalFile.setLength(0L);
                journalFile.writeBytes(head);
                journalFile.getChannel().force(false);
            }
            catch (Throwable throwable) {
                var6_12 = throwable;
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (store != null) {
                if (var2_2 != null) {
                    try {
                        store.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    store.close();
                }
            }
        }
    }

    private FileStore newFileStore() throws IOException, InvalidFileStoreVersionException {
        FileStoreBuilder fileStoreBuilder = FileStoreBuilder.fileStoreBuilder(this.path.getAbsoluteFile()).withGCOptions(SegmentGCOptions.defaultGCOptions().setOffline());
        return this.mmap == null ? fileStoreBuilder.build() : fileStoreBuilder.withMemoryMapping(this.mmap).build();
    }

    public static class Builder {
        private File path;
        @CheckForNull
        private Boolean mmap;

        private Builder() {
        }

        public Builder withPath(File path) {
            this.path = (File)Preconditions.checkNotNull((Object)path);
            return this;
        }

        public Builder withMmap(@Nullable Boolean mmap) {
            this.mmap = mmap;
            return this;
        }

        public Runnable build() {
            Preconditions.checkNotNull((Object)this.path);
            return new Compact(this);
        }
    }
}

