/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import com.google.common.base.Preconditions;
import java.io.File;
import org.apache.jackrabbit.oak.segment.file.tooling.ConsistencyChecker;

public class Check
implements Runnable {
    private final File path;
    private final String journal;
    private final boolean fullTraversal;
    private final long debugInterval;
    private final long minimumBinaryLength;

    public static Builder builder() {
        return new Builder();
    }

    private Check(Builder builder) {
        this.path = builder.path;
        this.journal = builder.journal;
        this.fullTraversal = builder.fullTraversal;
        this.debugInterval = builder.debugInterval;
        this.minimumBinaryLength = builder.minimumBinaryLength;
    }

    @Override
    public void run() {
        try {
            ConsistencyChecker.checkConsistency(this.path, this.journal, this.fullTraversal, this.debugInterval, this.minimumBinaryLength);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Builder {
        private File path;
        private String journal;
        private boolean fullTraversal;
        private long debugInterval = Long.MAX_VALUE;
        private long minimumBinaryLength;

        private Builder() {
        }

        public Builder withPath(File path) {
            this.path = (File)Preconditions.checkNotNull((Object)path);
            return this;
        }

        public Builder withJournal(String journal) {
            this.journal = (String)Preconditions.checkNotNull((Object)journal);
            return this;
        }

        public Builder withFullTraversal(boolean fullTraversal) {
            this.fullTraversal = fullTraversal;
            return this;
        }

        public Builder withDebugInterval(long debugInterval) {
            Preconditions.checkArgument((debugInterval >= 0L ? 1 : 0) != 0);
            this.debugInterval = debugInterval;
            return this;
        }

        public Builder withMinimumBinaryLength(long minimumBinaryLength) {
            this.minimumBinaryLength = minimumBinaryLength;
            return this;
        }

        public Runnable build() {
            Preconditions.checkNotNull((Object)this.path);
            Preconditions.checkNotNull((Object)this.journal);
            return new Check(this);
        }
    }
}

