/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.store;

import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.StandardMBean;
import org.apache.jackrabbit.oak.segment.standby.jmx.ObservablePartnerMBean;
import org.apache.jackrabbit.oak.segment.standby.store.CommunicationPartnerMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunicationObserver {
    static final int MAX_CLIENT_STATISTICS = 10;
    private static final Logger log = LoggerFactory.getLogger(CommunicationObserver.class);
    private final Map<String, CommunicationPartnerMBean> partnerDetails = new HashMap<String, CommunicationPartnerMBean>();
    private final String id;

    public CommunicationObserver(String id) {
        this.id = id;
    }

    void unregisterCommunicationPartner(CommunicationPartnerMBean m) throws Exception {
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(m.getMBeanName());
    }

    void registerCommunicationPartner(CommunicationPartnerMBean m) throws Exception {
        ManagementFactory.getPlatformMBeanServer().registerMBean(new StandardMBean(m, ObservablePartnerMBean.class), m.getMBeanName());
    }

    private void safeUnregisterCommunicationPartner(CommunicationPartnerMBean m) {
        try {
            this.unregisterCommunicationPartner(m);
        }
        catch (Exception e) {
            log.error(String.format("Unable to unregister MBean for client %s", m.getName()), (Throwable)e);
        }
    }

    private void safeRegisterCommunicationPartner(CommunicationPartnerMBean m) {
        try {
            this.registerCommunicationPartner(m);
        }
        catch (Exception e) {
            log.error(String.format("Unable to register MBean for client %s", m.getName()), (Throwable)e);
        }
    }

    public void unregister() {
        for (CommunicationPartnerMBean m : this.partnerDetails.values()) {
            this.safeUnregisterCommunicationPartner(m);
        }
    }

    public void gotMessageFrom(String client, String request, String address, int port) throws MalformedObjectNameException {
        log.debug("Message '{}' received from client {}", (Object)request, (Object)client);
        CommunicationPartnerMBean m = this.partnerDetails.get(client);
        boolean register = false;
        if (m == null) {
            this.cleanUp();
            m = new CommunicationPartnerMBean(client);
            m.setRemoteAddress(address);
            m.setRemotePort(port);
            register = true;
        }
        m.setLastSeen(new Date());
        m.setLastRequest(request);
        this.partnerDetails.put(client, m);
        if (register) {
            this.safeRegisterCommunicationPartner(m);
        }
    }

    public void didSendSegmentBytes(String client, int size) {
        log.debug("Segment with size {} sent to client {}", (Object)size, (Object)client);
        CommunicationPartnerMBean m = this.partnerDetails.get(client);
        m.onSegmentSent(size);
        this.partnerDetails.put(client, m);
    }

    public void didSendBinariesBytes(String client, int size) {
        log.debug("Binary with size {} sent to client {}", (Object)size, (Object)client);
        CommunicationPartnerMBean m = this.partnerDetails.get(client);
        m.onBinarySent(size);
        this.partnerDetails.put(client, m);
    }

    public String getID() {
        return this.id;
    }

    private void cleanUp() {
        while (this.partnerDetails.size() >= 10) {
            CommunicationPartnerMBean oldestEntry = this.oldestEntry();
            log.info("Housekeeping: Removing statistics for client " + oldestEntry.getName());
            this.safeUnregisterCommunicationPartner(oldestEntry);
            this.partnerDetails.remove(oldestEntry.getName());
        }
    }

    private CommunicationPartnerMBean oldestEntry() {
        CommunicationPartnerMBean ret = null;
        for (CommunicationPartnerMBean m : this.partnerDetails.values()) {
            if (ret != null && !ret.getLastSeen().after(m.getLastSeen())) continue;
            ret = m;
        }
        return ret;
    }
}

