/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.server;

import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.standby.server.FileStoreUtil;
import org.apache.jackrabbit.oak.segment.standby.server.StandbySegmentReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultStandbySegmentReader
implements StandbySegmentReader {
    private static final Logger log = LoggerFactory.getLogger(DefaultStandbySegmentReader.class);
    private final FileStore store;

    DefaultStandbySegmentReader(FileStore store) {
        this.store = store;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] readSegment(String segmentId) {
        long lsb;
        UUID uuid = UUID.fromString(segmentId);
        long msb = uuid.getMostSignificantBits();
        Segment segment = FileStoreUtil.readSegmentWithRetry(this.store, this.store.newSegmentId(msb, lsb = uuid.getLeastSignificantBits()));
        if (segment == null) {
            return null;
        }
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            segment.writeTo((OutputStream)stream);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            log.warn("Error while reading segment content", (Throwable)e);
            return null;
        }
    }
}

