/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.codec;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.jackrabbit.oak.segment.standby.codec.GetBlobResponse;
import org.apache.jackrabbit.oak.segment.standby.codec.GetHeadResponse;
import org.apache.jackrabbit.oak.segment.standby.codec.GetReferencesResponse;
import org.apache.jackrabbit.oak.segment.standby.codec.GetSegmentResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseDecoder
extends ByteToMessageDecoder {
    private static final Logger log = LoggerFactory.getLogger(ResponseDecoder.class);

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int length = in.readInt();
        switch (in.readByte()) {
            case 0: {
                log.debug("Decoding 'get head' response");
                ResponseDecoder.decodeGetHeadResponse(length, in, out);
                break;
            }
            case 1: {
                log.debug("Decoding 'get segment' response");
                ResponseDecoder.decodeGetSegmentResponse(length, in, out);
                break;
            }
            case 2: {
                log.debug("Decoding 'get blob' response");
                ResponseDecoder.decodeGetBlobResponse(length, in, out);
                break;
            }
            case 3: {
                log.debug("Decoding 'get references' response");
                ResponseDecoder.decodeGetReferencesResponse(length, in, out);
                break;
            }
            default: {
                log.debug("Invalid type, dropping message");
            }
        }
    }

    private static void decodeGetHeadResponse(int length, ByteBuf in, List<Object> out) {
        byte[] data = new byte[length - 1];
        in.readBytes(data);
        String recordId = new String(data, Charsets.UTF_8);
        out.add(new GetHeadResponse(null, recordId));
    }

    private static void decodeGetSegmentResponse(int length, ByteBuf in, List<Object> out) {
        long msb = in.readLong();
        long lsb = in.readLong();
        String segmentId = new UUID(msb, lsb).toString();
        long hash = in.readLong();
        byte[] data = new byte[length - 25];
        in.readBytes(data);
        if (ResponseDecoder.hash(data) != hash) {
            log.debug("Invalid checksum, discarding segment {}", (Object)segmentId);
            return;
        }
        out.add(new GetSegmentResponse(null, segmentId, data));
    }

    private static void decodeGetBlobResponse(int length, ByteBuf in, List<Object> out) {
        int blobIdLength = in.readInt();
        byte[] blobIdBytes = new byte[blobIdLength];
        in.readBytes(blobIdBytes);
        String blobId = new String(blobIdBytes, Charsets.UTF_8);
        long hash = in.readLong();
        byte[] blobData = new byte[length - 1 - 4 - blobIdBytes.length - 8];
        in.readBytes(blobData);
        if (ResponseDecoder.hash(blobData) != hash) {
            log.debug("Invalid checksum, discarding blob {}", (Object)blobId);
            return;
        }
        out.add(new GetBlobResponse(null, blobId, blobData));
    }

    private static void decodeGetReferencesResponse(int length, ByteBuf in, List<Object> out) {
        byte[] data = new byte[length - 1];
        in.readBytes(data);
        String body = new String(data, Charsets.UTF_8);
        int colon = body.indexOf(":");
        if (colon < 0) {
            return;
        }
        String segmentId = body.substring(0, colon);
        String referencesList = body.substring(colon + 1);
        List<Object> references = referencesList.isEmpty() ? Collections.emptyList() : Arrays.asList(referencesList.split(","));
        out.add(new GetReferencesResponse(null, segmentId, references));
    }

    private static long hash(byte[] data) {
        return Hashing.murmur3_32().newHasher().putBytes(data).hash().padToLong();
    }
}

