/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.file.GCEstimation;
import org.apache.jackrabbit.oak.segment.file.GCJournal;

public class SizeDeltaGcEstimation
implements GCEstimation {
    private final long delta;
    private final GCJournal gcJournal;
    private final long totalSize;
    private boolean gcNeeded;
    private String gcInfo = "unknown";
    private boolean finished = false;

    public SizeDeltaGcEstimation(@Nonnull SegmentGCOptions opts, @Nonnull GCJournal gcJournal, long totalSize) {
        this.delta = ((SegmentGCOptions)Preconditions.checkNotNull((Object)opts)).getGcSizeDeltaEstimation();
        this.gcJournal = (GCJournal)Preconditions.checkNotNull((Object)gcJournal);
        this.totalSize = totalSize;
    }

    @Override
    public boolean gcNeeded() {
        if (!this.finished) {
            this.run();
        }
        return this.gcNeeded;
    }

    @Override
    public String gcLog() {
        if (!this.finished) {
            this.run();
        }
        return this.gcInfo;
    }

    private void run() {
        if (this.finished) {
            return;
        }
        if (this.delta == 0L) {
            this.gcNeeded = true;
            this.gcInfo = "Estimation skipped because the size delta value equals 0";
        } else if (this.getPreviousCleanupSize() < 0L) {
            this.gcNeeded = true;
            this.gcInfo = "Estimation skipped because of missing gc journal data (expected on first run)";
        } else {
            long lastGc = this.getPreviousCleanupSize();
            long gain = this.totalSize - lastGc;
            long gainP = 100L * (this.totalSize - lastGc) / lastGc;
            this.gcNeeded = gain > this.delta;
            this.gcInfo = String.format("Segmentstore size has increased since the last garbage collection from %s (%s bytes) to %s (%s bytes), an increase of %s (%s bytes) or %s%%. ", IOUtils.humanReadableByteCount((long)lastGc), lastGc, IOUtils.humanReadableByteCount((long)this.totalSize), this.totalSize, IOUtils.humanReadableByteCount((long)gain), gain, gainP);
            this.gcInfo = this.gcNeeded ? this.gcInfo + String.format("This is greater than sizeDeltaEstimation=%s (%s bytes), so running garbage collection", IOUtils.humanReadableByteCount((long)this.delta), this.delta) : this.gcInfo + String.format("This is less than sizeDeltaEstimation=%s (%s bytes), so skipping garbage collection", IOUtils.humanReadableByteCount((long)this.delta), this.delta);
        }
        this.finished = true;
    }

    private long getPreviousCleanupSize() {
        return this.gcJournal.read().getRepoSize();
    }
}

