/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentGraph;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.SegmentWriterBuilder;
import org.apache.jackrabbit.oak.segment.file.AbstractFileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyRevisions;
import org.apache.jackrabbit.oak.segment.file.TarReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyFileStore
extends AbstractFileStore {
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyFileStore.class);
    private final List<TarReader> readers;
    @Nonnull
    private final SegmentWriter writer;
    private ReadOnlyRevisions revisions;
    private RecordId currentHead;

    ReadOnlyFileStore(FileStoreBuilder builder) throws InvalidFileStoreVersionException, IOException {
        super(builder);
        Map<Integer, Map<Character, File>> map = ReadOnlyFileStore.collectFiles(this.directory);
        if (!map.isEmpty()) {
            ReadOnlyFileStore.checkManifest(this.openManifest());
        }
        this.readers = Lists.newArrayListWithCapacity((int)map.size());
        Object[] indices = map.keySet().toArray(new Integer[map.size()]);
        Arrays.sort(indices);
        for (int i = indices.length - 1; i >= 0; --i) {
            boolean recover = i == indices.length - 1;
            this.readers.add(TarReader.openRO(map.get(indices[i]), this.memoryMapping, recover, this.recovery));
        }
        this.writer = SegmentWriterBuilder.segmentWriterBuilder("read-only").withoutCache().build(this);
        log.info("TarMK ReadOnly opened: {} (mmap={})", (Object)this.directory, (Object)this.memoryMapping);
    }

    ReadOnlyFileStore bind(@Nonnull ReadOnlyRevisions revisions) throws IOException {
        this.revisions = revisions;
        this.revisions.bind(this);
        this.currentHead = revisions.getHead();
        return this;
    }

    public void setRevision(String revision) {
        RecordId newHead = RecordId.fromString(this, revision);
        if (this.revisions.setHead(this.currentHead, newHead, new Revisions.Option[0])) {
            this.currentHead = newHead;
        }
    }

    private static void includeForwardReferences(Iterable<TarReader> readers, Set<UUID> referencedIds) throws IOException {
        HashSet fRefs = Sets.newHashSet(referencedIds);
        block0: do {
            for (TarReader reader : readers) {
                reader.calculateForwardReferences(fRefs);
                if (!fRefs.isEmpty()) continue;
                continue block0;
            }
        } while (referencedIds.addAll(fRefs));
    }

    public void traverseSegmentGraph(@Nonnull Set<UUID> roots, @Nonnull SegmentGraph.SegmentGraphVisitor visitor) throws IOException {
        List<TarReader> readers = this.readers;
        ReadOnlyFileStore.includeForwardReferences(readers, roots);
        for (TarReader reader : readers) {
            reader.traverseSegmentGraph((Set)Preconditions.checkNotNull(roots), (SegmentGraph.SegmentGraphVisitor)Preconditions.checkNotNull((Object)visitor));
        }
    }

    @Override
    public void writeSegment(SegmentId id, byte[] data, int offset, int length) {
        throw new UnsupportedOperationException("Read Only Store");
    }

    @Override
    public boolean containsSegment(SegmentId id) {
        long msb = id.getMostSignificantBits();
        long lsb = id.getLeastSignificantBits();
        for (TarReader reader : this.readers) {
            if (!reader.containsEntry(msb, lsb)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public Segment readSegment(final SegmentId id) {
        try {
            return this.segmentCache.getSegment(id, new Callable<Segment>(){

                @Override
                public Segment call() throws Exception {
                    long msb = id.getMostSignificantBits();
                    long lsb = id.getLeastSignificantBits();
                    for (TarReader reader : ReadOnlyFileStore.this.readers) {
                        try {
                            ByteBuffer buffer = reader.readEntry(msb, lsb);
                            if (buffer == null) continue;
                            return new Segment(ReadOnlyFileStore.this, ReadOnlyFileStore.this.segmentReader, id, buffer);
                        }
                        catch (IOException e) {
                            log.warn("Failed to read from tar file {}", (Object)reader, (Object)e);
                        }
                    }
                    throw new SegmentNotFoundException(id);
                }
            });
        }
        catch (ExecutionException e) {
            throw e.getCause() instanceof SegmentNotFoundException ? (SegmentNotFoundException)((Object)e.getCause()) : new SegmentNotFoundException(id, e);
        }
    }

    @Override
    public void close() {
        Closer closer = Closer.create();
        for (TarReader r : this.readers) {
            closer.register((Closeable)r);
        }
        closer.register((Closeable)this.revisions);
        ReadOnlyFileStore.closeAndLogOnFail((Closeable)closer);
        System.gc();
        log.info("TarMK closed: {}", (Object)this.directory);
    }

    @Override
    @Nonnull
    public SegmentWriter getWriter() {
        return this.writer;
    }

    public Map<String, Set<UUID>> getTarReaderIndex() {
        HashMap<String, Set<UUID>> index = new HashMap<String, Set<UUID>>();
        for (TarReader reader : this.readers) {
            index.put(reader.getFile().getAbsolutePath(), reader.getUUIDs());
        }
        return index;
    }

    public Map<UUID, List<UUID>> getTarGraph(String fileName) throws IOException {
        for (TarReader reader : this.readers) {
            if (!fileName.equals(reader.getFile().getName())) continue;
            HashMap graph = Maps.newHashMap();
            for (UUID uuid : reader.getUUIDs()) {
                graph.put(uuid, null);
            }
            Map<UUID, List<UUID>> g = reader.getGraph(false);
            if (g != null) {
                graph.putAll(g);
            }
            return graph;
        }
        return Collections.emptyMap();
    }

    public Iterable<SegmentId> getSegmentIds() {
        ArrayList ids = Lists.newArrayList();
        for (TarReader reader : this.readers) {
            for (UUID uuid : reader.getUUIDs()) {
                long msb = uuid.getMostSignificantBits();
                long lsb = uuid.getLeastSignificantBits();
                ids.add(this.newSegmentId(msb, lsb));
            }
        }
        return ids;
    }

    @Override
    public ReadOnlyRevisions getRevisions() {
        return this.revisions;
    }
}

