/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCNodeWriteMonitor {
    private static final Logger log = LoggerFactory.getLogger(GCNodeWriteMonitor.class);
    public static final GCNodeWriteMonitor EMPTY = new GCNodeWriteMonitor(-1L);
    private long gcProgressLog;
    private long start = 0L;
    private long estimated = -1L;
    private long nodes;
    private boolean running = false;
    private long gcCount;

    public GCNodeWriteMonitor(long gcProgressLog) {
        this.gcProgressLog = gcProgressLog;
    }

    public synchronized void compacted() {
        ++this.nodes;
        if (this.gcProgressLog > 0L && this.nodes % this.gcProgressLog == 0L) {
            long ms = System.currentTimeMillis() - this.start;
            log.info("TarMK GC #{}: compacted {} nodes in {} ms.", new Object[]{this.gcCount, this.nodes, ms});
            this.start = System.currentTimeMillis();
        }
    }

    public synchronized void init(long gcCount, long prevSize, long prevCompactedNodes, long currentSize) {
        this.gcCount = gcCount;
        if (prevCompactedNodes > 0L) {
            this.estimated = (long)((double)currentSize / (double)prevSize * (double)prevCompactedNodes);
            log.info("TarMK GC #{}: estimated number of nodes to compact is {}, based on {} nodes compacted to {} bytes on disk in previous compaction and current size of {} bytes on disk.", new Object[]{this.gcCount, this.estimated, prevCompactedNodes, prevSize, currentSize});
        } else {
            log.info("TarMK GC #{}: unable to estimate number of nodes for compaction, missing gc history.", (Object)gcCount);
        }
        this.nodes = 0L;
        this.start = System.currentTimeMillis();
        this.running = true;
    }

    public synchronized void finished() {
        this.running = false;
    }

    public synchronized long getCompactedNodes() {
        return this.nodes;
    }

    public synchronized long getEstimatedTotal() {
        return this.estimated;
    }

    public synchronized int getEstimatedPercentage() {
        if (this.estimated > 0L) {
            if (!this.running) {
                return 100;
            }
            return Math.min((int)(100.0 * ((double)this.nodes / (double)this.estimated)), 99);
        }
        return -1;
    }

    public synchronized boolean isCompactionRunning() {
        return this.running;
    }

    public long getGcProgressLog() {
        return this.gcProgressLog;
    }

    public void setGcProgressLog(long gcProgressLog) {
        this.gcProgressLog = gcProgressLog;
    }
}

