/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.Closeable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.file.GCListener;

public class GCMemoryBarrier
implements Closeable {
    @Nonnull
    private final AtomicBoolean sufficientMemory;
    @Nonnull
    private final GCListener gcListener;
    @Nonnull
    private final SegmentGCOptions gcOptions;
    private final long gcCount;
    private final NotificationEmitter emitter;
    private final MemoryListener listener;

    public GCMemoryBarrier(@Nonnull AtomicBoolean sufficientMemory, @Nonnull GCListener gcListener, long gcCount, @Nonnull SegmentGCOptions gcOptions) {
        this.sufficientMemory = sufficientMemory;
        this.gcListener = gcListener;
        this.gcOptions = gcOptions;
        this.gcCount = gcCount;
        MemoryPoolMXBean pool = null;
        int percentage = gcOptions.getMemoryThreshold();
        if (percentage > 0 && (pool = GCMemoryBarrier.getMemoryPool()) == null) {
            gcListener.warn("TarMK GC #{}: Unable to setup monitoring of available memory.", new Object[]{gcCount});
        }
        if (pool != null) {
            this.emitter = (NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean());
            this.listener = new MemoryListener();
            this.emitter.addNotificationListener(this.listener, null, null);
            MemoryUsage usage = pool.getCollectionUsage();
            long maxMemory = usage.getMax();
            long required = maxMemory * (long)percentage / 100L;
            gcListener.info("TarMK GC #{}: setting up a listener to cancel compaction if available memory on pool '{}' drops below {}%, {} ({} bytes).", new Object[]{gcCount, pool.getName(), percentage, IOUtils.humanReadableByteCount((long)required), required});
            long warningThreshold = maxMemory - required;
            long current = pool.getCollectionUsageThreshold();
            if (current > 0L) {
                warningThreshold = Math.min(warningThreshold, current);
            }
            pool.setCollectionUsageThreshold(warningThreshold);
            this.checkMemory(usage);
        } else {
            this.emitter = null;
            this.listener = null;
            this.sufficientMemory.set(true);
        }
    }

    private static MemoryPoolMXBean getMemoryPool() {
        long maxSize = 0L;
        MemoryPoolMXBean maxPool = null;
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            long poolSize;
            if (MemoryType.HEAP != pool.getType() || !pool.isCollectionUsageThresholdSupported() || (poolSize = pool.getCollectionUsage().getMax()) <= maxSize) continue;
            maxPool = pool;
        }
        return maxPool;
    }

    private void checkMemory(MemoryUsage usage) {
        long required;
        long usedMemory;
        int percentage = this.gcOptions.getMemoryThreshold();
        long maxMemory = usage.getMax();
        long avail = maxMemory - (usedMemory = usage.getUsed());
        if (avail <= (required = maxMemory * (long)percentage / 100L)) {
            this.gcListener.warn("TarMK GC #{}: canceling compaction because available memory level {} ({} bytes) is too low, expecting at least {} ({} bytes)", new Object[]{this.gcCount, IOUtils.humanReadableByteCount((long)avail), avail, IOUtils.humanReadableByteCount((long)required), required});
            this.sufficientMemory.set(false);
        } else {
            this.gcListener.info("TarMK GC #{}: available memory level {} ({} bytes) is good, expecting at least {} ({} bytes)", new Object[]{this.gcCount, IOUtils.humanReadableByteCount((long)avail), avail, IOUtils.humanReadableByteCount((long)required), required});
            this.sufficientMemory.set(true);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.emitter != null && this.listener != null) {
            try {
                this.emitter.removeNotificationListener(this.listener);
            }
            catch (ListenerNotFoundException listenerNotFoundException) {
                // empty catch block
            }
        }
    }

    private class MemoryListener
    implements NotificationListener {
        private MemoryListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (notification.getType().equals("java.management.memory.collection.threshold.exceeded") && GCMemoryBarrier.this.sufficientMemory.get()) {
                CompositeData cd = (CompositeData)notification.getUserData();
                MemoryNotificationInfo info = MemoryNotificationInfo.from(cd);
                GCMemoryBarrier.this.checkMemory(info.getUsage());
            }
        }
    }
}

