/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.segment.MapEntry;
import org.apache.jackrabbit.oak.segment.MapRecord;
import org.apache.jackrabbit.oak.segment.NodeCache;
import org.apache.jackrabbit.oak.segment.PropertyTemplate;
import org.apache.jackrabbit.oak.segment.Record;
import org.apache.jackrabbit.oak.segment.RecordCache;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.RecordWriters;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentBlob;
import org.apache.jackrabbit.oak.segment.SegmentBufferWriter;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.segment.SegmentPropertyState;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.SegmentStream;
import org.apache.jackrabbit.oak.segment.Template;
import org.apache.jackrabbit.oak.segment.WriteOperationHandler;
import org.apache.jackrabbit.oak.segment.WriterCacheManager;
import org.apache.jackrabbit.oak.segment.file.GCNodeWriteMonitor;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SegmentWriter.class);
    static final int BLOCK_SIZE = 4096;
    @Nonnull
    private final WriterCacheManager cacheManager;
    @Nonnull
    private final SegmentStore store;
    @Nonnull
    private final SegmentReader reader;
    @CheckForNull
    private final BlobStore blobStore;
    @Nonnull
    private final WriteOperationHandler writeOperationHandler;
    @Nonnull
    private GCNodeWriteMonitor compactionMonitor = GCNodeWriteMonitor.EMPTY;

    public SegmentWriter(@Nonnull SegmentStore store, @Nonnull SegmentReader reader, @Nullable BlobStore blobStore, @Nonnull WriterCacheManager cacheManager, @Nonnull WriteOperationHandler writeOperationHandler) {
        this.store = (SegmentStore)Preconditions.checkNotNull((Object)store);
        this.reader = (SegmentReader)Preconditions.checkNotNull((Object)reader);
        this.blobStore = blobStore;
        this.cacheManager = (WriterCacheManager)Preconditions.checkNotNull((Object)cacheManager);
        this.writeOperationHandler = (WriteOperationHandler)Preconditions.checkNotNull((Object)writeOperationHandler);
    }

    @CheckForNull
    public String getNodeCacheOccupancyInfo() {
        return this.cacheManager.getNodeCacheOccupancyInfo();
    }

    public void flush() throws IOException {
        this.writeOperationHandler.flush();
    }

    @CheckForNull
    public CacheStatsMBean getStringCacheStats() {
        return this.cacheManager.getStringCacheStats();
    }

    @CheckForNull
    public CacheStatsMBean getTemplateCacheStats() {
        return this.cacheManager.getTemplateCacheStats();
    }

    @CheckForNull
    public CacheStatsMBean getNodeCacheStats() {
        return this.cacheManager.getNodeCacheStats();
    }

    @Nonnull
    public MapRecord writeMap(final @Nullable MapRecord base, final @Nonnull Map<String, RecordId> changes) throws IOException {
        RecordId mapId = this.writeOperationHandler.execute(new SegmentWriteOperation(){

            @Override
            @Nonnull
            public RecordId execute(@Nonnull SegmentBufferWriter writer) throws IOException {
                return this.with(writer).writeMap(base, changes);
            }
        });
        return new MapRecord(this.reader, mapId);
    }

    @Nonnull
    public RecordId writeList(final @Nonnull List<RecordId> list) throws IOException {
        return this.writeOperationHandler.execute(new SegmentWriteOperation(){

            @Override
            @Nonnull
            public RecordId execute(@Nonnull SegmentBufferWriter writer) throws IOException {
                return this.with(writer).writeList(list);
            }
        });
    }

    @Nonnull
    public RecordId writeString(final @Nonnull String string) throws IOException {
        return this.writeOperationHandler.execute(new SegmentWriteOperation(){

            @Override
            @Nonnull
            public RecordId execute(@Nonnull SegmentBufferWriter writer) throws IOException {
                return this.with(writer).writeString(string);
            }
        });
    }

    @Nonnull
    public SegmentBlob writeBlob(final @Nonnull Blob blob) throws IOException {
        RecordId blobId = this.writeOperationHandler.execute(new SegmentWriteOperation(){

            @Override
            @Nonnull
            public RecordId execute(@Nonnull SegmentBufferWriter writer) throws IOException {
                return this.with(writer).writeBlob(blob);
            }
        });
        return new SegmentBlob(this.blobStore, blobId);
    }

    @Nonnull
    public RecordId writeBlock(final @Nonnull byte[] bytes, final int offset, final int length) throws IOException {
        return this.writeOperationHandler.execute(new SegmentWriteOperation(){

            @Override
            @Nonnull
            public RecordId execute(@Nonnull SegmentBufferWriter writer) throws IOException {
                return this.with(writer).writeBlock(bytes, offset, length);
            }
        });
    }

    @Nonnull
    public SegmentBlob writeStream(final @Nonnull InputStream stream) throws IOException {
        RecordId blobId = this.writeOperationHandler.execute(new SegmentWriteOperation(){

            @Override
            @Nonnull
            public RecordId execute(@Nonnull SegmentBufferWriter writer) throws IOException {
                return this.with(writer).writeStream(stream);
            }
        });
        return new SegmentBlob(this.blobStore, blobId);
    }

    @Nonnull
    public SegmentPropertyState writeProperty(final @Nonnull PropertyState state) throws IOException {
        RecordId id = this.writeOperationHandler.execute(new SegmentWriteOperation(){

            @Override
            @Nonnull
            public RecordId execute(@Nonnull SegmentBufferWriter writer) throws IOException {
                return this.with(writer).writeProperty(state);
            }
        });
        return new SegmentPropertyState(this.reader, id, state.getName(), state.getType());
    }

    @Nonnull
    public SegmentNodeState writeNode(final @Nonnull NodeState state) throws IOException {
        RecordId nodeId = this.writeOperationHandler.execute(new SegmentWriteOperation(){

            @Override
            @Nonnull
            public RecordId execute(@Nonnull SegmentBufferWriter writer) throws IOException {
                return this.with(writer).writeNode(state);
            }
        });
        return new SegmentNodeState(this.reader, this, nodeId);
    }

    @CheckForNull
    public SegmentNodeState writeNode(final @Nonnull NodeState state, @Nonnull Supplier<Boolean> cancel) throws IOException {
        try {
            RecordId nodeId = this.writeOperationHandler.execute(new SegmentWriteOperation(cancel){

                @Override
                @Nonnull
                public RecordId execute(@Nonnull SegmentBufferWriter writer) throws IOException {
                    return this.with(writer).writeNode(state);
                }
            });
            return new SegmentNodeState(this.reader, this, nodeId);
        }
        catch (SegmentWriteOperation.CancelledWriteException ignore) {
            return null;
        }
    }

    public void setCompactionMonitor(@Nonnull GCNodeWriteMonitor compactionMonitor) {
        this.compactionMonitor = compactionMonitor;
    }

    private abstract class SegmentWriteOperation
    implements WriteOperationHandler.WriteOperation {
        @Nonnull
        private final Supplier<Boolean> cancel;
        @CheckForNull
        private NodeWriteStats nodeWriteStats;
        private SegmentBufferWriter writer;
        private RecordCache<String> stringCache;
        private RecordCache<Template> templateCache;
        private NodeCache nodeCache;

        protected SegmentWriteOperation(Supplier<Boolean> cancel) {
            this.cancel = cancel;
        }

        protected SegmentWriteOperation() {
            this((Supplier<Boolean>)Suppliers.ofInstance((Object)false));
        }

        @Override
        @Nonnull
        public abstract RecordId execute(@Nonnull SegmentBufferWriter var1) throws IOException;

        @Nonnull
        SegmentWriteOperation with(@Nonnull SegmentBufferWriter writer) {
            Preconditions.checkState((this.writer == null ? 1 : 0) != 0);
            this.writer = writer;
            int generation = writer.getGeneration();
            this.stringCache = SegmentWriter.this.cacheManager.getStringCache(generation);
            this.templateCache = SegmentWriter.this.cacheManager.getTemplateCache(generation);
            this.nodeCache = SegmentWriter.this.cacheManager.getNodeCache(generation);
            return this;
        }

        private RecordId writeMap(@Nullable MapRecord base, @Nonnull Map<String, RecordId> changes) throws IOException {
            MapEntry mapEntry;
            Map.Entry<String, RecordId> change;
            RecordId value;
            if (base != null && base.isDiff()) {
                Segment segment = base.getSegment();
                RecordId key = segment.readRecordId(base.getRecordNumber(), 8);
                String string = SegmentWriter.this.reader.readString(key);
                if (!changes.containsKey(string)) {
                    changes.put(string, segment.readRecordId(base.getRecordNumber(), 8, 1));
                }
                base = new MapRecord(SegmentWriter.this.reader, segment.readRecordId(base.getRecordNumber(), 8, 2));
            }
            if (base != null && changes.size() == 1 && (value = (change = changes.entrySet().iterator().next()).getValue()) != null && (mapEntry = base.getEntry(change.getKey())) != null) {
                if (value.equals(mapEntry.getValue())) {
                    return base.getRecordId();
                }
                return RecordWriters.newMapBranchWriter(mapEntry.getHash(), Arrays.asList(mapEntry.getKey(), value, base.getRecordId())).write(this.writer);
            }
            ArrayList entries = Lists.newArrayList();
            for (Map.Entry<String, RecordId> entry : changes.entrySet()) {
                MapEntry e;
                String key = entry.getKey();
                RecordId keyId = null;
                if (base != null && (e = base.getEntry(key)) != null) {
                    keyId = e.getKey();
                }
                if (keyId == null && entry.getValue() != null) {
                    keyId = this.writeString(key);
                }
                if (keyId == null) continue;
                entries.add(new MapEntry(SegmentWriter.this.reader, key, keyId, entry.getValue()));
            }
            return this.writeMapBucket(base, entries, 0);
        }

        private RecordId writeMapLeaf(int level, Collection<MapEntry> entries) throws IOException {
            Preconditions.checkNotNull(entries);
            int size = entries.size();
            Preconditions.checkElementIndex((int)size, (int)MapRecord.MAX_SIZE);
            Preconditions.checkPositionIndex((int)level, (int)7);
            Preconditions.checkArgument((size != 0 || level == 7 ? 1 : 0) != 0);
            return RecordWriters.newMapLeafWriter(level, entries).write(this.writer);
        }

        private RecordId writeMapBranch(int level, int size, MapRecord ... buckets) throws IOException {
            int bitmap = 0;
            ArrayList bucketIds = Lists.newArrayListWithCapacity((int)buckets.length);
            for (int i = 0; i < buckets.length; ++i) {
                if (buckets[i] == null) continue;
                bitmap = (int)((long)bitmap | 1L << i);
                bucketIds.add(buckets[i].getRecordId());
            }
            return RecordWriters.newMapBranchWriter(level, size, bitmap, bucketIds).write(this.writer);
        }

        private RecordId writeMapBucket(MapRecord base, Collection<MapEntry> entries, int level) throws IOException {
            if (entries == null || entries.isEmpty()) {
                if (base != null) {
                    return base.getRecordId();
                }
                if (level == 0) {
                    return RecordWriters.newMapLeafWriter().write(this.writer);
                }
                return null;
            }
            if (base == null) {
                if (entries.size() <= 32 || level == 7) {
                    return this.writeMapLeaf(level, entries);
                }
                MapRecord[] buckets = new MapRecord[32];
                List<List<MapEntry>> changes = this.splitToBuckets(entries, level);
                for (int i = 0; i < 32; ++i) {
                    buckets[i] = this.mapRecordOrNull(this.writeMapBucket(null, (Collection<MapEntry>)changes.get(i), level + 1));
                }
                return this.writeMapBranch(level, entries.size(), buckets);
            }
            if (base.isLeaf()) {
                HashMap map = Maps.newHashMap();
                for (MapEntry entry : base.getEntries()) {
                    map.put(entry.getName(), entry);
                }
                for (MapEntry entry : entries) {
                    if (entry.getValue() != null) {
                        map.put(entry.getName(), entry);
                        continue;
                    }
                    map.remove(entry.getName());
                }
                return this.writeMapBucket(null, map.values(), level);
            }
            int newSize = 0;
            int newCount = 0;
            MapRecord[] buckets = base.getBuckets();
            List<List<MapEntry>> changes = this.splitToBuckets(entries, level);
            for (int i = 0; i < 32; ++i) {
                buckets[i] = this.mapRecordOrNull(this.writeMapBucket(buckets[i], (Collection<MapEntry>)changes.get(i), level + 1));
                if (buckets[i] == null) continue;
                newSize += buckets[i].size();
                ++newCount;
            }
            if (newSize > 32) {
                return this.writeMapBranch(level, newSize, buckets);
            }
            if (newCount <= 1) {
                for (MapRecord bucket : buckets) {
                    if (bucket == null) continue;
                    return bucket.getRecordId();
                }
                return this.writeMapBucket(null, null, level);
            }
            ArrayList list = Lists.newArrayList();
            for (MapRecord bucket : buckets) {
                if (bucket == null) continue;
                Iterables.addAll((Collection)list, bucket.getEntries());
            }
            return this.writeMapLeaf(level, list);
        }

        private MapRecord mapRecordOrNull(RecordId id) {
            return id == null ? null : new MapRecord(SegmentWriter.this.reader, id);
        }

        private RecordId writeList(@Nonnull List<RecordId> list) throws IOException {
            Preconditions.checkNotNull(list);
            Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0);
            ArrayList thisLevel = list;
            while (thisLevel.size() > 1) {
                ArrayList nextLevel = Lists.newArrayList();
                for (List bucket : Lists.partition(thisLevel, (int)255)) {
                    if (bucket.size() > 1) {
                        nextLevel.add(this.writeListBucket(bucket));
                        continue;
                    }
                    nextLevel.add(bucket.get(0));
                }
                thisLevel = nextLevel;
            }
            return thisLevel.iterator().next();
        }

        private RecordId writeListBucket(List<RecordId> bucket) throws IOException {
            Preconditions.checkArgument((bucket.size() > 1 ? 1 : 0) != 0);
            return RecordWriters.newListBucketWriter(bucket).write(this.writer);
        }

        private List<List<MapEntry>> splitToBuckets(Collection<MapEntry> entries, int level) {
            int mask = 31;
            int shift = 32 - (level + 1) * 5;
            ArrayList buckets = Lists.newArrayList(Collections.nCopies(32, null));
            for (MapEntry entry : entries) {
                int index = entry.getHash() >> shift & mask;
                List bucket = (List)buckets.get(index);
                if (bucket == null) {
                    bucket = Lists.newArrayList();
                    buckets.set(index, bucket);
                }
                bucket.add(entry);
            }
            return buckets;
        }

        private RecordId writeValueRecord(long length, RecordId blocks) throws IOException {
            long len = length - 16512L | 0xC000000000000000L;
            return RecordWriters.newValueWriter(blocks, len).write(this.writer);
        }

        private RecordId writeValueRecord(int length, byte ... data) throws IOException {
            Preconditions.checkArgument((length < 16512 ? 1 : 0) != 0);
            return RecordWriters.newValueWriter(length, data).write(this.writer);
        }

        private RecordId writeString(@Nonnull String string) throws IOException {
            RecordId id = this.stringCache.get(string);
            if (id != null) {
                return id;
            }
            byte[] data = string.getBytes(Charsets.UTF_8);
            if (data.length < 16512) {
                id = this.writeValueRecord(data.length, data);
                this.stringCache.put(string, id);
                return id;
            }
            int pos = 0;
            ArrayList blockIds = Lists.newArrayListWithExpectedSize((int)(data.length / 4096 + 1));
            while (pos + 262144 <= data.length) {
                SegmentId bulkId = SegmentWriter.this.store.newBulkSegmentId();
                SegmentWriter.this.store.writeSegment(bulkId, data, pos, 262144);
                for (int i = 0; i < 262144; i += 4096) {
                    blockIds.add(new RecordId(bulkId, i));
                }
                pos += 262144;
            }
            while (pos < data.length) {
                int len = Math.min(4096, data.length - pos);
                blockIds.add(this.writeBlock(data, pos, len));
                pos += len;
            }
            return this.writeValueRecord((long)data.length, this.writeList(blockIds));
        }

        private boolean sameStore(SegmentId id) {
            return id.sameStore(SegmentWriter.this.store);
        }

        private boolean sameStore(Blob blob) {
            return blob instanceof SegmentBlob && this.sameStore(((Record)blob).getRecordId().getSegmentId());
        }

        private RecordId writeBlob(@Nonnull Blob blob) throws IOException {
            String reference;
            if (this.sameStore(blob)) {
                SegmentBlob segmentBlob = (SegmentBlob)blob;
                if (!this.isOldGeneration(segmentBlob.getRecordId())) {
                    return segmentBlob.getRecordId();
                }
                if (segmentBlob.isExternal()) {
                    return this.writeBlobId(segmentBlob.getBlobId());
                }
            }
            if ((reference = blob.getReference()) != null && SegmentWriter.this.blobStore != null) {
                String blobId = SegmentWriter.this.blobStore.getBlobId(reference);
                if (blobId != null) {
                    return this.writeBlobId(blobId);
                }
                LOG.debug("No blob found for reference {}, inlining...", (Object)reference);
            }
            return this.writeStream(blob.getNewStream());
        }

        private RecordId writeBlobId(String blobId) throws IOException {
            RecordId recordId;
            byte[] data = blobId.getBytes(Charsets.UTF_8);
            if (data.length < 4096) {
                recordId = RecordWriters.newBlobIdWriter(data).write(this.writer);
            } else {
                RecordId refId = this.writeString(blobId);
                recordId = RecordWriters.newBlobIdWriter(refId).write(this.writer);
            }
            return recordId;
        }

        private RecordId writeBlock(@Nonnull byte[] bytes, int offset, int length) throws IOException {
            Preconditions.checkNotNull((Object)bytes);
            Preconditions.checkPositionIndexes((int)offset, (int)(offset + length), (int)bytes.length);
            return RecordWriters.newBlockWriter(bytes, offset, length).write(this.writer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RecordId writeStream(@Nonnull InputStream stream) throws IOException {
            boolean threw = true;
            try {
                RecordId id = SegmentStream.getRecordIdIfAvailable(stream, SegmentWriter.this.store);
                if (id == null) {
                    id = this.internalWriteStream(stream);
                } else if (this.isOldGeneration(id)) {
                    SegmentStream segmentStream = (SegmentStream)stream;
                    List<RecordId> blockIds = segmentStream.getBlockIds();
                    if (blockIds == null) {
                        RecordId recordId = this.internalWriteStream(stream);
                        return recordId;
                    }
                    RecordId recordId = this.writeValueRecord(segmentStream.getLength(), this.writeList(blockIds));
                    return recordId;
                }
                threw = false;
                RecordId recordId = id;
                return recordId;
            }
            finally {
                Closeables.close((Closeable)stream, (boolean)threw);
            }
        }

        private RecordId internalWriteStream(@Nonnull InputStream stream) throws IOException {
            byte[] data = new byte[16512];
            int n = ByteStreams.read((InputStream)stream, (byte[])data, (int)0, (int)data.length);
            if (n < 16512) {
                return this.writeValueRecord(n, data);
            }
            if (SegmentWriter.this.blobStore != null) {
                String blobId = SegmentWriter.this.blobStore.writeBlob((InputStream)new SequenceInputStream(new ByteArrayInputStream(data, 0, n), stream));
                return this.writeBlobId(blobId);
            }
            data = Arrays.copyOf(data, 262144);
            n += ByteStreams.read((InputStream)stream, (byte[])data, (int)n, (int)(262144 - n));
            long length = n;
            ArrayList blockIds = Lists.newArrayListWithExpectedSize((int)(2 * n / 4096));
            while (n != 0) {
                SegmentId bulkId = SegmentWriter.this.store.newBulkSegmentId();
                LOG.debug("Writing bulk segment {} ({} bytes)", (Object)bulkId, (Object)n);
                SegmentWriter.this.store.writeSegment(bulkId, data, 0, n);
                for (int i = 0; i < n; i += 4096) {
                    blockIds.add(new RecordId(bulkId, data.length - n + i));
                }
                n = ByteStreams.read((InputStream)stream, (byte[])data, (int)0, (int)data.length);
                length += (long)n;
            }
            return this.writeValueRecord(length, this.writeList(blockIds));
        }

        private RecordId writeProperty(@Nonnull PropertyState state) throws IOException {
            Map<String, RecordId> previousValues = Collections.emptyMap();
            return this.writeProperty(state, previousValues);
        }

        private RecordId writeProperty(@Nonnull PropertyState state, @Nonnull Map<String, RecordId> previousValues) throws IOException {
            Type type = state.getType();
            int count = state.count();
            ArrayList valueIds = Lists.newArrayList();
            for (int i = 0; i < count; ++i) {
                if (type.tag() == 2) {
                    try {
                        valueIds.add(this.writeBlob((Blob)state.getValue(Type.BINARY, i)));
                        continue;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Unexpected IOException", e);
                    }
                }
                String value = (String)state.getValue(Type.STRING, i);
                RecordId valueId = previousValues.get(value);
                if (valueId == null) {
                    valueId = this.writeString(value);
                }
                valueIds.add(valueId);
            }
            if (!type.isArray()) {
                return (RecordId)valueIds.iterator().next();
            }
            if (count == 0) {
                return RecordWriters.newListWriter().write(this.writer);
            }
            return RecordWriters.newListWriter(count, this.writeList(valueIds)).write(this.writer);
        }

        private RecordId writeTemplate(Template template) throws IOException {
            Preconditions.checkNotNull((Object)template);
            RecordId id = this.templateCache.get(template);
            if (id != null) {
                return id;
            }
            ArrayList ids = Lists.newArrayList();
            int head = 0;
            RecordId primaryId = null;
            PropertyState primaryType = template.getPrimaryType();
            if (primaryType != null) {
                head |= Integer.MIN_VALUE;
                primaryId = this.writeString((String)primaryType.getValue(Type.NAME));
                ids.add(primaryId);
            }
            ArrayList mixinIds = null;
            PropertyState mixinTypes = template.getMixinTypes();
            if (mixinTypes != null) {
                head |= 0x40000000;
                mixinIds = Lists.newArrayList();
                for (String mixin : (Iterable)mixinTypes.getValue(Type.NAMES)) {
                    mixinIds.add(this.writeString(mixin));
                }
                ids.addAll(mixinIds);
                Preconditions.checkState((mixinIds.size() < 1024 ? 1 : 0) != 0);
                head |= mixinIds.size() << 18;
            }
            RecordId childNameId = null;
            String childName = template.getChildName();
            if (childName == Template.ZERO_CHILD_NODES) {
                head |= 0x20000000;
            } else if (childName == "") {
                head |= 0x10000000;
            } else {
                childNameId = this.writeString(childName);
                ids.add(childNameId);
            }
            PropertyTemplate[] properties = template.getPropertyTemplates();
            RecordId[] propertyNames = new RecordId[properties.length];
            byte[] propertyTypes = new byte[properties.length];
            for (int i = 0; i < properties.length; ++i) {
                propertyNames[i] = this.writeString(properties[i].getName());
                Type<?> type = properties[i].getType();
                propertyTypes[i] = type.isArray() ? (byte)(-type.tag()) : (byte)type.tag();
            }
            RecordId propNamesId = null;
            if (propertyNames.length > 0) {
                propNamesId = this.writeList(Arrays.asList(propertyNames));
                ids.add(propNamesId);
            }
            Preconditions.checkState((propertyNames.length < 262144 ? 1 : 0) != 0);
            RecordId tid = RecordWriters.newTemplateWriter(ids, propertyNames, propertyTypes, head |= propertyNames.length, primaryId, mixinIds, childNameId, propNamesId).write(this.writer);
            this.templateCache.put(template, tid);
            return tid;
        }

        private RecordId writeNode(@Nonnull NodeState state) throws IOException {
            this.nodeWriteStats = new NodeWriteStats();
            try {
                RecordId recordId = this.writeNode(state, 0);
                return recordId;
            }
            finally {
                LOG.debug("{}", (Object)this.nodeWriteStats);
            }
        }

        private RecordId writeNode(@Nonnull NodeState state, int depth) throws IOException {
            if (((Boolean)this.cancel.get()).booleanValue()) {
                throw new CancelledWriteException();
            }
            Preconditions.checkState((this.nodeWriteStats != null ? 1 : 0) != 0);
            ++this.nodeWriteStats.nodeCount;
            RecordId compactedId = this.deduplicateNode(state, this.nodeWriteStats);
            if (compactedId != null) {
                return compactedId;
            }
            ++this.nodeWriteStats.writesOps;
            RecordId recordId = this.writeNodeUncached(state, depth);
            if (state instanceof SegmentNodeState) {
                SegmentNodeState sns = (SegmentNodeState)state;
                this.nodeCache.put(sns.getStableId(), recordId, this.cost(sns));
                this.nodeWriteStats.isCompactOp = true;
                SegmentWriter.this.compactionMonitor.compacted();
            }
            return recordId;
        }

        private byte cost(SegmentNodeState node) {
            long childCount = node.getChildNodeCount(Long.MAX_VALUE);
            return (byte)(-64 - Long.numberOfLeadingZeros(childCount));
        }

        /*
         * WARNING - void declaration
         */
        private RecordId writeNodeUncached(@Nonnull NodeState state, int depth) throws IOException {
            void var11_17;
            ModifiedNodeState after = null;
            if (state instanceof ModifiedNodeState) {
                after = (ModifiedNodeState)state;
            }
            RecordId beforeId = null;
            if (after != null) {
                beforeId = this.deduplicateNode(after.getBaseState(), null);
            }
            SegmentNodeState before = null;
            Template beforeTemplate = null;
            if (beforeId != null) {
                before = SegmentWriter.this.reader.readNode(beforeId);
                beforeTemplate = before.getTemplate();
            }
            ArrayList ids = Lists.newArrayList();
            Template template = new Template(SegmentWriter.this.reader, state);
            if (template.equals(beforeTemplate)) {
                ids.add(before.getTemplateId());
            } else {
                ids.add(this.writeTemplate(template));
            }
            String childName = template.getChildName();
            if (childName == "") {
                void var11_13;
                MapRecord base;
                if (before != null && before.getChildNodeCount(2L) > 1L && after.getChildNodeCount(2L) > 1L) {
                    base = before.getChildNodeMap();
                    Map<String, RecordId> map = new ChildNodeCollectorDiff(depth).diff(before, after);
                } else {
                    base = null;
                    HashMap hashMap = Maps.newHashMap();
                    for (ChildNodeEntry entry : state.getChildNodeEntries()) {
                        hashMap.put(entry.getName(), this.writeNode(entry.getNodeState(), depth + 1));
                    }
                }
                ids.add(this.writeMap(base, (Map<String, RecordId>)var11_13));
            } else if (childName != Template.ZERO_CHILD_NODES) {
                ids.add(this.writeNode(state.getChildNode(template.getChildName()), depth + 1));
            }
            ArrayList pIds = Lists.newArrayList();
            for (PropertyTemplate pt : template.getPropertyTemplates()) {
                PropertyState beforeProperty;
                String name = pt.getName();
                PropertyState property = state.getProperty(name);
                assert (property != null);
                if (before != null && property.equals(beforeProperty = before.getProperty(name))) {
                    property = beforeProperty;
                }
                if (this.sameStore(property)) {
                    RecordId pid = ((Record)property).getRecordId();
                    if (this.isOldGeneration(pid)) {
                        pIds.add(this.writeProperty(property));
                        continue;
                    }
                    pIds.add(pid);
                    continue;
                }
                if (before == null || !this.sameStore(before)) {
                    pIds.add(this.writeProperty(property));
                    continue;
                }
                PropertyTemplate bt = beforeTemplate.getPropertyTemplate(name);
                if (bt == null) {
                    pIds.add(this.writeProperty(property));
                    continue;
                }
                SegmentPropertyState bp = beforeTemplate.getProperty(before.getRecordId(), bt.getIndex());
                if (property.equals(bp)) {
                    pIds.add(bp.getRecordId());
                    continue;
                }
                if (bp.isArray() && bp.getType() != Type.BINARIES) {
                    pIds.add(this.writeProperty(property, bp.getValueRecords()));
                    continue;
                }
                pIds.add(this.writeProperty(property));
            }
            if (!pIds.isEmpty()) {
                ids.add(this.writeList(pIds));
            }
            Object var11_15 = null;
            if (state instanceof SegmentNodeState) {
                byte[] id = ((SegmentNodeState)state).getStableIdBytes();
                RecordId recordId = this.writeBlock(id, 0, id.length);
            }
            return RecordWriters.newNodeStateWriter((RecordId)var11_17, ids).write(this.writer);
        }

        private RecordId deduplicateNode(@Nonnull NodeState node, @CheckForNull NodeWriteStats nodeWriteStats) {
            if (!(node instanceof SegmentNodeState)) {
                return null;
            }
            SegmentNodeState sns = (SegmentNodeState)node;
            if (!this.sameStore(sns)) {
                return null;
            }
            if (!this.isOldGeneration(sns.getRecordId())) {
                if (nodeWriteStats != null) {
                    ++nodeWriteStats.deDupNodes;
                }
                return sns.getRecordId();
            }
            RecordId compacted = this.nodeCache.get(sns.getStableId());
            if (nodeWriteStats != null) {
                if (compacted == null) {
                    ++nodeWriteStats.cacheMiss;
                } else {
                    ++nodeWriteStats.cacheHits;
                }
            }
            return compacted;
        }

        private boolean sameStore(SegmentNodeState node) {
            return this.sameStore(node.getRecordId().getSegmentId());
        }

        private boolean sameStore(PropertyState property) {
            return property instanceof SegmentPropertyState && this.sameStore(((Record)property).getRecordId().getSegmentId());
        }

        private boolean isOldGeneration(RecordId id) {
            try {
                int thatGen = id.getSegmentId().getGcGeneration();
                int thisGen = this.writer.getGeneration();
                return thatGen < thisGen;
            }
            catch (SegmentNotFoundException snfe) {
                throw new SegmentNotFoundException("Cannot copy record from a generation that has been gc'ed already", snfe);
            }
        }

        private class ChildNodeCollectorDiff
        extends DefaultNodeStateDiff {
            private final int depth;
            private final Map<String, RecordId> childNodes = Maps.newHashMap();
            private IOException exception;

            private ChildNodeCollectorDiff(int depth) {
                this.depth = depth;
            }

            public Map<String, RecordId> diff(SegmentNodeState before, ModifiedNodeState after) throws IOException {
                after.compareAgainstBaseState((NodeState)before, (NodeStateDiff)this);
                if (this.exception != null) {
                    throw new IOException(this.exception);
                }
                return this.childNodes;
            }

            public boolean childNodeAdded(String name, NodeState after) {
                try {
                    this.childNodes.put(name, SegmentWriteOperation.this.writeNode(after, this.depth + 1));
                }
                catch (IOException e) {
                    this.exception = e;
                    return false;
                }
                return true;
            }

            public boolean childNodeChanged(String name, NodeState before, NodeState after) {
                try {
                    this.childNodes.put(name, SegmentWriteOperation.this.writeNode(after, this.depth + 1));
                }
                catch (IOException e) {
                    this.exception = e;
                    return false;
                }
                return true;
            }

            public boolean childNodeDeleted(String name, NodeState before) {
                this.childNodes.put(name, null);
                return true;
            }
        }

        private class CancelledWriteException
        extends IOException {
            public CancelledWriteException() {
                super("Cancelled write operation");
            }
        }

        private class NodeWriteStats {
            public int nodeCount;
            public int cacheHits;
            public int cacheMiss;
            public int deDupNodes;
            public int writesOps;
            boolean isCompactOp;

            private NodeWriteStats() {
            }

            public String toString() {
                return "NodeStats{op=" + (this.isCompactOp ? "compact" : "write") + ", nodeCount=" + this.nodeCount + ", writeOps=" + this.writesOps + ", deDupNodes=" + this.deDupNodes + ", cacheHits=" + this.cacheHits + ", cacheMiss=" + this.cacheMiss + ", hitRate=" + 100.0 * (double)this.cacheHits / ((double)this.cacheHits + (double)this.cacheMiss) + '}';
            }
        }
    }
}

