/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentIdFactory;
import org.apache.jackrabbit.oak.segment.SegmentIdTable;

public class SegmentTracker {
    private static final long MSB_MASK = -61441L;
    private static final long VERSION = 16384L;
    private static final long LSB_MASK = 0xFFFFFFFFFFFFFFFL;
    private static final long DATA = -6917529027641081856L;
    private static final long BULK = -5764607523034234880L;
    @Nonnull
    private final SecureRandom random = new SecureRandom();
    @Nonnull
    private final SegmentIdTable[] tables = new SegmentIdTable[32];
    @Nonnull
    private final AtomicInteger segmentCounter = new AtomicInteger();

    public SegmentTracker() {
        for (int i = 0; i < this.tables.length; ++i) {
            this.tables[i] = new SegmentIdTable();
        }
    }

    public Supplier<Integer> getSegmentCounter() {
        return new Supplier<Integer>(){

            public Integer get() {
                return SegmentTracker.this.segmentCounter.get();
            }
        };
    }

    public synchronized Set<SegmentId> getReferencedSegmentIds() {
        HashSet ids = Sets.newHashSet();
        for (SegmentIdTable table : this.tables) {
            table.collectReferencedIds(ids);
        }
        return ids;
    }

    @Nonnull
    public SegmentId newSegmentId(long msb, long lsb, SegmentIdFactory maker) {
        int index = (int)msb & this.tables.length - 1;
        return this.tables[index].newSegmentId(msb, lsb, maker);
    }

    @Nonnull
    public SegmentId newDataSegmentId(SegmentIdFactory maker) {
        return this.newSegmentId(-6917529027641081856L, maker);
    }

    @Nonnull
    public SegmentId newBulkSegmentId(SegmentIdFactory maker) {
        return this.newSegmentId(-5764607523034234880L, maker);
    }

    @Nonnull
    private SegmentId newSegmentId(long type, SegmentIdFactory maker) {
        this.segmentCounter.incrementAndGet();
        long msb = this.random.nextLong() & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        long lsb = this.random.nextLong() & 0xFFFFFFFFFFFFFFFL | type;
        return this.newSegmentId(msb, lsb, maker);
    }

    public synchronized void clearSegmentIdTables(@Nonnull Set<UUID> reclaimed, @Nonnull String gcInfo) {
        for (SegmentIdTable table : this.tables) {
            table.clearSegmentIdTables(reclaimed, gcInfo);
        }
    }
}

