/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.util.concurrent.TimeUnit;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreMonitor;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreStatsMBean;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.apache.jackrabbit.stats.TimeSeriesStatsUtil;

public class SegmentNodeStoreStats
implements SegmentNodeStoreStatsMBean,
SegmentNodeStoreMonitor {
    public static final String COMMITS_COUNT = "COMMITS_COUNT";
    public static final String COMMIT_QUEUE_SIZE = "COMMIT_QUEUE_SIZE";
    public static final String COMMIT_TIME = "COMMIT_TIME";
    public static final String QUEUEING_TIME = "QUEUEING_TIME";
    private final StatisticsProvider statisticsProvider;
    private final MeterStats commitsCount;
    private final CounterStats commitQueueSize;
    private final TimerStats commitTime;
    private final TimerStats queueingTime;

    public SegmentNodeStoreStats(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
        this.commitsCount = statisticsProvider.getMeter(COMMITS_COUNT, StatsOptions.DEFAULT);
        this.commitQueueSize = statisticsProvider.getCounterStats(COMMIT_QUEUE_SIZE, StatsOptions.DEFAULT);
        this.commitTime = statisticsProvider.getTimer(COMMIT_TIME, StatsOptions.DEFAULT);
        this.queueingTime = statisticsProvider.getTimer(QUEUEING_TIME, StatsOptions.DEFAULT);
    }

    @Override
    public void onCommit() {
        this.commitsCount.mark();
    }

    @Override
    public void onCommitQueued() {
        this.commitQueueSize.inc();
    }

    @Override
    public void onCommitDequeued() {
        this.commitQueueSize.dec();
    }

    @Override
    public void committedAfter(long time) {
        this.commitTime.update(time, TimeUnit.NANOSECONDS);
    }

    @Override
    public void dequeuedAfter(long time) {
        this.queueingTime.update(time, TimeUnit.NANOSECONDS);
    }

    @Override
    public CompositeData getCommitsCount() {
        return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.getTimeSeries(COMMITS_COUNT), (String)COMMITS_COUNT);
    }

    @Override
    public CompositeData getQueuingCommitsCount() {
        return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.getTimeSeries(COMMIT_QUEUE_SIZE), (String)COMMIT_QUEUE_SIZE);
    }

    @Override
    public CompositeData getCommitTimes() {
        return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.getTimeSeries(COMMIT_TIME), (String)COMMIT_TIME);
    }

    @Override
    public CompositeData getQueuingTimes() {
        return TimeSeriesStatsUtil.asCompositeData((TimeSeries)this.getTimeSeries(QUEUEING_TIME), (String)QUEUEING_TIME);
    }

    private TimeSeries getTimeSeries(String name) {
        return this.statisticsProvider.getStats().getTimeSeries(name, true);
    }
}

