/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Supplier;
import com.google.common.io.Closer;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.jackrabbit.commons.SimpleValueFactory;
import org.apache.jackrabbit.oak.api.Descriptors;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.api.jmx.CheckpointMBean;
import org.apache.jackrabbit.oak.api.jmx.FileStoreBackupRestoreMBean;
import org.apache.jackrabbit.oak.backup.impl.FileStoreBackupRestoreImpl;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.osgi.ObserverTracker;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.blob.BlobGC;
import org.apache.jackrabbit.oak.plugins.blob.BlobGCMBean;
import org.apache.jackrabbit.oak.plugins.blob.BlobGarbageCollector;
import org.apache.jackrabbit.oak.plugins.blob.BlobReferenceRetriever;
import org.apache.jackrabbit.oak.plugins.blob.BlobTrackingStore;
import org.apache.jackrabbit.oak.plugins.blob.MarkSweepGarbageCollector;
import org.apache.jackrabbit.oak.plugins.blob.SharedDataStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.BlobIdTracker;
import org.apache.jackrabbit.oak.plugins.blob.datastore.BlobTracker;
import org.apache.jackrabbit.oak.plugins.blob.datastore.SharedDataStoreUtils;
import org.apache.jackrabbit.oak.plugins.identifier.ClusterRepositoryInfo;
import org.apache.jackrabbit.oak.segment.Closeables;
import org.apache.jackrabbit.oak.segment.Configuration;
import org.apache.jackrabbit.oak.segment.DefaultSegmentStoreProvider;
import org.apache.jackrabbit.oak.segment.Registrations;
import org.apache.jackrabbit.oak.segment.SegmentBlobReferenceRetriever;
import org.apache.jackrabbit.oak.segment.SegmentCheckpointMBean;
import org.apache.jackrabbit.oak.segment.SegmentDiscoveryLiteDescriptors;
import org.apache.jackrabbit.oak.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreBuilders;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreStatsMBean;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundExceptionListener;
import org.apache.jackrabbit.oak.segment.SegmentStoreProvider;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.compaction.SegmentRevisionGC;
import org.apache.jackrabbit.oak.segment.compaction.SegmentRevisionGCMBean;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.FileStoreGCMonitor;
import org.apache.jackrabbit.oak.segment.file.FileStoreStatsMBean;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.gc.GCMonitorTracker;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.RevisionGC;
import org.apache.jackrabbit.oak.spi.state.RevisionGCMBean;
import org.apache.jackrabbit.oak.spi.whiteboard.AbstractServiceTracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardExecutor;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.util.GenericDescriptors;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE, metatype=true, label="Oak Segment Tar NodeStore service", description="Apache Jackrabbit Oak NodeStore implementation based on the segment model. For configuration refer to http://jackrabbit.apache.org/oak/docs/osgi_config.html#SegmentNodeStore. Note that for system stability purpose it is advisable to not change these settings at runtime. Instead the config change should be done via file system based config file and this view should ONLY be used to determine which options are supported.")
public class SegmentNodeStoreService {
    private static final Logger log = LoggerFactory.getLogger(SegmentNodeStoreService.class);
    @Property(label="Repository Home Directory", description="Path on the file system where repository data will be stored. Defaults to the value of the framework property 'repository.home' or to 'repository' if that is neither specified.")
    public static final String REPOSITORY_HOME_DIRECTORY = "repository.home";
    @Property(label="Mode", description="TarMK mode (64 for memory mapped file access, 32 for normal file access). Default value is taken from the 'sun.arch.data.model' system property.")
    public static final String MODE = "tarmk.mode";
    @Property(intValue={256}, label="Maximum tar file size (MB)", description="The maximum size of the tar files in megabytes. Default value is '256'.")
    public static final String SIZE = "tarmk.size";
    @Property(intValue={256}, label="Segment cache size (MB)", description="Cache size for storing most recently used segments in megabytes. Default value is '256'.")
    public static final String SEGMENT_CACHE_SIZE = "segmentCache.size";
    @Property(intValue={256}, label="String cache size (MB)", description="Cache size for storing most recently used strings in megabytes. Default value is '256'.")
    public static final String STRING_CACHE_SIZE = "stringCache.size";
    @Property(intValue={64}, label="Template cache size (MB)", description="Cache size for storing most recently used templates in megabytes. Default value is '64'.")
    public static final String TEMPLATE_CACHE_SIZE = "templateCache.size";
    @Property(intValue={15000}, label="String deduplication cache size (#items)", description="Maximum number of strings to keep in the deduplication cache. Default value is '15000'.")
    public static final String STRING_DEDUPLICATION_CACHE_SIZE = "stringDeduplicationCache.size";
    @Property(intValue={3000}, label="Template deduplication cache size (#items)", description="Maximum number of templates to keep in the deduplication cache. Default value is '3000'.")
    public static final String TEMPLATE_DEDUPLICATION_CACHE_SIZE = "templateDeduplicationCache.size";
    @Property(intValue={0x100000}, label="Node deduplication cache size (#items)", description="Maximum number of node to keep in the deduplication cache. If the supplied value is not a power of 2, it will be rounded up to the next power of 2. Default value is '1048576'.")
    public static final String NODE_DEDUPLICATION_CACHE_SIZE = "nodeDeduplicationCache.size";
    @Property(boolValue={false}, label="Pause compaction", description="When set to true the compaction phase is skipped during garbage collection. Default value is 'false'.")
    public static final String PAUSE_COMPACTION = "pauseCompaction";
    @Property(intValue={5}, label="Compaction retries", description="Number of tries to compact concurrent commits on top of already compacted commits. Default value is '5'.")
    public static final String COMPACTION_RETRY_COUNT = "compaction.retryCount";
    @Property(intValue={60}, label="Force compaction timeout", description="Number of seconds to attempt to force compact concurrent commits on top of already compacted commits after the maximum number of retries has been reached. Forced compaction tries to acquire an exclusive write lock on the node store, blocking concurrent write access as long as the lock is held. Default value is '60'.")
    public static final String COMPACTION_FORCE_TIMEOUT = "compaction.force.timeout";
    @Property(longValue={0x40000000L}, label="Garbage collection repository size threshold", description="Garbage collection will be skipped unless the repository grew at least by the number of bytes specified. Default value is '1073741824'.")
    public static final String COMPACTION_SIZE_DELTA_ESTIMATION = "compaction.sizeDeltaEstimation";
    @Property(boolValue={false}, label="Disable estimation phase", description="Disables the estimation phase allowing garbage collection to run unconditionally. Default value is 'false'.")
    public static final String COMPACTION_DISABLE_ESTIMATION = "compaction.disableEstimation";
    @Property(intValue={2}, label="Compaction retained generations", description="Number of segment generations to retain during garbage collection. Must be set to at least 2. Default value is '2'.")
    public static final String RETAINED_GENERATIONS = "compaction.retainedGenerations";
    @Property(intValue={15}, label="Compaction memory threshold", description="Threshold of available heap memory in percent of total heap memory below which the compaction phase is canceled. 0 disables heap memory monitoring. Default value is '15'.")
    public static final String MEMORY_THRESHOLD = "compaction.memoryThreshold";
    @Property(longValue={-1L}, label="Compaction progress log", description="The number of nodes compacted after which a status message is logged. -1 disables progress logging. Default value is '-1'.")
    public static final String GC_PROGRESS_LOG = "compaction.progressLog";
    @Property(boolValue={false}, label="Standby mode", description="Flag indicating this component will not register as a NodeStore but as a NodeStoreProvider instead. Default value is 'false'.")
    public static final String STANDBY = "standby";
    @Property(boolValue={false}, label="Custom blob store", description="Boolean value indicating that a custom BlobStore is used for storing large binary values.")
    public static final String CUSTOM_BLOB_STORE = "customBlobStore";
    @Property(label="Backup directory", description="Directory (relative to current working directory) for storing repository backups. Defaults to 'repository.home/segmentstore-backup'.")
    public static final String BACKUP_DIRECTORY = "repository.backup.dir";
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY, target="(&(!(split.blobstore=old))(!(split.blobstore=new)))")
    private volatile BlobStore blobStore;
    @Reference
    private StatisticsProvider statisticsProvider = StatisticsProvider.NOOP;
    private Closer closer;
    static final long DEFAULT_BLOB_GC_MAX_AGE = 86400L;
    @Property(longValue={86400L}, label="Blob gc max age (in secs)", description="The blob garbage collection logic will only consider those blobs which are not accessed recently (currentTime - lastModifiedTime > blobGcMaxAgeInSecs). For example with the default setting only those blobs which have been created at least 24 hours ago will be considered for garbage collection. Default value is '86400'.")
    public static final String PROP_BLOB_GC_MAX_AGE = "blobGcMaxAgeInSecs";
    static final long DEFAULT_BLOB_SNAPSHOT_INTERVAL = 43200L;
    @Property(longValue={43200L}, label="Blob tracking snapshot interval", description="Interval in seconds in which snapshots of locally tracked blob ids are taken and synchronized with the blob store. This should be configured to be less than the frequency of blob garbage collection so that deletions during blob garbage collection can be accounted for in the next garbage collection execution. Default value is '43200'.")
    public static final String PROP_BLOB_SNAPSHOT_INTERVAL = "blobTrackSnapshotIntervalInSecs";

    @Activate
    public void activate(ComponentContext context) throws IOException {
        Configuration configuration = new Configuration(context);
        if (this.blobStore == null && configuration.hasCustomBlobStore()) {
            log.info("BlobStore enabled. SegmentNodeStore will be initialized once the blob store becomes available");
            return;
        }
        this.closer = Closer.create();
        OsgiWhiteboard whiteboard = new OsgiWhiteboard(context.getBundleContext());
        SegmentNodeStoreService.registerSegmentStore(context, this.blobStore, this.statisticsProvider, this.closer, (Whiteboard)whiteboard, null, true);
    }

    static SegmentNodeStore registerSegmentStore(@Nonnull ComponentContext context, @Nullable BlobStore blobStore, @Nonnull StatisticsProvider statisticsProvider, @Nonnull Closer closer, @Nonnull Whiteboard whiteboard, @Nullable String role, boolean descriptors) throws IOException {
        CacheStatsMBean nodeDeduplicationCacheStats;
        CacheStatsMBean templateDeduplicationCacheStats;
        FileStore store;
        Configuration configuration = new Configuration(context, role);
        Closeables closeables = new Closeables(closer);
        Registrations registrations = new Registrations(whiteboard, role);
        GCMonitor gcMonitor = GCMonitor.EMPTY;
        if (configuration.isPrimarySegmentStore()) {
            GCMonitorTracker tracker = new GCMonitorTracker();
            tracker.start(whiteboard);
            closeables.add((AbstractServiceTracker<?>)tracker);
            gcMonitor = tracker;
        }
        if (configuration.getCompactionGainThreshold() != null) {
            log.warn("Detected deprecated flag 'compaction.gainThreshold'. Please use 'compaction.sizeDeltaEstimation' instead and 'compaction.disableEstimation' to disable estimation.");
        }
        SegmentGCOptions gcOptions = new SegmentGCOptions(configuration.getPauseCompaction(), configuration.getRetryCount(), configuration.getForceCompactionTimeout()).setRetainedGenerations(configuration.getRetainedGenerations()).setGcSizeDeltaEstimation(configuration.getSizeDeltaEstimation()).setMemoryThreshold(configuration.getMemoryThreshold()).setEstimationDisabled(configuration.getDisableEstimation()).withGCNodeWriteMonitor(configuration.getGCProcessLog());
        FileStoreBuilder builder = FileStoreBuilder.fileStoreBuilder(configuration.getSegmentDirectory()).withSegmentCacheSize(configuration.getSegmentCacheSize()).withStringCacheSize(configuration.getStringCacheSize()).withTemplateCacheSize(configuration.getTemplateCacheSize()).withStringDeduplicationCacheSize(configuration.getStringDeduplicationCacheSize()).withTemplateDeduplicationCacheSize(configuration.getTemplateDeduplicationCacheSize()).withNodeDeduplicationCacheSize(configuration.getNodeDeduplicationCacheSize()).withMaxFileSize(configuration.getMaxFileSize()).withMemoryMapping(configuration.getMemoryMapping()).withGCMonitor(gcMonitor).withStatisticsProvider(statisticsProvider).withGCOptions(gcOptions);
        if (configuration.hasCustomBlobStore() && blobStore != null) {
            log.info("Initializing SegmentNodeStore with BlobStore [{}]", (Object)blobStore);
            builder.withBlobStore(blobStore);
        }
        if (configuration.isStandbyInstance()) {
            builder.withSnfeListener(SegmentNotFoundExceptionListener.IGNORE_SNFE);
        }
        try {
            store = builder.build();
        }
        catch (InvalidFileStoreVersionException e) {
            log.error("The storage format is not compatible with this version of Oak Segment Tar", (Throwable)e);
            return null;
        }
        closeables.add(store);
        WhiteboardExecutor executor = new WhiteboardExecutor();
        executor.start(whiteboard);
        closeables.add((AbstractServiceTracker<?>)executor);
        CacheStatsMBean segmentCacheStats = store.getSegmentCacheStats();
        closeables.add(registrations.registerMBean(CacheStatsMBean.class, segmentCacheStats, "CacheStats", segmentCacheStats.getName()));
        CacheStatsMBean stringCacheStats = store.getStringCacheStats();
        closeables.add(registrations.registerMBean(CacheStatsMBean.class, stringCacheStats, "CacheStats", stringCacheStats.getName()));
        CacheStatsMBean templateCacheStats = store.getTemplateCacheStats();
        closeables.add(registrations.registerMBean(CacheStatsMBean.class, templateCacheStats, "CacheStats", templateCacheStats.getName()));
        CacheStatsMBean stringDeduplicationCacheStats = store.getStringDeduplicationCacheStats();
        if (stringDeduplicationCacheStats != null) {
            closeables.add(registrations.registerMBean(CacheStatsMBean.class, stringDeduplicationCacheStats, "CacheStats", stringDeduplicationCacheStats.getName()));
        }
        if ((templateDeduplicationCacheStats = store.getTemplateDeduplicationCacheStats()) != null) {
            closeables.add(registrations.registerMBean(CacheStatsMBean.class, templateDeduplicationCacheStats, "CacheStats", templateDeduplicationCacheStats.getName()));
        }
        if ((nodeDeduplicationCacheStats = store.getNodeDeduplicationCacheStats()) != null) {
            closeables.add(registrations.registerMBean(CacheStatsMBean.class, nodeDeduplicationCacheStats, "CacheStats", nodeDeduplicationCacheStats.getName()));
        }
        if (configuration.isPrimarySegmentStore()) {
            final FileStoreGCMonitor monitor = new FileStoreGCMonitor(Clock.SIMPLE);
            closeables.add(registrations.register(GCMonitor.class, monitor));
            closeables.add(registrations.registerMBean(SegmentRevisionGC.class, new SegmentRevisionGCMBean(store, gcOptions, monitor), "SegmentRevisionGarbageCollection", "Segment node store revision garbage collection"));
            Runnable cancelGC = new Runnable(){

                @Override
                public void run() {
                    store.cancelGC();
                }
            };
            Supplier<String> statusMessage = new Supplier<String>(){

                public String get() {
                    return monitor.getStatus();
                }
            };
            closeables.add(registrations.registerMBean(RevisionGCMBean.class, new RevisionGC(store.getGCRunner(), cancelGC, (Supplier)statusMessage, (Executor)executor), "RevisionGarbageCollection", "Revision garbage collection"));
        }
        closeables.add(registrations.registerMBean(FileStoreStatsMBean.class, store.getStats(), "FileStoreStats", "FileStore statistics"));
        SegmentNodeStore.SegmentNodeStoreBuilder segmentNodeStoreBuilder = SegmentNodeStoreBuilders.builder(store).withStatisticsProvider(statisticsProvider);
        if (configuration.isStandbyInstance() || !configuration.isPrimarySegmentStore()) {
            segmentNodeStoreBuilder.dispatchChanges(false);
        }
        SegmentNodeStore segmentNodeStore = segmentNodeStoreBuilder.build();
        if (configuration.isPrimarySegmentStore()) {
            ObserverTracker observerTracker = new ObserverTracker((Observable)segmentNodeStore);
            observerTracker.start(context.getBundleContext());
            closeables.add(observerTracker);
        }
        if (configuration.isPrimarySegmentStore()) {
            closeables.add(registrations.registerMBean(CheckpointMBean.class, new SegmentCheckpointMBean(segmentNodeStore), "CheckpointManager", "Segment node store checkpoint management"));
        }
        if (descriptors) {
            GenericDescriptors clusterIdDesc = new GenericDescriptors();
            clusterIdDesc.put("oak.clusterid", new SimpleValueFactory().createValue(ClusterRepositoryInfo.getOrCreateId((NodeStore)segmentNodeStore)), true, false);
            closeables.add(registrations.register(Descriptors.class, clusterIdDesc));
            closeables.add(registrations.register(Descriptors.class, new SegmentDiscoveryLiteDescriptors(segmentNodeStore)));
        }
        if (configuration.isPrimarySegmentStore() && SharedDataStoreUtils.isShared((BlobStore)blobStore)) {
            SharedDataStore sharedDataStore = (SharedDataStore)blobStore;
            try {
                sharedDataStore.addMetadataRecord((InputStream)new ByteArrayInputStream(new byte[0]), SharedDataStoreUtils.SharedStoreRecordType.REPOSITORY.getNameFromId(ClusterRepositoryInfo.getOrCreateId((NodeStore)segmentNodeStore)));
            }
            catch (Exception e) {
                throw new IOException("Could not register a unique repositoryId", e);
            }
            if (blobStore instanceof BlobTrackingStore) {
                BlobTrackingStore trackingStore = (BlobTrackingStore)blobStore;
                if (trackingStore.getTracker() != null) {
                    trackingStore.getTracker().close();
                }
                trackingStore.addTracker((BlobTracker)new BlobIdTracker(configuration.getRepositoryHome(), ClusterRepositoryInfo.getOrCreateId((NodeStore)segmentNodeStore), configuration.getBlobSnapshotInterval(), sharedDataStore));
            }
        }
        if (configuration.isPrimarySegmentStore() && blobStore instanceof GarbageCollectableBlobStore) {
            MarkSweepGarbageCollector gc = new MarkSweepGarbageCollector((BlobReferenceRetriever)new SegmentBlobReferenceRetriever(store), (GarbageCollectableBlobStore)blobStore, (Executor)executor, TimeUnit.SECONDS.toMillis(configuration.getBlobGcMaxAge()), ClusterRepositoryInfo.getOrCreateId((NodeStore)segmentNodeStore));
            closeables.add(registrations.registerMBean(BlobGCMBean.class, new BlobGC((BlobGarbageCollector)gc, (Executor)executor), "BlobGarbageCollection", "Segment node store blob garbage collection"));
        }
        closeables.add(registrations.registerMBean(FileStoreBackupRestoreMBean.class, new FileStoreBackupRestoreImpl(segmentNodeStore, store.getRevisions(), store.getReader(), configuration.getBackupDirectory(), (Executor)executor), "FileStoreBackupRestore", "Segment node store backup/restore"));
        closeables.add(registrations.registerMBean(SegmentNodeStoreStatsMBean.class, segmentNodeStore.getStats(), "SegmentStoreStats", "SegmentNodeStore statistics"));
        if (configuration.isPrimarySegmentStore()) {
            log.info("Primary SegmentNodeStore initialized");
        } else {
            log.info("Secondary SegmentNodeStore initialized, role={}", (Object)role);
        }
        closeables.add(registrations.register(SegmentStoreProvider.class, new DefaultSegmentStoreProvider(store)));
        if (configuration.isStandbyInstance()) {
            return segmentNodeStore;
        }
        if (configuration.isPrimarySegmentStore()) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("service.pid", SegmentNodeStore.class.getName());
            props.put("oak.nodestore.description", new String[]{"nodeStoreType=segment"});
            closeables.add(registrations.register(NodeStore.class, segmentNodeStore, props));
        }
        return segmentNodeStore;
    }

    @Deactivate
    public void deactivate() {
        IOUtils.closeQuietly((Closeable)this.closer);
        this.closer = null;
    }

    protected void bindBlobStore(BlobStore blobStore) {
        this.blobStore = blobStore;
    }

    protected void unbindBlobStore(BlobStore blobStore) {
        if (this.blobStore == blobStore) {
            this.blobStore = null;
        }
    }

    protected void bindStatisticsProvider(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
    }

    protected void unbindStatisticsProvider(StatisticsProvider statisticsProvider) {
        if (this.statisticsProvider == statisticsProvider) {
            this.statisticsProvider = null;
        }
    }
}

