/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.segment.CacheWeights;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentId;

public class SegmentCache {
    public static final int DEFAULT_SEGMENT_CACHE_MB = 256;
    private final Weigher<SegmentId, Segment> weigher = new CacheWeights.SegmentCacheWeigher();
    private final long maximumWeight;
    @Nonnull
    private final Cache<SegmentId, Segment> cache;

    public SegmentCache(long cacheSizeMB) {
        this.maximumWeight = cacheSizeMB * 1024L * 1024L;
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(16).recordStats().maximumWeight(this.maximumWeight).weigher(this.weigher).removalListener((RemovalListener)new RemovalListener<SegmentId, Segment>(){

            public void onRemoval(@Nonnull RemovalNotification<SegmentId, Segment> notification) {
                SegmentId id = (SegmentId)notification.getKey();
                if (id != null) {
                    id.unloaded();
                }
            }
        }).build();
    }

    @Nonnull
    public Segment getSegment(@Nonnull SegmentId id, @Nonnull Callable<Segment> loader) throws ExecutionException {
        try {
            Segment segment = loader.call();
            this.cache.put((Object)id, (Object)segment);
            id.loaded(segment);
            return segment;
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public void putSegment(@Nonnull Segment segment) {
        SegmentId segmentId = segment.getSegmentId();
        this.cache.put((Object)segmentId, (Object)segment);
        segmentId.loaded(segment);
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    @Nonnull
    public CacheStats getCacheStats() {
        return new CacheStats(this.cache, "Segment Cache", this.weigher, this.maximumWeight);
    }
}

