/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.io.HexDump;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.segment.IdentityRecordNumbers;
import org.apache.jackrabbit.oak.segment.IllegalSegmentReferences;
import org.apache.jackrabbit.oak.segment.ImmutableRecordNumbers;
import org.apache.jackrabbit.oak.segment.ListRecord;
import org.apache.jackrabbit.oak.segment.PropertyTemplate;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.RecordNumbers;
import org.apache.jackrabbit.oak.segment.RecordType;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentReferences;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.SegmentStream;
import org.apache.jackrabbit.oak.segment.SegmentVersion;
import org.apache.jackrabbit.oak.segment.Template;

public class Segment {
    static final int HEADER_SIZE = 32;
    static final int SEGMENT_REFERENCE_SIZE = 16;
    static final int RECORD_SIZE = 9;
    static final int RECORD_ID_BYTES = 6;
    static final int SEGMENT_REFERENCE_LIMIT = 255;
    public static final int RECORD_ALIGN_BITS = 2;
    public static final int MAX_SEGMENT_SIZE = 262144;
    static final int SMALL_LIMIT = 128;
    public static final int MEDIUM_LIMIT = 16512;
    public static final int BLOB_ID_SMALL_LIMIT = 4096;
    public static final int GC_GENERATION_OFFSET = 10;
    public static final int REFERENCED_SEGMENT_ID_COUNT_OFFSET = 14;
    public static final int RECORD_NUMBER_COUNT_OFFSET = 18;
    @Nonnull
    private final SegmentStore store;
    @Nonnull
    private final SegmentReader reader;
    @Nonnull
    private final SegmentId id;
    @Nonnull
    private final ByteBuffer data;
    @Nonnull
    private final SegmentVersion version;
    private final RecordNumbers recordNumbers;
    private final SegmentReferences segmentReferences;
    private volatile String info;

    public static int align(int address, int boundary) {
        return address + boundary - 1 & ~(boundary - 1);
    }

    public Segment(@Nonnull SegmentStore store, @Nonnull SegmentReader reader, final @Nonnull SegmentId id, final @Nonnull ByteBuffer data) {
        this.store = (SegmentStore)Preconditions.checkNotNull((Object)store);
        this.reader = (SegmentReader)Preconditions.checkNotNull((Object)reader);
        this.id = (SegmentId)Preconditions.checkNotNull((Object)id);
        this.data = (ByteBuffer)Preconditions.checkNotNull((Object)data);
        if (id.isDataSegmentId()) {
            byte segmentVersion = data.get(3);
            Preconditions.checkState((data.get(0) == 48 && data.get(1) == 97 && data.get(2) == 75 && SegmentVersion.isValid(segmentVersion) ? 1 : 0) != 0, (Object)new Object(){

                public String toString() {
                    return "Invalid segment format. Dumping segment " + id + "\n" + Segment.toHex(data.array());
                }
            });
            this.version = SegmentVersion.fromByte(segmentVersion);
            this.recordNumbers = this.readRecordNumberOffsets();
            this.segmentReferences = this.readReferencedSegments();
        } else {
            this.version = SegmentVersion.LATEST_VERSION;
            this.recordNumbers = new IdentityRecordNumbers();
            this.segmentReferences = new IllegalSegmentReferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toHex(byte[] bytes) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            HexDump.dump((byte[])bytes, (long)0L, (OutputStream)out, (int)0);
            String string = out.toString(Charsets.UTF_8.name());
            return string;
        }
        catch (IOException e) {
            String string = "Error dumping segment: " + e.getMessage();
            return string;
        }
        finally {
            IOUtils.closeQuietly((Closeable)out);
        }
    }

    private RecordNumbers readRecordNumberOffsets() {
        int recordNumberCount = this.getRecordNumberCount();
        if (recordNumberCount == 0) {
            return RecordNumbers.EMPTY_RECORD_NUMBERS;
        }
        int position = 32 + this.data.position() + this.getReferencedSegmentIdCount() * 16;
        int maxIndex = this.data.getInt(position + (recordNumberCount - 1) * 9);
        byte[] types = new byte[maxIndex + 1];
        int[] offsets = new int[maxIndex + 1];
        Arrays.fill(offsets, -1);
        for (int i = 0; i < recordNumberCount; ++i) {
            int recordNumber = this.data.getInt(position);
            types[recordNumber] = this.data.get(position += 4);
            offsets[recordNumber] = this.data.getInt(++position);
            position += 4;
        }
        return new ImmutableRecordNumbers(offsets, types);
    }

    private SegmentReferences readReferencedSegments() {
        Preconditions.checkState((this.getReferencedSegmentIdCount() + 1 < 65535 ? 1 : 0) != 0, (Object)"Segment cannot have more than 0xffff references");
        final int referencedSegmentIdCount = this.getReferencedSegmentIdCount();
        final int refOffset = this.data.position() + 32;
        final SegmentId[] refIds = new SegmentId[referencedSegmentIdCount];
        return new SegmentReferences(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public SegmentId getSegmentId(int reference) {
                Preconditions.checkArgument((reference <= referencedSegmentIdCount ? 1 : 0) != 0);
                SegmentId id = refIds[reference - 1];
                if (id != null) return id;
                SegmentId[] segmentIdArray = refIds;
                synchronized (refIds) {
                    id = refIds[reference - 1];
                    if (id != null) return id;
                    int position = refOffset + (reference - 1) * 16;
                    long msb = Segment.this.data.getLong(position);
                    long lsb = Segment.this.data.getLong(position + 8);
                    refIds[reference - 1] = id = Segment.this.store.newSegmentId(msb, lsb);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return id;
                }
            }

            @Override
            public Iterator<SegmentId> iterator() {
                return new AbstractIterator<SegmentId>(){
                    private int reference = 1;

                    protected SegmentId computeNext() {
                        if (this.reference <= referencedSegmentIdCount) {
                            return this.getSegmentId(this.reference++);
                        }
                        return (SegmentId)this.endOfData();
                    }
                };
            }
        };
    }

    Segment(@Nonnull SegmentStore store, @Nonnull SegmentReader reader, @Nonnull byte[] buffer, @Nonnull RecordNumbers recordNumbers, @Nonnull SegmentReferences segmentReferences, @Nonnull String info) {
        this.store = (SegmentStore)Preconditions.checkNotNull((Object)store);
        this.reader = (SegmentReader)Preconditions.checkNotNull((Object)reader);
        this.id = store.newDataSegmentId();
        this.info = (String)Preconditions.checkNotNull((Object)info);
        this.data = ByteBuffer.wrap((byte[])Preconditions.checkNotNull((Object)buffer));
        this.version = SegmentVersion.fromByte(buffer[3]);
        this.recordNumbers = recordNumbers;
        this.segmentReferences = segmentReferences;
        this.id.loaded(this);
    }

    public SegmentVersion getSegmentVersion() {
        return this.version;
    }

    private int pos(int recordNumber, int length) {
        return this.pos(recordNumber, 0, 0, length);
    }

    private int pos(int recordNumber, int rawOffset, int length) {
        return this.pos(recordNumber, rawOffset, 0, length);
    }

    private int pos(int recordNumber, int rawOffset, int recordIdOffset, int length) {
        int offset = this.recordNumbers.getOffset(recordNumber);
        if (offset == -1) {
            throw new IllegalStateException("invalid record number");
        }
        int base = offset + rawOffset + recordIdOffset * 6;
        Preconditions.checkPositionIndexes((int)base, (int)(base + length), (int)262144);
        int pos = this.data.limit() - 262144 + base;
        Preconditions.checkState((pos >= this.data.position() ? 1 : 0) != 0);
        return pos;
    }

    public SegmentId getSegmentId() {
        return this.id;
    }

    public int getReferencedSegmentIdCount() {
        return this.data.getInt(14);
    }

    public int getRecordNumberCount() {
        return this.data.getInt(18);
    }

    public UUID getReferencedSegmentId(int index) {
        return this.segmentReferences.getSegmentId(index + 1).asUUID();
    }

    public static int getGcGeneration(ByteBuffer data, UUID segmentId) {
        return SegmentId.isDataSegmentId(segmentId.getLeastSignificantBits()) ? data.getInt(10) : 0;
    }

    public int getGcGeneration() {
        return Segment.getGcGeneration(this.data, this.id.asUUID());
    }

    @CheckForNull
    public String getSegmentInfo() {
        if (this.info == null && this.id.isDataSegmentId()) {
            this.info = this.readString(((RecordNumbers.Entry)this.recordNumbers.iterator().next()).getRecordNumber());
        }
        return this.info;
    }

    public int size() {
        return this.data.remaining();
    }

    byte readByte(int recordNumber) {
        return this.readByte(recordNumber, 0);
    }

    byte readByte(int recordNumber, int offset) {
        return this.data.get(this.pos(recordNumber, offset, 1));
    }

    short readShort(int recordNumber) {
        return this.data.getShort(this.pos(recordNumber, 2));
    }

    int readInt(int recordNumber) {
        return this.data.getInt(this.pos(recordNumber, 4));
    }

    int readInt(int recordNumber, int offset) {
        return this.data.getInt(this.pos(recordNumber, offset, 4));
    }

    long readLong(int recordNumber) {
        return this.data.getLong(this.pos(recordNumber, 8));
    }

    void readBytes(int recordNumber, byte[] buffer, int offset, int length) {
        this.readBytes(recordNumber, 0, buffer, offset, length);
    }

    void readBytes(int recordNumber, int position, byte[] buffer, int offset, int length) {
        Preconditions.checkNotNull((Object)buffer);
        Preconditions.checkPositionIndexes((int)offset, (int)(offset + length), (int)buffer.length);
        ByteBuffer d = this.data.duplicate();
        d.position(this.pos(recordNumber, position, length));
        d.get(buffer, offset, length);
    }

    RecordId readRecordId(int recordNumber, int rawOffset, int recordIdOffset) {
        return this.internalReadRecordId(this.pos(recordNumber, rawOffset, recordIdOffset, 6));
    }

    RecordId readRecordId(int recordNumber, int rawOffset) {
        return this.readRecordId(recordNumber, rawOffset, 0);
    }

    RecordId readRecordId(int recordNumber) {
        return this.readRecordId(recordNumber, 0, 0);
    }

    private RecordId internalReadRecordId(int pos) {
        SegmentId segmentId = this.dereferenceSegmentId(Segment.asUnsigned(this.data.getShort(pos)));
        return new RecordId(segmentId, this.data.getInt(pos + 2));
    }

    private static int asUnsigned(short value) {
        return value & 0xFFFF;
    }

    private SegmentId dereferenceSegmentId(int reference) {
        if (reference == 0) {
            return this.id;
        }
        SegmentId id = this.segmentReferences.getSegmentId(reference);
        if (id == null) {
            throw new IllegalStateException("Referenced segment not found");
        }
        return id;
    }

    @Nonnull
    String readString(int offset) {
        int pos = this.pos(offset, 1);
        long length = this.internalReadLength(pos);
        if (length < 128L) {
            byte[] bytes = new byte[(int)length];
            ByteBuffer buffer = this.data.duplicate();
            buffer.position(pos + 1);
            buffer.get(bytes);
            return new String(bytes, Charsets.UTF_8);
        }
        if (length < 16512L) {
            byte[] bytes = new byte[(int)length];
            ByteBuffer buffer = this.data.duplicate();
            buffer.position(pos + 2);
            buffer.get(bytes);
            return new String(bytes, Charsets.UTF_8);
        }
        if (length < Integer.MAX_VALUE) {
            int size = (int)((length + 4096L - 1L) / 4096L);
            ListRecord list = new ListRecord(this.internalReadRecordId(pos + 8), size);
            try (SegmentStream stream = new SegmentStream(new RecordId(this.id, offset), list, length);){
                String string = stream.getString();
                return string;
            }
        }
        throw new IllegalStateException("String is too long: " + length);
    }

    @Nonnull
    Template readTemplate(int recordNumber) {
        int head = this.readInt(recordNumber);
        boolean hasPrimaryType = (head & Integer.MIN_VALUE) != 0;
        boolean hasMixinTypes = (head & 0x40000000) != 0;
        boolean zeroChildNodes = (head & 0x20000000) != 0;
        boolean manyChildNodes = (head & 0x10000000) != 0;
        int mixinCount = head >> 18 & 0x3FF;
        int propertyCount = head & 0x3FFFF;
        int offset = 4;
        PropertyState primaryType = null;
        if (hasPrimaryType) {
            RecordId primaryId = this.readRecordId(recordNumber, offset);
            primaryType = PropertyStates.createProperty((String)"jcr:primaryType", (Object)this.reader.readString(primaryId), (Type)Type.NAME);
            offset += 6;
        }
        PropertyState mixinTypes = null;
        if (hasMixinTypes) {
            String[] mixins = new String[mixinCount];
            for (int i = 0; i < mixins.length; ++i) {
                RecordId mixinId = this.readRecordId(recordNumber, offset);
                mixins[i] = this.reader.readString(mixinId);
                offset += 6;
            }
            mixinTypes = PropertyStates.createProperty((String)"jcr:mixinTypes", Arrays.asList(mixins), (Type)Type.NAMES);
        }
        String childName = Template.ZERO_CHILD_NODES;
        if (manyChildNodes) {
            childName = "";
        } else if (!zeroChildNodes) {
            RecordId childNameId = this.readRecordId(recordNumber, offset);
            childName = this.reader.readString(childNameId);
            offset += 6;
        }
        PropertyTemplate[] properties = this.readProps(propertyCount, recordNumber, offset);
        return new Template(this.reader, primaryType, mixinTypes, properties, childName);
    }

    private PropertyTemplate[] readProps(int propertyCount, int recordNumber, int offset) {
        PropertyTemplate[] properties = new PropertyTemplate[propertyCount];
        if (propertyCount > 0) {
            RecordId id = this.readRecordId(recordNumber, offset);
            ListRecord propertyNames = new ListRecord(id, properties.length);
            offset += 6;
            for (int i = 0; i < propertyCount; ++i) {
                byte type = this.readByte(recordNumber, offset++);
                properties[i] = new PropertyTemplate(i, this.reader.readString(propertyNames.getEntry(i)), Type.fromTag((int)Math.abs(type), (type < 0 ? 1 : 0) != 0));
            }
        }
        return properties;
    }

    static long readLength(RecordId id) {
        return id.getSegment().readLength(id.getRecordNumber());
    }

    long readLength(int recordNumber) {
        return this.internalReadLength(this.pos(recordNumber, 1));
    }

    private long internalReadLength(int pos) {
        int length;
        if (((length = this.data.get(pos++) & 0xFF) & 0x80) == 0) {
            return length;
        }
        if ((length & 0x40) == 0) {
            return ((length & 0x3F) << 8 | this.data.get(pos) & 0xFF) + 128;
        }
        return (((long)length & 0x3FL) << 56 | (long)(this.data.get(pos++) & 0xFF) << 48 | (long)(this.data.get(pos++) & 0xFF) << 40 | (long)(this.data.get(pos++) & 0xFF) << 32 | (long)(this.data.get(pos++) & 0xFF) << 24 | (long)(this.data.get(pos++) & 0xFF) << 16 | (long)(this.data.get(pos++) & 0xFF) << 8 | (long)(this.data.get(pos) & 0xFF)) + 16512L;
    }

    public String toString() {
        StringWriter string = new StringWriter();
        try (PrintWriter writer = new PrintWriter(string);){
            int length = this.data.remaining();
            writer.format("Segment %s (%d bytes)%n", this.id, length);
            String segmentInfo = this.getSegmentInfo();
            if (segmentInfo != null) {
                writer.format("Info: %s, Generation: %d%n", segmentInfo, this.getGcGeneration());
            }
            if (this.id.isDataSegmentId()) {
                writer.println("--------------------------------------------------------------------------");
                int i = 1;
                for (SegmentId segmentId : this.segmentReferences) {
                    writer.format("reference %02x: %s%n", i++, segmentId);
                }
                for (RecordNumbers.Entry entry : this.recordNumbers) {
                    writer.format("%10s record %08x: %08x%n", new Object[]{entry.getType(), entry.getRecordNumber(), entry.getOffset()});
                }
            }
            writer.println("--------------------------------------------------------------------------");
            for (int pos = this.data.limit() - (length + 15 & 0xFFFFFFF0); pos < this.data.limit(); pos += 16) {
                byte b;
                int i;
                writer.format("%04x: ", 262144 - this.data.limit() + pos >> 2);
                for (i = 0; i < 16; ++i) {
                    if (i > 0 && i % 4 == 0) {
                        writer.append(' ');
                    }
                    if (pos + i >= this.data.position()) {
                        b = this.data.get(pos + i);
                        writer.format("%02x ", b & 0xFF);
                        continue;
                    }
                    writer.append("   ");
                }
                writer.append(' ');
                for (i = 0; i < 16; ++i) {
                    if (pos + i >= this.data.position()) {
                        b = this.data.get(pos + i);
                        if (b >= 32 && b < 127) {
                            writer.append((char)b);
                            continue;
                        }
                        writer.append('.');
                        continue;
                    }
                    writer.append(' ');
                }
                writer.println();
            }
            writer.println("--------------------------------------------------------------------------");
            String string2 = string.toString();
            return string2;
        }
    }

    public void writeTo(OutputStream stream) throws IOException {
        ByteBuffer buffer = this.data.duplicate();
        WritableByteChannel channel = Channels.newChannel(stream);
        while (buffer.hasRemaining()) {
            channel.write(buffer);
        }
    }

    public void forEachRecord(RecordConsumer consumer) {
        for (RecordNumbers.Entry entry : this.recordNumbers) {
            consumer.consume(entry.getRecordNumber(), entry.getType(), entry.getOffset());
        }
    }

    public int estimateMemoryUsage() {
        int size = 88;
        size += 56;
        if (this.id.isDataSegmentId()) {
            int recordNumberCount = this.getRecordNumberCount();
            size += 5 * recordNumberCount;
            int referencedSegmentIdCount = this.getReferencedSegmentIdCount();
            size += 8 * referencedSegmentIdCount;
            size += StringUtils.estimateMemoryUsage((String)this.info);
        }
        if (!this.data.isDirect()) {
            size += this.size();
        }
        return size += this.id.estimateMemoryUsage();
    }

    public static interface RecordConsumer {
        public void consume(int var1, RecordType var2, int var3);
    }
}

