/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheStats;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;

public class RecordCacheStats
extends AnnotatedStandardMBean
implements CacheStatsMBean {
    @Nonnull
    private final String name;
    @Nonnull
    private final Supplier<CacheStats> stats;
    @Nonnull
    private final Supplier<Long> elementCount;
    @Nonnull
    private final Supplier<Long> weight;
    private CacheStats lastSnapshot;

    public RecordCacheStats(@Nonnull String name, @Nonnull Supplier<CacheStats> stats, @Nonnull Supplier<Long> elementCount, @Nonnull Supplier<Long> weight) {
        super(CacheStatsMBean.class);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.stats = (Supplier)Preconditions.checkNotNull(stats);
        this.elementCount = (Supplier)Preconditions.checkNotNull(elementCount);
        this.weight = (Supplier)Preconditions.checkNotNull(weight);
        this.lastSnapshot = (CacheStats)stats.get();
    }

    private CacheStats stats() {
        return ((CacheStats)this.stats.get()).minus(this.lastSnapshot);
    }

    public synchronized void resetStats() {
        this.lastSnapshot = (CacheStats)this.stats.get();
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public long getRequestCount() {
        return this.stats().requestCount();
    }

    public long getHitCount() {
        return this.stats().hitCount();
    }

    public double getHitRate() {
        return this.stats().hitRate();
    }

    public long getMissCount() {
        return this.stats().missCount();
    }

    public double getMissRate() {
        return this.stats().missRate();
    }

    public long getLoadCount() {
        return this.stats().loadCount();
    }

    public long getLoadSuccessCount() {
        return this.stats().loadSuccessCount();
    }

    public long getLoadExceptionCount() {
        return this.stats().loadExceptionCount();
    }

    public double getLoadExceptionRate() {
        return this.stats().loadExceptionRate();
    }

    public long getTotalLoadTime() {
        return this.stats().totalLoadTime();
    }

    public double getAverageLoadPenalty() {
        return this.stats().averageLoadPenalty();
    }

    public long getEvictionCount() {
        return this.stats().evictionCount();
    }

    public long getElementCount() {
        return (Long)this.elementCount.get();
    }

    public long getMaxTotalWeight() {
        return -1L;
    }

    public long estimateCurrentWeight() {
        return (Long)this.weight.get();
    }

    public String cacheInfoAsString() {
        return Objects.toStringHelper((String)("CacheStats(" + this.name + ")")).add("hitCount", this.getHitCount()).add("hitRate", (Object)String.format("%1.2f", this.getHitRate())).add("missCount", this.getMissCount()).add("missRate", (Object)String.format("%1.2f", this.getMissRate())).add("requestCount", this.getRequestCount()).add("loadCount", this.getLoadCount()).add("loadSuccessCount", this.getLoadSuccessCount()).add("loadExceptionCount", this.getLoadExceptionCount()).add("totalLoadTime", (Object)String.format("%d s", TimeUnit.NANOSECONDS.toSeconds(this.getTotalLoadTime()))).add("averageLoadPenalty ", (Object)String.format("%1.2f ns", this.getAverageLoadPenalty())).add("evictionCount", this.getEvictionCount()).add("elementCount", this.getElementCount()).add("totalWeight", (Object)IOUtils.humanReadableByteCount((long)this.estimateCurrentWeight())).add("maxWeight", (Object)IOUtils.humanReadableByteCount((long)this.getMaxTotalWeight())).add("currentWeights", (Object)IOUtils.humanReadableByteCount((long)this.estimateCurrentWeight())).toString();
    }
}

