/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.collect.AbstractIterator;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.jackrabbit.oak.segment.RecordNumbers;
import org.apache.jackrabbit.oak.segment.RecordType;

class MutableRecordNumbers
implements RecordNumbers {
    private int[] recordEntries = new int[16384];
    private int size;

    public MutableRecordNumbers() {
        Arrays.fill(this.recordEntries, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOffset(int recordNumber) {
        int recordEntry = MutableRecordNumbers.getRecordEntry(this.recordEntries, recordNumber);
        if (recordEntry == -1) {
            MutableRecordNumbers mutableRecordNumbers = this;
            synchronized (mutableRecordNumbers) {
                recordEntry = MutableRecordNumbers.getRecordEntry(this.recordEntries, recordNumber);
            }
        }
        return recordEntry;
    }

    private static int getRecordEntry(int[] entries, int index) {
        return index * 2 >= entries.length ? -1 : entries[index * 2];
    }

    @Override
    public synchronized Iterator<RecordNumbers.Entry> iterator() {
        return new AbstractIterator<RecordNumbers.Entry>(){
            final int[] entries;
            int index;
            {
                this.entries = Arrays.copyOf(MutableRecordNumbers.this.recordEntries, MutableRecordNumbers.this.size * 2);
                this.index = 0;
            }

            protected RecordNumbers.Entry computeNext() {
                if (this.index < this.entries.length) {
                    return new RecordNumbers.Entry(){
                        final int recordNumber;
                        final int offset;
                        final RecordType type;
                        {
                            this.recordNumber = index / 2;
                            this.offset = entries[index++];
                            this.type = RecordType.values()[entries[index++]];
                        }

                        @Override
                        public int getRecordNumber() {
                            return this.recordNumber;
                        }

                        @Override
                        public int getOffset() {
                            return this.offset;
                        }

                        @Override
                        public RecordType getType() {
                            return this.type;
                        }
                    };
                }
                return (RecordNumbers.Entry)this.endOfData();
            }
        };
    }

    public synchronized int size() {
        return this.size;
    }

    synchronized int addRecord(RecordType type, int offset) {
        if (this.recordEntries.length <= this.size * 2) {
            this.recordEntries = Arrays.copyOf(this.recordEntries, this.recordEntries.length * 2);
            Arrays.fill(this.recordEntries, this.recordEntries.length / 2, this.recordEntries.length, -1);
        }
        this.recordEntries[2 * this.size] = offset;
        this.recordEntries[2 * this.size + 1] = type.ordinal();
        return this.size++;
    }
}

